Rem
Rem $Header: mgwmsg.sql 16-jun-2003.08:28:57 chall Exp $
Rem
Rem mgwmsg.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem  NAME
Rem    mgwmsg.sql - package specification for MGW message helper package
Rem
Rem  DESCRIPTION
Rem    dbms_mgwmsg is a public helper package for working with MGW canonical
Rem    message types. It contains constant defintiions, utility procedures,
Rem    and so on.
Rem
Rem  NOTES
Rem    This script should be run from CATMGW.SQL (AS SYSDBA).
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       06/16/03 - add LCR/XML wrapper routines (bug 2995420)
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       10/29/02 - Created
Rem
Rem =========================================================================

--
-- dbms_mgwmsg
--
-- Helper package the Messaging Gateway canonical message types.
--

CREATE OR REPLACE PACKAGE dbms_mgwmsg AS 

  -- Value Types
  -- These represent valid values for mgw_name_value_t.type attribute.
  --
  TEXT_VALUE           CONSTANT BINARY_INTEGER := 1;
  RAW_VALUE            CONSTANT BINARY_INTEGER := 2;
  BOOLEAN_VALUE        CONSTANT BINARY_INTEGER := 3;
  BYTE_VALUE           CONSTANT BINARY_INTEGER := 4;
  SHORT_VALUE          CONSTANT BINARY_INTEGER := 5;
  INTEGER_VALUE        CONSTANT BINARY_INTEGER := 6;
  LONG_VALUE           CONSTANT BINARY_INTEGER := 7;
  FLOAT_VALUE          CONSTANT BINARY_INTEGER := 8;
  DOUBLE_VALUE         CONSTANT BINARY_INTEGER := 9;
  DATE_VALUE           CONSTANT BINARY_INTEGER := 10;

  -- Boolean Value
  -- Used for BOOLEAN_VALUE (represented as numeric datatype).
  --
  BOOLEAN_FALSE        CONSTANT BINARY_INTEGER := 0;
  BOOLEAN_TRUE         CONSTANT BINARY_INTEGER := 1;

  -- String Comparision:
  -- CASE_SENSITIVE    : Case-sensitive (exact) comparision.
  -- CASE_INSENSITIVE  : Case-insensitive comparision of the uppercased
  --                     (via NLS_UPPER) strings.
  --
  CASE_SENSITIVE        CONSTANT BINARY_INTEGER := 0;
  CASE_INSENSITIVE      CONSTANT BINARY_INTEGER := 1;

  -- TIB/Rendezvous Field Types
  -- These represent valid values for mgw_tibrv_field_t.field_type attribute.
  --
  TIBRVMSG_UNKNOWN         CONSTANT BINARY_INTEGER := 0;
  TIBRVMSG_BOOL            CONSTANT BINARY_INTEGER := 1;
  TIBRVMSG_F32             CONSTANT BINARY_INTEGER := 2;
  TIBRVMSG_F64             CONSTANT BINARY_INTEGER := 3;
  TIBRVMSG_I8              CONSTANT BINARY_INTEGER := 4;
  TIBRVMSG_I16             CONSTANT BINARY_INTEGER := 5;
  TIBRVMSG_I32             CONSTANT BINARY_INTEGER := 6;
  TIBRVMSG_I64             CONSTANT BINARY_INTEGER := 7;
  TIBRVMSG_IPADDR32        CONSTANT BINARY_INTEGER := 8;
  TIBRVMSG_IPPORT16        CONSTANT BINARY_INTEGER := 9;
  TIBRVMSG_DATETIME        CONSTANT BINARY_INTEGER := 10;
  TIBRVMSG_F32ARRAY        CONSTANT BINARY_INTEGER := 11;
  TIBRVMSG_F64ARRAY        CONSTANT BINARY_INTEGER := 12;
  TIBRVMSG_I8ARRAY         CONSTANT BINARY_INTEGER := 13;
  TIBRVMSG_I16ARRAY        CONSTANT BINARY_INTEGER := 14;
  TIBRVMSG_I32ARRAY        CONSTANT BINARY_INTEGER := 15;
  TIBRVMSG_I64ARRAY        CONSTANT BINARY_INTEGER := 16;
  TIBRVMSG_OPAQUE          CONSTANT BINARY_INTEGER := 17;
  TIBRVMSG_STRING          CONSTANT BINARY_INTEGER := 18;
  TIBRVMSG_XML             CONSTANT BINARY_INTEGER := 19;

  -- Java numeric ranges
  -- Useful for range checks between Java type and Oracle INTEGER (38-bit)
  --
  JAVA_BYTE_MINVAL         CONSTANT INTEGER := -128;         -- 8-bit
  JAVA_BYTE_MAXVAL         CONSTANT INTEGER := 127;

  JAVA_SHORT_MINVAL        CONSTANT INTEGER := -32768;       -- 16-bit
  JAVA_SHORT_MAXVAL        CONSTANT INTEGER := 32767;

  JAVA_INT_MINVAL          CONSTANT INTEGER := -2147483648;  -- 32-bit
  JAVA_INT_MAXVAL          CONSTANT INTEGER := 2147483647;


  PROCEDURE nvarray_add (
    p_array  IN OUT sys.mgw_name_value_array_t,
    p_value  IN sys.mgw_name_value_t );

  FUNCTION nvarray_get (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN sys.mgw_name_value_t;

  FUNCTION nvarray_get_boolean (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN INTEGER;

  FUNCTION nvarray_get_byte (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN INTEGER;

  FUNCTION nvarray_get_short (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN INTEGER;

  FUNCTION nvarray_get_integer (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN INTEGER;

  FUNCTION nvarray_get_long (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN NUMBER;

  FUNCTION nvarray_get_float (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN NUMBER;

  FUNCTION nvarray_get_double (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN NUMBER;

  FUNCTION nvarray_get_text (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN VARCHAR2;

  FUNCTION nvarray_get_raw (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN RAW;

  FUNCTION nvarray_get_date (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN DATE;

  FUNCTION nvarray_find_name (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN BINARY_INTEGER;

  FUNCTION nvarray_find_name_type (
    p_array    IN sys.mgw_name_value_array_t,
    p_name     IN VARCHAR2,
    p_type     IN BINARY_INTEGER,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN BINARY_INTEGER;

  FUNCTION is_same (
    p_str1     IN VARCHAR2,
    p_str2     IN VARCHAR2,
    p_compare  IN BINARY_INTEGER DEFAULT CASE_SENSITIVE )
  RETURN BOOLEAN;

  PROCEDURE check_range (
    p_value      IN INTEGER,
    p_minval     IN INTEGER,
    p_maxval     IN INTEGER,
    p_errm_value IN VARCHAR2 );

  PROCEDURE check_range (
    p_numarray   IN sys.mgw_number_array_t,
    p_minval     IN INTEGER,
    p_maxval     IN INTEGER,
    p_errm_value IN VARCHAR2 );

  FUNCTION lcr_to_xml (
    p_anydata  IN sys.anydata )
  RETURN sys.xmltype;

  FUNCTION xml_to_lcr (
    p_xmldata  IN sys.xmltype )
  RETURN sys.anydata;

END dbms_mgwmsg;
/

-- Grant privileges to PUBLIC since this may be referenced by a user when
-- writing transformation functions, etc.

grant execute on sys.dbms_mgwmsg to public;

-- Create synonyms.

create or replace public synonym dbms_mgwmsg for dbms_mgwmsg;

Rem ===== END OF FILE =======================================================
