Rem
Rem $Header: mgwpatch.sql 13-jul-2006.10:06:56 chall Exp $
Rem
Rem mgwpatch.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    mgwpatch.sql - MGW patch script
Rem
Rem  DESCRIPTION
Rem    This patch script is used to apply bug fixes. It is run in the
Rem    context of catpatch.sql, after the RDBMS catalog.sql and 
Rem    catproc.sql are run. It is run with a special EVENT set which 
Rem    causes CREATE OR REPLACE statements to only recompile objects if
Rem    the new source is different from the source stored in the database.
Rem
Rem  NOTES
Rem    This script must be run AS SYSDBA.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       07/13/06 - replace shutdown trigger 
Rem  chall       06/21/06 - fix comments 
Rem  chall       06/15/06 - use RDBMS version for MGW component version;
Rem                         load all package specs
Rem  chall       11/26/02 - call dbms_registry.check_server_instance
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       10/29/02 - Created
Rem
Rem ==========================================================================

whenever sqlerror exit
execute dbms_registry.check_server_instance
whenever sqlerror continue

-- specify the validate routine, just in case it changed
execute -
 dbms_registry.loading('MGW', 'Messaging Gateway', 'mgwi_reg.validate_mgw')

Rem Patch Work
Rem
Rem Below is slimmed down version of mgwlod.sql and should be sufficient for
Rem most MGW patches but may need to be altered depending on requirements of
Rem a given patch. Alternate is to just run mgwlod.sql which is likely okay
Rem for MGW, but note that mgwlod.sql does _not_ load private type specs 
Rem which may be needed for a given patch.
Rem
Rem Below currently excludes:
Rem public/private type specs, table modifications, AQ log/notify queues,
Rem Scheduler objects
Rem

-- package specs
@@mgwmsg
@@mgwadm
@@mgwnfy.plb
@@mgwaqd.plb
@@mgwiadm.plb

-- views
@@mgwview

-- type and package bodies
@@mgwtypeb.plb
@@mgwityb.plb
@@mgwmsgb.plb
@@mgwadmb.plb
@@mgwnfyb.plb
@@mgwaqdb.plb
@@mgwiadmb.plb

@@mgwireg.plb

-- database SHUTDOWN trigger
create or replace trigger mgw_dbshutdown_trig
 before shutdown on database
call mgwi_admin.db_shutdown_trigger
/

execute dbms_registry.loaded('MGW')
execute mgwi_reg.validate_mgw

Rem === End file: mgwpatch.sql ===============================================
