Rem
Rem $Header: mgwrelod.sql 21-jun-2006.10:50:26 chall Exp $
Rem
Rem mgwrelod.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    mgwrelod.sql - MGW component reload script (for RDBMS 10.0.0)
Rem
Rem  DESCRIPTION
Rem    This script is called from $ORACLE_HOME/rdbms/admin/catrelod.sql
Rem    during an RDBMS downgrade. It runs in context of the "old" database
Rem    and encapsulates the "post downgrade" steps necessary to reload
Rem    PL/SQL packages, type bodies, views, Java classes, and so on.
Rem
Rem    The dictionary objects (e.g., tables, type specs) will have been 
Rem    reset to the old release by an mgwe***.sql script that was run in
Rem    context of the "new" database. This script processes the "old" scripts
Rem    to reload the "old" version of the component using the "old" server.
Rem
Rem  NOTES
Rem    This script must be run AS SYSDBA.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       06/21/06 - reload type specs 
Rem  chall       06/15/06 - use RDBMS version for MGW component version 
Rem  chall       09/17/04 - bugfix 3895383; reload dblink and library objects 
Rem  chall       11/26/02 - call dbms_registry.check_server_instance
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       10/29/02 - Created
Rem
Rem ==========================================================================

whenever sqlerror exit
execute dbms_registry.check_server_instance
whenever sqlerror continue

-- set the validate routine, just in case it changed
execute -
 dbms_registry.loading('MGW', 'Messaging Gateway', 'mgwi_reg.validate_mgw')

-- reload database link and library objects
@@mgwlib

-- reload type specs
-- be careful with dependency when changing the load order; for example,
-- some tables have a dependency on type sys.mgw_properties
@@mgwtype
@@mgwityp.plb

-- load tables (noop if tables already exist)
@@mgwtable

-- reload package specs, type bodies, package bodies, views
-- table and type specs should have been reversed/restored by "e" script
@@mgwlod

execute dbms_registry.loaded('MGW')
execute mgwi_reg.validate_mgw

Rem === End file: mgwrelod.sql ===============================================
