Rem
Rem $Header: mgwtype.sql 19-may-2004.11:48:01 chall Exp $
Rem
Rem mgwtype.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem  NAME
Rem    mgwtype.sql - MGW public type specifications
Rem
Rem  DESCRIPTION
Rem    Specifications for public types used for Messaging Gateway.
Rem    The privileges to be granted depend on how each type is used.
Rem
Rem  NOTES
Rem    This script should be AS SYSDBA.
Rem
Rem    Object type ids (TOID) for MGW range 0x00021080..0x000210cf.
Rem    Currently this script uses: 00021080..0002108e
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       05/19/04 - MSMQ support 
Rem  chall       12/16/03 - remove obsolete (commented out) MSMQ code 
Rem  chall       12/15/03 - add OID clause to object types (bug 3316719) 
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       11/05/02 - Created
Rem
Rem ==========================================================================

--
-- mgw_property
--
-- Type used to specify property information in a simple name-value pair
-- fashion where the name and value are strings.
-- 
-- --- 10gR2 (10.2.0.0.0) Changes ---
-- Increased size of name from 100 to 500.
-- Increased size of value from 1000 to 4000.
--

CREATE OR REPLACE TYPE sys.mgw_property 
OID '00000000000000000000000000021080'
AS OBJECT
(
  name     VARCHAR2(500),
  value    VARCHAR2(4000),

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_property,

  STATIC FUNCTION construct( 
    p_name  IN VARCHAR2,
    p_value IN VARCHAR2 )
  RETURN sys.mgw_property
);
/

--
-- mgw_properties
--
-- Array of properties.
--
-- --- 10gR2 (10.2.0.0.0) Changes ---
-- Increased limit from 100 to 2000.
--
CREATE OR REPLACE TYPE sys.mgw_properties 
OID '00000000000000000000000000021081'
AS VARRAY(2000) OF sys.mgw_property;
/

--
-- mgw_mqseries_properties
--
-- Basic properties for link to MQSeries messaging system.
--
CREATE OR REPLACE TYPE sys.mgw_mqseries_properties
OID '00000000000000000000000000021082'
AS OBJECT
(
  queue_manager         VARCHAR2(64),
  hostname              VARCHAR2(64),
  port                  INTEGER,
  channel               VARCHAR2(64),
  interface_type        INTEGER,
  max_connections       INTEGER,
  username              VARCHAR2(64),
  password              VARCHAR2(64),
  inbound_log_queue     VARCHAR2(64),
  outbound_log_queue    VARCHAR2(64),

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_mqseries_properties, 

  STATIC FUNCTION alter_construct
  RETURN sys.mgw_mqseries_properties
);
/

--
-- mgw_tibrv_properties
--
-- Basic properties for link to TIBCO/RV messaging system.
--
CREATE OR REPLACE TYPE sys.mgw_tibrv_properties 
OID '00000000000000000000000000021083'
AS OBJECT
(
  service      VARCHAR2(128),
  daemon       VARCHAR2(128),
  network      VARCHAR2(256),
  cm_name      VARCHAR2(256),
  cm_ledger    VARCHAR2(256),

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_tibrv_properties, 

  STATIC FUNCTION alter_construct
  RETURN sys.mgw_tibrv_properties
);
/

--
-- mgw_name_value_t
--
-- Basic type for a name-value pair. This type is by many of the gateway
-- canonical types. Typically, the name, type and one <>_value attribute 
-- will be non-NULL.
--
-- The type attribute indicates which Java datatype/class is associated with
-- this value. See DBMS_MGWMSG.<>_VALUE constants for valid values. It also
-- indicates which <>_value attribute is used to store the value.
--
-- The type/value mapping should be:
--
--   type               stored via attribute
--   ----               --------------------
--   TEXT_VALUE         text_value
--   RAW_VALUE          raw_value
--   BOOLEAN_VALUE      integer_value
--   BYTE_VALUE         integer_value
--   SHORT_VALUE        integer_value
--   INTEGER_VALUE      integer_value
--   LONG_VALUE         number_value
--   FLOAT_VALUE        number_value
--   DOUBLE_VALUE       number_value
--   DATE_VALUE         date_value
--
-- Notes:
--
-- * Object types don't support a native BOOLEAN type and hence the usage of
-- an INTEGER type to represent a BOOLEAN_VALUE; 0 for FALSE and 1 for TRUE.
--
-- * By default, JPublisher uses java.lang.Integer to represent an INTEGER 
-- datatype and java.math.BigDecimal for a NUMBER datatype.
--
-- * Most integer types are stored via integer_value (INTEGER datatype) but
-- a long integer (LONG_VALUE type) should be stored using number_value 
-- (NUMBER datatype) which can better represent the larger precision.
--
create or replace type sys.mgw_name_value_t 
oid '00000000000000000000000000021084'
as object
(
  name           VARCHAR2(250),  -- associated name
  type           INTEGER,        -- value type; see DBMS_MGWMSG.<>_VALUE defs
  integer_value  INTEGER,        -- value
  number_value   NUMBER,
  text_value     VARCHAR2(4000),
  raw_value      RAW(2000),
  date_value     DATE,

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_boolean (
    name   IN VARCHAR2,
    value  IN INTEGER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_byte (
    name   IN VARCHAR2,
    value  IN INTEGER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_short (
    name   IN VARCHAR2,
    value  IN INTEGER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_integer (
    name   IN VARCHAR2,
    value  IN INTEGER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_long (
    name   IN VARCHAR2,
    value  IN NUMBER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_float (
    name   IN VARCHAR2,
    value  IN NUMBER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_double (
    name   IN VARCHAR2,
    value  IN NUMBER )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_text (
    name   IN VARCHAR2,
    value  IN VARCHAR2 )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_raw (
    name   IN VARCHAR2,
    value  IN RAW )
  RETURN sys.mgw_name_value_t,

  STATIC FUNCTION construct_date (
    name   IN VARCHAR2,
    value  IN DATE )
  RETURN sys.mgw_name_value_t
);
/

--
-- mgw_name_value_array_t
--
-- Array of name-value pairs.
--
create or replace type sys.mgw_name_value_array_t 
oid '00000000000000000000000000021085'
as varray(1024) OF sys.mgw_name_value_t;
/

--
-- mgw_text_value_t
--
-- Basic type for a text value. This type can store a large value as a CLOB
-- or a smaller value (size <= 4000) using a more accessible/efficient form.
-- Typically, only one value attribute would be set.
--
create or replace type sys.mgw_text_value_t 
oid '00000000000000000000000000021086'
as object
(
  small_value    VARCHAR2(4000),
  large_value    CLOB,

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_text_value_t
);
/

--
-- mgw_raw_value_t
--
-- Basic type for a raw value. This type can store a large value as a BLOB
-- or a smaller value (size <= 2000) using a more accessible/efficient form.
-- Typically, only one value attribute would be set.
--
create or replace type sys.mgw_raw_value_t 
oid '00000000000000000000000000021087'
as object
(
  small_value    RAW(2000),
  large_value    BLOB,

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_raw_value_t
);
/

--
-- mgw_basic_msg_t
--
-- Canonical type for a basic message. This type is used for a basic text 
-- or raw message. Typically, only a single text or raw value would be set.
--
create or replace type sys.mgw_basic_msg_t 
oid '00000000000000000000000000021088'
as object
(
  -- message header
  header       sys.mgw_name_value_array_t,

  -- message body; typically only one of the below is non-NULL
  text_body    sys.mgw_text_value_t,
  raw_body     sys.mgw_raw_value_t,

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_basic_msg_t
);
/

--
-- mgw_number_array_t
--
-- Array of NUMBER values.
--
create or replace type sys.mgw_number_array_t
oid '00000000000000000000000000021089'
as varray(1024) of NUMBER;
/

--
-- mgw_tibrv_field_t
--
-- TIB/Rendezvous field type. User friendly type returned when user gets
-- a RV field from MGW_TIBRV_MSG_T object. Typically, the field_name, 
-- field_id, field_type and one <>_value attribute will be non-NULL.
--
-- The field_type attribute specifies the RV message type is associated with
-- this value. See DBMS_MGWMSG.TIBRVMSG_<> constants for valid values. It also
-- indicates which <>_value attribute is used to store the value.
--
-- The type/value mapping should be:
--
--   RV type            stored via attribute
--   -------            --------------------
--   TIBRVMSG_BOOL      number_value
--   TIBRVMSG_F32       number_value
--   TIBRVMSG_F64       number_value
--   TIBRVMSG_I8        number_value
--   TIBRVMSG_I16       number_value
--   TIBRVMSG_I32       number_value
--   TIBRVMSG_I64       number_value
--   TIBRVMSG_IPADDR32  text_value
--   TIBRVMSG_IPPORT16  number_value
--   TIBRVMSG_DATETIME  date_value
--   TIBRVMSG_F32ARRAY  number_array_value
--   TIBRVMSG_F64ARRAY  number_array_value
--   TIBRVMSG_I8ARRAY   number_array_value
--   TIBRVMSG_I16ARRAY  number_array_value
--   TIBRVMSG_I32ARRAY  number_array_value
--   TIBRVMSG_I64ARRAY  number_array_value
--   TIBRVMSG_STRING    text_value, or clob_value
--   TIBRVMSG_OPAQUE    raw_value, or blob_value
--   TIBRVMSG_XML       raw_value, or blob_value
--
-- Notes:
--
-- * Object types don't support a native BOOLEAN type and hence the usage of
-- a NUMBER type to represent a BOOLEAN_VALUE; 0 for FALSE and 1 for TRUE.
--
-- * By default, JPublisher uses java.math.BigDecimal for a NUMBER datatype.
--
-- * For TIBRVMSG_STRING, the TEXT_VALUE attribute used to store data if 
-- value is NULL or data length <= 4000, otherwise CLOB_VALUE attribute set
-- to CLOB locator.
--
-- * For TIBRVMSG_OPAQUE and TIBRVMSG_XML, the RAW_VALUE attribute used to
-- store data if value is NULL or data length <= 2000, otherwise BLOB_VALUE 
-- attribute set to BLOB locator.
--
create or replace type sys.mgw_tibrv_field_t 
oid '0000000000000000000000000002108a'
as object
(
  field_name            VARCHAR2(256),
  field_id              INTEGER,
  field_type            INTEGER,
  number_value          NUMBER,
  number_array_value    sys.mgw_number_array_t,
  text_value            VARCHAR2(4000),
  raw_value             RAW(2000),
  date_value            DATE,
  clob_value            CLOB,
  blob_value            BLOB
);
/

--
-- mgw_tibrv_ifield_t, mgw_tibrv_ifields_t
--
-- TIB/Rendezvous internal field type. Support types used to implement 
-- MGW_TIBRV_MSG_T. Users should _never_ use this type.
--
create or replace type sys.mgw_tibrv_ifield_t 
oid '0000000000000000000000000002108b'
as object
(
  field_name            VARCHAR2(256),
  field_id              INTEGER,
  field_type            INTEGER,
  number_value          NUMBER,
  number_array_value    sys.mgw_number_array_t,
  text_value            VARCHAR2(4000),
  raw_value             RAW(2000),
  date_value            DATE,
  clob_index            INTEGER,
  blob_index            INTEGER
);
/

create or replace type sys.mgw_tibrv_ifields_t
oid '0000000000000000000000000002108c'
as varray(1024) OF sys.mgw_tibrv_ifield_t;
/

--
-- mgw_tibrv_msg_t
--
-- Canonical type for a TIB/Rendezvous message. Users should never access 
-- the type attributes directly, but instead, use the type methods.
--
create or replace type sys.mgw_tibrv_msg_t
oid '0000000000000000000000000002108d'
as object 
(
  send_subject       VARCHAR2(256),
  reply_subject      VARCHAR2(256),
  cm_time_limit      NUMBER,
  cm_sender_name     VARCHAR2(256),
  cm_sequence_num    NUMBER,
  fields             sys.mgw_tibrv_ifields_t,
  clob_data1         CLOB,
  clob_data2         CLOB,
  clob_data3         CLOB,
  blob_data1         BLOB,
  blob_data2         BLOB,
  blob_data3         BLOB,

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_tibrv_msg_t,

  MEMBER PROCEDURE add_bool (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN INTEGER ),

  MEMBER PROCEDURE add_f32 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN FLOAT ),

  MEMBER PROCEDURE add_f64 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN NUMBER ),

  MEMBER PROCEDURE add_i8 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN INTEGER ),

  MEMBER PROCEDURE add_i16 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN INTEGER ),

  MEMBER PROCEDURE add_i32 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN INTEGER ),

  MEMBER PROCEDURE add_i64 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN NUMBER ),

  MEMBER PROCEDURE add_ipaddr32 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN VARCHAR2 ),

  MEMBER PROCEDURE add_ipport16 (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN INTEGER ),

  MEMBER PROCEDURE add_datetime (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN DATE ),

  MEMBER PROCEDURE add_f32array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_f64array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_i8array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_i16array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_i32array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_i64array (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_string (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN VARCHAR2 ),

  MEMBER PROCEDURE add_string (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN CLOB ),

  MEMBER PROCEDURE add_opaque (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN RAW ),

  MEMBER PROCEDURE add_opaque (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN BLOB ),

  MEMBER PROCEDURE add_xml (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN RAW ),

  MEMBER PROCEDURE add_xml (
    name  IN VARCHAR2,
    id    IN INTEGER,
    value IN BLOB ),

  MEMBER PROCEDURE set_send_subject (
    value IN VARCHAR2 ),

  MEMBER PROCEDURE set_reply_subject (
    value IN VARCHAR2 ),

  MEMBER PROCEDURE set_cm_time_limit (
    value IN NUMBER ),

  MEMBER PROCEDURE set_cm_sender_name (
    value IN VARCHAR2 ),

  MEMBER PROCEDURE set_cm_sequence_num (
    value IN NUMBER ),

  MEMBER FUNCTION get_send_subject
  RETURN VARCHAR2,

  MEMBER FUNCTION get_reply_subject
  RETURN VARCHAR2,

  MEMBER FUNCTION get_cm_time_limit
  RETURN NUMBER,

  MEMBER FUNCTION get_cm_sender_name
  RETURN VARCHAR2,

  MEMBER FUNCTION get_cm_sequence_num
  RETURN NUMBER,

  MEMBER FUNCTION get_field_count
  RETURN INTEGER,

  MEMBER FUNCTION get_field (
    idx IN INTEGER )
  RETURN sys.mgw_tibrv_field_t,

  MEMBER FUNCTION get_field_by_name (
    name  IN VARCHAR2 )
  RETURN sys.mgw_tibrv_field_t,

  MEMBER FUNCTION get_field_by_id (
    id   IN INTEGER )
  RETURN sys.mgw_tibrv_field_t,

  MEMBER FUNCTION find_field_name (
    name       IN VARCHAR2,
    start_idx  IN INTEGER )
  RETURN INTEGER,

  MEMBER FUNCTION find_field_id (
    id         IN INTEGER,
    start_idx  IN INTEGER )
  RETURN INTEGER,

  -- implemention support routines, not intended for public use but must be
  -- declared since Oracle does not support private member functions

  MEMBER PROCEDURE add_ifield (
    p_field  IN sys.mgw_tibrv_ifield_t ),

  MEMBER PROCEDURE add_num_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN NUMBER ),

  MEMBER PROCEDURE add_numarray_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN sys.mgw_number_array_t ),

  MEMBER PROCEDURE add_text_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN VARCHAR2 ),

  MEMBER PROCEDURE add_raw_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN RAW ),

  MEMBER PROCEDURE add_date_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN DATE ),

  MEMBER PROCEDURE add_clob_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN CLOB ),

  MEMBER PROCEDURE add_blob_field (
    p_name   IN VARCHAR2,
    p_id     IN INTEGER,
    p_type   IN INTEGER,
    p_value  IN BLOB )

);
/

--
-- mgw_msmq_properties
--
-- Basic properties for link to Microsoft MSMQ messaging system.
--
CREATE OR REPLACE TYPE sys.mgw_msmq_properties 
OID '0000000000000000000000000002108e'
AS OBJECT
(
  transactional  INTEGER,
  username       VARCHAR2(64),
  password       VARCHAR2(64),

  -- === Methods ===

  STATIC FUNCTION construct
  RETURN sys.mgw_msmq_properties, 

  STATIC FUNCTION alter_construct
  RETURN sys.mgw_msmq_properties
);
/

-- Grant privileges on the adminstration types. Only MGW administrators 
-- should need to access these types.
-- Q: Should include 'with grant option' for these?

grant execute on mgw_property to mgw_administrator_role;
grant execute on mgw_properties to mgw_administrator_role;
grant execute on mgw_mqseries_properties to mgw_administrator_role;
grant execute on mgw_tibrv_properties to mgw_administrator_role;
grant execute on mgw_msmq_properties to mgw_administrator_role;

-- Grant privileges on the message canonical types.
-- These types can be referenced by transformation functions, used for 
-- AQ payloads, and so on.
--
-- Note: It appears the 'with grant option' is needed if someone defines 
-- another type, using one of our types as an attribute, and they want to
-- 'grant execute' on their type to another user. If 'grant option' not
-- allowed their 'grant execute' will fail, even though we granted execute 
-- on our types to public.

grant execute on sys.mgw_name_value_t to public with grant option;
grant execute on sys.mgw_name_value_array_t to public with grant option;
grant execute on sys.mgw_text_value_t to public with grant option;
grant execute on sys.mgw_raw_value_t to public with grant option;
grant execute on sys.mgw_basic_msg_t to public with grant option;

grant execute on sys.mgw_number_array_t to public with grant option;
grant execute on sys.mgw_tibrv_field_t to public with grant option;
grant execute on sys.mgw_tibrv_ifield_t to public with grant option;
grant execute on sys.mgw_tibrv_ifields_t to public with grant option;
grant execute on sys.mgw_tibrv_msg_t to public with grant option;

Rem ===== END OF FILE ========================================================
