Rem
Rem $Header: mgwu901.sql 01-nov-2002.16:42:47 chall Exp $
Rem
Rem mgwu901.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem  NAME
Rem    mgwu901.sql - MGW upgrade script from Release 9.0.1
Rem
Rem  DESCRIPTION
Rem    Upgrade Messaging Gateway from MGW/RDBMS Release 9.0.1 to 9.2.0.
Rem
Rem  NOTES
Rem    This script must be run as SYSDBA.
Rem
Rem    This script is intended to be run during component upgrade process;
Rem    typically from mgwdbmig.sql. It should only be called when upgrading
Rem    a 9.0.1 database in which the MGW component had been loaded.
Rem
Rem    The version of this script used for 10.0.0 (and subsequent) releases
Rem    is drastically different than that used for 9.2.0 release. For 10.0.0 
Rem    release, the MGW migration scripts were altered to be in tune with
Rem    suggested guidelines.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       11/01/02 - 10iR1 upgrade
Rem  chall       02/15/02 - reference dbms_registry release_version constant.
Rem  chall       02/07/02 - chall_bug-2218028
Rem  chall       02/07/02 - Created
Rem
Rem ==========================================================================


-- For 9.0.1 -> 9.2.0 upgrade:
-- a) One internal package was dropped. It had no synonym.
-- b) There are no other dictionary changes that should be done by a 
--    component "u" script, according to component guidelines.
--    - No tables were modified or altered. No new tables were added.
--    - No type specs were modified or altered. No new types were added.
--    - No additional privilege grants are needed.

-- drop obsolete packages
drop package sys.mgwi_mesg;

Rem ========================================================================
Rem Chain to component's next "u" script
Rem ========================================================================

@@mgwu920

Rem === End file: mgwu901.sql ================================================
