<%--
  - FILE
  -   idmgmt.jsp
  -
  - DESCRIPTION
  -   Identity Management page
  -
  - MODIFIED    (MM/DD/YY)
  -  vsagar      02/21/06 - bug fix - 5031829 
  -  vsagar      02/15/06 - XbranchMerge vsagar_bug-5031833_5025974 from main 
  -  vsagar      02/06/06 - bug fix - 5006611, 5014966 
  -  vsagar      02/14/06 - bug fix - 5031833 
  -  vsagar      12/16/05 - ui review comments 
  -  vsagar      12/13/05 - skip identity mgmt page 
  -  mpedhiwa    11/18/05 - Moved strings into resource bundle and added some 
  -                         client side javascripts 
  -  mpedhiwa    11/01/05   - 
  -  mpedhiwa    11/01/05   - Created
  -
  - SINCE
  -  10.2+
  --%>
  
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

  <%--All page contents should be within this tag--%>
  <uix:buildTree nodeID="asprovContent" scope="request">
    <uix:stackLayout>
        <uix:script text="function checkPassword()
                {
                var confirmPassword = document.all['confirm_password'].value;
                var Password        = document.all['password'].value;
		if (confirmPassword != null)
		{
			if (confirmPassword != Password)
			{
			    alert('Passwords do not match');
                            document.all['confirm_password'].value = '';
                        } 
		}

		}">      
    </uix:script>

      

      <%-- Configure Identity Management SECTION --%>
      <uix:header textBinding="IDENTITY_MGMT_HOST_ID_HEADER@asprovResourceBundle">      
        <uix:tableLayout width="100%" cellSpacing="4">
          <uix:rowLayout width="100%">                        
            <uix:cellFormat width="40%" vAlign="top">
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
                <uix:messageLovField 
                    columns="30"
                    name="host"
                    promptBinding="IDENTITY_MGMT_HOST_ID_TXT_BX_LABEL@asprovResourceBundle"
                    required = "uiOnly"
                    textBinding="host_txt_bx_val@servletRequest"
                    messageTypeBinding="hostErr@servletRequest"
                    messageBinding="hostErrMsg@servletRequest"
         		    shortDescBinding="IDENTITY_MGMT_HOST_ID_TXT_BX_LABEL@asprovResourceBundle"
		            searchDescBinding="IDENTITY_MGMT_HOST_ID_TXT_BX_LABEL@asprovResourceBundle"
                    onClickBinding="appTargetOnClick@servletRequest"/>
                <uix:messageTextInput 
                    columns="30"
                    name="port"
                    promptBinding="IDENTITY_MGMT_PORT_ID_TXT_BX_LABEL@asprovResourceBundle"
                    required="uiOnly"
                    textBinding="port_txt_bx_val@servletRequest"
                    messageTypeBinding="portErr@servletRequest"
                    messageBinding="portErrMsg@servletRequest"
					shortDescBinding="IDENTITY_MGMT_PORT_ID_TXT_BX_LABEL@asprovResourceBundle"/>
                <uix:messageCheckBox 
                  name="useSSL_chk_bx" 
                  textBinding="IDENTITY_MGMT_USE_SSL_CHK_BX_TXT@asprovResourceBundle"
                  checkedBinding="use_ssl_chk_bx_checked@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:cellFormat>
            <uix:cellFormat width="60%" vAlign="top">
              <uix:contentContainer background="light" width="100%" text="Information">
                <uix:styledText styleClass="OraInstructionText" textBinding="IDENTITY_MGMT_HOST_ID_HEADER_DESC@asprovResourceBundle"/>                                
              </uix:contentContainer>
            </uix:cellFormat>                        
          </uix:rowLayout>         
        </uix:tableLayout>
      </uix:header>

      <uix:header textBinding="IDENTITY_MGMT_LOGIN_HEADER@asprovResourceBundle">
        <uix:tableLayout width="100%" cellSpacing="4">
          <uix:rowLayout width="100%">
            <uix:cellFormat width="40%" vAlign="top">
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">      
                <uix:messageTextInput 
                    columns="30"
                    name="username"
                    promptBinding="IDENTITY_MGMT_USERNAME_TXT_BX_LABEL@asprovResourceBundle"
                    required="uiOnly"
                    textBinding="username_txt_bx_val@servletRequest"
                    messageTypeBinding="usernameErr@servletRequest"
                    messageBinding="usernameErrMsg@servletRequest"
					shortDescBinding="IDENTITY_MGMT_USERNAME_TXT_BX_LABEL@asprovResourceBundle"/>                        
                <uix:messageTextInput 
                    columns="30"
                    name="password"
                    promptBinding="IDENTITY_MGMT_PASSWORD_TXT_BX_LABEL@asprovResourceBundle"
                    secret="true" 
                    required = "uiOnly"
                    messageTypeBinding="passwordErr@servletRequest"
                    messageBinding="passwordErrMsg@servletRequest"
				    noAutoComplete="true"
					shortDescBinding="IDENTITY_MGMT_PASSWORD_TXT_BX_LABEL@asprovResourceBundle"/> 
                <uix:messageTextInput 
                    columns="30"
                    name="confirm_password"
                    promptBinding="IDENTITY_MGMT_CONFIRM_PASSWORD_TXT_BX_LABEL@asprovResourceBundle"
                    secret="true"                     
                    required = "uiOnly"
                    messageTypeBinding="confirmPasswordErr@servletRequest"
                    messageBinding="confirmPasswordErrMsg@servletRequest"
				    noAutoComplete="true"
					shortDescBinding="IDENTITY_MGMT_CONFIRM_PASSWORD_TXT_BX_LABEL@asprovResourceBundle"/>
              </uix:labeledFieldLayout>
            </uix:cellFormat>
            <uix:cellFormat width="60%" vAlign="top">
              <uix:contentContainer background="light" width="100%" text="Information">
                <uix:styledText styleClass="OraInstructionText" textBinding="IDENTITY_MGMT_LOGIN_HEADER_DESC@asprovResourceBundle"/>
              </uix:contentContainer>
            </uix:cellFormat>                        
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>
    </uix:stackLayout>
  </uix:buildTree>
  
<%@ include file="asprovTemplate.jspf"%>
