<%--
  - FILE
  -   TargetList.jsp
  -
  - DESCRIPTION
  -   Target list selection page
  -
  - MODIFIED    (MM/DD/YY)
  -  svijayar    08/12/06   - XbranchMerge svijayar_insinp from main
  -  vsagar      07/18/06   - asprov 10.2.0.3.0 backport 
  -  vsagar      07/18/06   - asprov 10.2.0.3.0 backport 
  -  svijayar    04/11/06   - Created
  -
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ include file="/oemNoscript.jspf"%><%--All page contents should be within this tag--%>

  <uix:buildTree nodeID="asprovContent" scope="request">
    <!--Source Selection option from Oracle Home-->
    <uix:header textBinding="SOURCE_SELECTION_HEADER@asprovResourceBundle" id="src">
      <uix:stackLayout>
        <uix:styledText textBinding="SOURCE_SELECTTION_DESC1@asprovResourceBundle" styleClass="OraInstructionText" renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest"/>    
      </uix:stackLayout>
      <%--Introduce some space--%>
      <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest" >
        <uix:cellFormat height="5">
          <uix:text text=" "/>
        </uix:cellFormat>
      </uix:rowLayout>      
      <uix:header  textBinding="SOURCE_SELECTTION_DESC2@asprovResourceBundle">
        <uix:tableLayout>
          <uix:rowLayout>
            <uix:messageRadioButton
              name="optSource"
              selectedBinding="srcSftLibSelected@asprovSourceSelectionBean@servletRequest"
              renderedBinding="render@optSource@UIData@asprovSourceSelectionBean@servletRequest"
              textBinding="text@optSource@UIData@asprovSourceSelectionBean@servletRequest" 
              shortDescBinding="text@optSource@UIData@asprovSourceSelectionBean@servletRequest"
              primaryClientActionBinding="oracleHomeSel@asprovSourceSelectionBean@servletRequest"/>
          </uix:rowLayout>    
          <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest" >
            <uix:cellFormat height="3">
              <uix:text text=" "/>
            </uix:cellFormat>
          </uix:rowLayout>      
          <%--Introduce some space--%>
          <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest" >
            <uix:cellFormat height="20">
              <uix:text text=" "/>
            </uix:cellFormat>
          </uix:rowLayout>
        
          <!--Cluster Selection option-->
          <uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:messageChoice 
                    nameBinding="fieldName@src_cluster@UIData@asprovSourceSelectionBean@servletRequest" 
                    renderedBinding="render@src_cluster@UIData@asprovSourceSelectionBean@servletRequest"
                    promptBinding="prompt@src_cluster@UIData@asprovSourceSelectionBean@servletRequest"
                    disabledBinding="disabled@src_cluster@UIData@asprovSourceSelectionBean@servletRequest"
                    selectedValueBinding="selval@src_cluster@UIData@asprovSourceSelectionBean@servletRequest"
                    shortDescBinding="SOURCE_SEL_CLUSTER@asprovResourceBundle"
                    messageTypeBinding="msgSrcCluster@servletRequest"
                    messageBinding="msgTypeSrcCluster@servletRequest"
                    primaryClientActionBinding="changeEventCluster@asprovSourceSelectionBean@servletRequest">
                  <uix:contents childDataBinding="clusterList@asprovSourceSelectionBean@servletRequest">
                    <uix:option textBinding="clusterListText" 
                            valueBinding="clusterListValue">
                    </uix:option>
                  </uix:contents>
                </uix:messageChoice>
              </uix:cellFormat>        
            </uix:rowLayout>
          </uix:rowLayout>

        <%--Introduce some space--%>
        <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest" >
          <uix:cellFormat height="25">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>

        <!--Table that displays target from the selected cluster-->
        <uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:table 
                 id="orHomeTableID"
                 nameBinding="fieldName@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                 renderedBinding="render@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                 summaryBinding="summary@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                 formSubmitted="true" 
                 partialRenderMode="true"
                 alternateTextBinding="alt_text@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                 columnHeaderDataBinding="clusterColumnHeaders@asprovSourceSelectionBean@servletRequest" 
                 tableDataBinding="clusterTableRows@asprovSourceSelectionBean@servletRequest">
                 <uix:tableActions>
                    <uix:submitButton
                      name="event"
                      disabledBinding="disabled@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                      primaryClientActionBinding="action@reset@UIData@asprovSourceSelectionBean@servletRequest"
                      valueBinding="action@reset@UIData@asprovSourceSelectionBean@servletRequest"
                      shortDescBinding="SOURCE_RESET_ROW@asprovResourceBundle"
                      textBinding="SOURCE_RESET_ROW@asprovResourceBundle"/>
                </uix:tableActions>
                <uix:columnHeaderStamp>
                  <uix:sortableHeader
                    textBinding="text"
                    sortableBinding="sortable">
                  </uix:sortableHeader>
                </uix:columnHeaderStamp>
                <uix:contents>
                  <%--<uix:styledText nodeID="orTabPrName" textBinding="SOURCE_PRODUCT_COL"></uix:styledText>--%>
                  <uix:messageTextInput 
                    nameBinding="fieldName@orTabPrName@UIData@asprovSourceSelectionBean@servletRequest"
                    readOnly="true"
                    textBinding="SOURCE_PRODUCT_COL"
                    text = ""
                    /> 
                  <uix:messageLovField 
                    onKeyPress="javascript:if(event.keyCode != 9) return false;"
                    nameBinding="fieldName@target_lov@UIData@asprovSourceSelectionBean@servletRequest"
                    disabledBinding="disable_target_lov"
                    shortDescBinding="SOURCE_HOST_NAME_COL@asprovResourceBundle"
                    textBinding="SOURCE_HOST_NAME_COL"
                    onClickBinding="TGT_CLUSTER_POPUP">
                  </uix:messageLovField>
                  <uix:messageTextInput 
                    nameBinding="fieldName@OracleHomeLoc@UIData@asprovSourceSelectionBean@servletRequest"
                    readOnly="true"
                    textBinding="SOURCE_LOCATION_COL"
                    shortDescBinding="SOURCE_LOCATION_COL@asprovResourceBundle"
                    text = ""
                    />
                  <uix:messageTextInput 
                    nameBinding="fieldName@filesToExclude@UIData@asprovSourceSelectionBean@servletRequest"
                    disabledBinding="disabled@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                    shortDescBinding="SOURCE_FILES_TO_EXCLUDE_COL@asprovResourceBundle"
                    columns="20"
                    textBinding="SOURCE_FILES_TO_EXCLUDE_COL">
                  </uix:messageTextInput>
                  <uix:messageTextInput 
                    nameBinding="fieldName@workingDirectory@UIData@asprovSourceSelectionBean@servletRequest"
                    disabledBinding="disabled@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                    shortDescBinding="SOURCE_WORKING_DIRECTORY_COL@asprovResourceBundle"
                    columns="20"
                    textBinding="SOURCE_WORKING_DIRECTORY_COL">
                  </uix:messageTextInput>
                  <uix:formValue nameBinding="fieldName@orTabPrName@UIData@asprovSourceSelectionBean@servletRequest"
                    valueBinding="SOURCE_PRODUCT_COL"/>                    
                   <uix:formValue nameBinding="fieldName@OracleHomeLoc@UIData@asprovSourceSelectionBean@servletRequest"
                    valueBinding="SOURCE_LOCATION_COL"/>
                 </uix:contents> 
              </uix:table>
            </uix:cellFormat>
          </uix:rowLayout>            
        </uix:rowLayout>

        <%--Tips for working directory and files to exclude --%>       
        <uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:tip 
                renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest"
                textBinding="SOURCE_FILES_EXCLUDE_TIP@asprovResourceBundle">
              </uix:tip>
            </uix:cellFormat>
          </uix:rowLayout>            
        </uix:rowLayout>
        
        <uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>       
              <uix:tip 
                renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest"
                textBinding="SOURCE_WORKING_DIRECTORY_TIP@asprovResourceBundle">
              </uix:tip>
            </uix:cellFormat>
          </uix:rowLayout>            
        </uix:rowLayout>

        <%--Introduce some space--%>
        <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest" >
          <uix:cellFormat height="30">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>

        <!--Save to software library option check box-->
        <uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>               
              <uix:messageCheckBox 
                id="chkSaveToSftLib"
                nameBinding="fieldName@src_chk_save_sftlib@UIData@asprovSourceSelectionBean@servletRequest"
                renderedBinding="render@src_chk_save_sftlib@UIData@asprovSourceSelectionBean@servletRequest"
                selectedValueBinding="selval@src_chk_save_sftlib@UIData@asprovSourceSelectionBean@servletRequest"
                primaryClientActionBinding="changeSftLibEventCluster@asprovSourceSelectionBean@servletRequest"
                disabledBinding="disabled@src_chk_save_sftlib@UIData@asprovSourceSelectionBean@servletRequest"
                shortDescBinding="SOURCE_SAVE_TO_SOFTWARE_LIBRARY@asprovResourceBundle"
                textBinding="SOURCE_SAVE_TO_SOFTWARE_LIBRARY@asprovResourceBundle">
                </uix:messageCheckBox>
            </uix:cellFormat>
          </uix:rowLayout>            
        </uix:rowLayout>  
        
        <uix:rowLayout>
          <uix:tableLayout id="saveToSftLibTable">
            <uix:rowLayout>
                <uix:header 
                  renderedBinding="render@SFT_LIB_TABLE_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                  textBinding="SOURCE_SAVE_TO_SOFTWARE_LIBRARY_HEADER@asprovResourceBundle">
              <uix:cellFormat >
                    <%--Introduce some space--%>
                    <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest">
                      <uix:cellFormat height="10">
                        <uix:text text=" "/>
                      </uix:cellFormat>
                    </uix:rowLayout>          
          
                    <!--Table that displays information about save to software library-->
                    <uix:table 
                        nameBinding="fieldName@SFT_LIB_TABLE_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                        summary="summary@orHomeTable@UIData@asprovSourceSelectionBean@servletRequest"
                        formSubmitted="false" 
                        partialRenderMode="true"
                        alternateTextBinding="alt_text@SFT_LIB_TABLE_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                        columnHeaderDataBinding="sftLibColumnHeaders@asprovSourceSelectionBean@servletRequest"
                        tableDataBinding="sftLibTableRows@asprovSourceSelectionBean@servletRequest">
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader
                              textBinding="text"
                              sortableBinding="sortable">
                          </uix:sortableHeader>
                        </uix:columnHeaderStamp>
                        <uix:contents>
                          <uix:messageTextInput 
                            nameBinding="fieldName@sftTabPrName@UIData@asprovSourceSelectionBean@servletRequest"
                            readOnly="true"
                            textBinding="SOURCE_PRODUCT_COL"
                            shortDescBinding="SOURCE_PRODUCT_COL"
                            text = ""
                            columns="20"/>    
                          <uix:messageTextInput 
                            nameBinding="fieldName@SOURCE_SOFTWARE_LIBRARY_ZIP_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                            onFocusBinding="onblur"
                            shortDescBinding="SOURCE_SOFTWARE_LIBRARY_ZIP_NAME@asprovResourceBundle"
                            disabledBinding="SFT_LIB_ROW_DISABLED"
                            textBinding="SOURCE_SOFTWARE_LIBRARY_ZIP_NAME"/>
                          <uix:messageTextInput
                            nameBinding="fieldName@SOURCE_SOFTWARE_LIBRARY_ZIP_DESC@UIData@asprovSourceSelectionBean@servletRequest"
                            onFocusBinding="onblur"
                            disabledBinding="SFT_LIB_ROW_DISABLED"
                            shortDescBinding="SOURCE_SOFTWARE_LIBRARY_ZIP_DESC@asprovResourceBundle"
                            textBinding="SOURCE_SOFTWARE_LIBRARY_ZIP_DESC"/>
                          <uix:messageTextInput
                            columns="70"
                            nameBinding="fieldName@SOURCE_LOCATION_COL@UIData@asprovSourceSelectionBean@servletRequest"
                            onFocusBinding="onblur"
                            shortDescBinding="SOURCE_LOCATION_COL@asprovResourceBundle"
                            disabledBinding="SFT_LIB_ROW_DISABLED"
                            textBinding="SOURCE_LOCATION_COL"/>
                          <uix:formValue nameBinding="fieldName@sftTabPrName@UIData@asprovSourceSelectionBean@servletRequest"
                            valueBinding="SOURCE_PRODUCT_COL"/>
                        </uix:contents>
                    </uix:table>
                    </uix:cellFormat>
                    <uix:tip 
                      renderedBinding="render@SFT_LIB_TABLE_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                      textBinding="sftLibTableTip@asprovSourceSelectionBean@servletRequest">
                    </uix:tip>
                  </uix:header>
             </uix:rowLayout>
          </uix:tableLayout>
        </uix:rowLayout> 

        <%--Introduce some space--%>
        <uix:rowLayout renderedBinding="isDP10203Version@asprovSourceSelectionBean@servletRequest">
          <uix:cellFormat height="20">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        
      </uix:tableLayout>        
    </uix:header>        
      <!--Option to select shiphome from software library-->
      <%--<uix:spacer height="15"/>--%>
    <uix:header textBinding="SOURCE_SELECTTION_DESC3@asprovResourceBundle">        
     <uix:tableLayout> 
      <uix:rowLayout>  
        <uix:messageRadioButton 
          name="optSource" 
          renderedBinding="render@optSource@UIData@asprovSourceSelectionBean@servletRequest"
          shortDescBinding="text@optSourceSftLib@UIData@asprovSourceSelectionBean@servletRequest"
          selectedBinding="selval@optSourceSftLib@UIData@asprovSourceSelectionBean@servletRequest"
          textBinding="text@optSourceSftLib@UIData@asprovSourceSelectionBean@servletRequest"
          primaryClientActionBinding="sftLibSel@asprovSourceSelectionBean@servletRequest"/>
      </uix:rowLayout>  
      
        <!--Source for Web tier-->
        <uix:rowLayout>  
        <uix:header textBinding="SOURCE_FOR_WEB_TIER@asprovResourceBundle">
            <uix:cellFormat width="100%" vAlign="top" hAlign="left">
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
                <uix:spacer height="10"/>
                <uix:messageLovField 
                  nameBinding="fieldName@src_lov_webtier@UIData@asprovSourceSelectionBean@servletRequest" 
                  rendered="true"
                  columns="100"
                  noAutoComplete="true"
                  onMouseDown="javascript:return false;"
                  shortDescBinding="prompt@SOURCE_SHIPHOME_WEBTIER_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                  onKeyDown="javascript:if(event.keyCode == 9) return true; else return false;"
                  disabledBinding="disabled@SOFTLIB_SEL@UIData@asprovSourceSelectionBean@servletRequest"
                  textBinding="webtierShiphomeName@asprovSourceSelectionBean@servletRequest"
                  promptBinding="prompt@SOURCE_SHIPHOME_WEBTIER_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                  onClickBinding="selWebComponentURL@asprovSourceSelectionBean@servletRequest">
                </uix:messageLovField>
                <uix:messageTextInput
                  nameBinding="fieldName@SOURCE_SHIPHOME_WEBTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest"
                  renderedBinding="true"
                  noAutoComplete="true"
                  onMouseDown="javascript:return false;"
                  onKeyDown="javascript:if(event.keyCode == 9) return true; else return false;"
                  columns="100"
                  disabledBinding="disabled@SOFTLIB_SEL@UIData@asprovSourceSelectionBean@servletRequest"
                  shortDescBinding="prompt@SOURCE_SHIPHOME_WEBTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest"
                  textBinding="webtierShiphomeLocation@asprovSourceSelectionBean@servletRequest"
                  promptBinding="prompt@SOURCE_SHIPHOME_WEBTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest">
                </uix:messageTextInput>
              </uix:labeledFieldLayout>
            </uix:cellFormat>  
          </uix:header>        
        </uix:rowLayout>  
        
        <!--Source for Application tier-->
        <uix:rowLayout>  
        <uix:header textBinding="SOURCE_FOR_APP_TIER@asprovResourceBundle">
            <uix:cellFormat width="100%" vAlign="top" hAlign="left">
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
                <%--<uix:spacer height="15"/>--%>
                <uix:messageLovField 
                  nameBinding="fieldName@src_lov_apptier@UIData@asprovSourceSelectionBean@servletRequest" 
                  renderedBinding="true"
                  columns="100"
                  noAutoComplete="true"
                  onMouseDown="javascript:return false;"
                  onKeyDown="javascript:if(event.keyCode == 9) return true; else return false;"
                  disabledBinding="disabled@SOFTLIB_SEL@UIData@asprovSourceSelectionBean@servletRequest"
                  shortDescBinding="prompt@SOURCE_SHIPHOME_APPTIER_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                  textBinding="apptierShiphomeName@asprovSourceSelectionBean@servletRequest"
                  promptBinding="prompt@SOURCE_SHIPHOME_APPTIER_NAME@UIData@asprovSourceSelectionBean@servletRequest"
                  onClickBinding="selAppComponentURL@asprovSourceSelectionBean@servletRequest">
                </uix:messageLovField>
                <uix:messageTextInput 
                  nameBinding="fieldName@SOURCE_SHIPHOME_APPTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest"
                  renderedBinding="true"
                  noAutoComplete="true"
                  onMouseDown="javascript:return false;"
                  onKeyDown="javascript:if(event.keyCode == 9) return true; else return false;"
                  columns="100"
                  disabledBinding="disabled@SOFTLIB_SEL@UIData@asprovSourceSelectionBean@servletRequest"
                  textBinding="apptierShiphomeLocation@asprovSourceSelectionBean@servletRequest"
                  shortDescBinding="prompt@SOURCE_SHIPHOME_APPTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest"
                  promptBinding="prompt@SOURCE_SHIPHOME_APPTIER_LOC@UIData@asprovSourceSelectionBean@servletRequest">
                </uix:messageTextInput>
              </uix:labeledFieldLayout>
            </uix:cellFormat>  
         </uix:header>
        </uix:rowLayout>
      </uix:tableLayout>        
    </uix:header>
   </uix:header>
  </uix:buildTree>
  <%@ include file="asprovTemplate.jspf"%>
  
