<%--
  - FILE
  -   credentials.jsp
  -
  - DESCRIPTION
  -   Credentials page
  -
  - MODIFIED    (MM/DD/YY)
  -  rsaraswa    07/07/07 - Adding instance message
  -  rsaraswa    04/02/07 - 
  -
  - SINCE
  -  10.2+
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%--All page contents should be within this tag--%>
  <uix:buildTree nodeID="bpelprovContent" scope="request">
    <uix:script text="function enableEndAfter()
      {
        if (document.forms[0].gracePeriod[1].checked == false)
        {
          document.all['gracePeriodHourInput'].value = ''; 
          document.all['gracePeriodMinuteInput'].value = '';           
          
          document.all['gracePeriodHourInput'].disabled=true; 
          document.all['gracePeriodMinuteInput'].disabled=true; 			                    
        } 
        else
        {      
          document.all['gracePeriodHourInput'].disabled=false; 
          document.all['gracePeriodMinuteInput'].disabled=false;           
        }
      }"/>      
    
    
    
    
    <uix:header textBinding="SCHEDULE_HEADER@asprovResourceBundle">
      <uix:styledText textBinding="SCHEDULE_PG_MSG@bpelprovRB" styleClass="OraInstructionText"/>    
      <uix:spacer height="10"/>
      <uix:tableLayout cellSpacing="4">
        <uix:rowLayout>
          <uix:cellFormat>
            <uix:messageRadioButton name="startOption" textBinding="IMMEDIATELY@scheduleResourceBundle" selectedBinding="isStartNowSelected@asprovScheduleSegmentBean@servletRequest" renderedBinding="isStartNowRendered@asprovScheduleSegmentBean@servletRequest" primaryClientActionBinding="startNowFireAction@asprovScheduleSegmentBean@servletRequest" shortDescBinding="IMMEDIATELY@scheduleResourceBundle"/>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:messageRadioButton name="startOption" textBinding="LATER@scheduleResourceBundle" selectedBinding="isStartLaterSelected@asprovScheduleSegmentBean@servletRequest" renderedBinding="isStartLaterRendered@asprovScheduleSegmentBean@servletRequest" primaryClientActionBinding="startLaterFireAction@asprovScheduleSegmentBean@servletRequest" shortDescBinding="LATER@scheduleResourceBundle"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:tableLayout cellSpacing="4">
        <uix:rowLayout>
          <uix:cellFormat width="10%"/>
          <uix:cellFormat>
            <%-- timezone --%>
            <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%">
              <uix:messageChoice 
                  nameBinding="SCHEDULE_TIMEZONE_CHOICE@asprovResourceBundle" 
                  promptBinding="TIME_ZONE@scheduleResourceBundle" 
                  shortDescBinding="TIME_ZONE@scheduleResourceBundle" 
                  renderedBinding="isStartLaterSelected@asprovScheduleSegmentBean@servletRequest" 
                  selectedValueBinding="selectedTimeZoneSB@asprovScheduleSegmentBean@servletRequest">
                <uix:contents childDataBinding="timezones@servletRequest">
                  <uix:option textBinding="text" valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>
              <%-- start date --%>
              <uix:messageDateField 
                  id="startDate" 
                  nameBinding="SCHEDULE_START_DATE_FIELD@asprovResourceBundle" 
                  valueBinding="startDate@servletRequest" 
                  promptBinding="START_DATE@scheduleResourceBundle" 
                  shortDescBinding="START_DATE@scheduleResourceBundle" 
                  messageTypeBinding="startDateMsgType@errors@servletRequest" 
                  messageBinding="startDateInlineMsg@errors@servletRequest" 
                  anchorBinding="startDateAnchor@errors@servletRequest" 
                  columns="12" 
                  disabledBinding="readOnlyMode@servletRequest"
                  renderedBinding="isStartLaterSelected@asprovScheduleSegmentBean@servletRequest">
                <uix:onSubmitValidater>
                  <uix:date dateStyle="medium"/>
                </uix:onSubmitValidater>
              </uix:messageDateField>
              <uix:messagePrompt 
                  promptBinding="START_TIME@scheduleResourceBundle"
                  renderedBinding="isStartLaterSelected@asprovScheduleSegmentBean@servletRequest"/>
              <uix:tableLayout renderedBinding="isStartLaterSelected@asprovScheduleSegmentBean@servletRequest">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messageTextInput nameBinding="SCHEDULE_START_HOUR_INPUT@asprovResourceBundle" columns="2" textBinding="startHour@servletRequest" shortDescBinding="HOURS@scheduleResourceBundle" disabledBinding="readOnlyMode@servletRequest" maximumLength="2" messageTypeBinding="startHourMsgType@errors@servletRequest" messageBinding="startHourInlineMsg@errors@servletRequest" anchorBinding="startHourAnchor@errors@servletRequest" vAlign="top">
                      <uix:onSubmitValidater>
                        <uix:regExp pattern="[0-9]+"/>
                      </uix:onSubmitValidater>
                      <uix:end>
                        <uix:styledText styleClass="OraInstructionText" textBinding="TIME_SEPERATOR@scheduleResourceBundle"/>
                      </uix:end>
                    </uix:messageTextInput>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageTextInput nameBinding="SCHEDULE_START_MINUTE_INPUT@asprovResourceBundle" columns="2" maximumLength="2" textBinding="startMinute@servletRequest" shortDescBinding="MINUTES@scheduleResourceBundle" disabledBinding="readOnlyMode@servletRequest" messageTypeBinding="startMinuteMsgType@errors@servletRequest" messageBinding="startMinuteInlineMsg@errors@servletRequest" anchorBinding="startMinuteAnchor@errors@servletRequest" vAlign="top">
                      <uix:onSubmitValidater>
                        <uix:regExp pattern="[0-9]+"/>
                      </uix:onSubmitValidater>
                    </uix:messageTextInput>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageRadioButton nameBinding="START_TIME_AMPM_RB@asprovResourceBundle" textBinding="AM_LABEL@scheduleResourceBundle" selectedValueBinding="startAmPm@servletRequest" valueBinding="START_TIME_AM_VALUE@asprovResourceBundle" renderedBinding="isStartAMRendered@asprovScheduleSegmentBean@servletRequest" shortDescBinding="AM_LABEL@scheduleResourceBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageRadioButton 
                        nameBinding="START_TIME_AMPM_RB@asprovResourceBundle" 
                        textBinding="PM_LABEL@scheduleResourceBundle" 
                        selectedValueBinding="startAmPm@servletRequest" 
                        valueBinding="START_TIME_PM_VALUE@asprovResourceBundle" 
                        renderedBinding="isStartAMRendered@asprovScheduleSegmentBean@servletRequest" 
                        shortDescBinding="PM_LABEL@scheduleResourceBundle"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:messagePrompt promptBinding="GRACE_PERIOD@scheduleResourceBundle"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messageRadioButton 
                        nameBinding="GRACE_PERIOD_RB@asprovResourceBundle" 
                        textBinding="INDEFINITE@scheduleResourceBundle" 
                        selectedValueBinding="gracePeriod@servletRequest" 
                        valueBinding="GRACE_PERIOD_INDEFINITE_VALUE@asprovResourceBundle"
                        onClick="javascript:enableEndAfter();"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:messagePrompt prompt=""/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:messageRadioButton 
                            nameBinding="GRACE_PERIOD_RB@asprovResourceBundle" 
                            textBinding="END_AFTER@scheduleResourceBundle" 
                            selectedValueBinding="gracePeriod@servletRequest" 
                            valueBinding="GRACE_PERIOD_END_AFTER_VALUE@asprovResourceBundle"
                            onClick="javascript:enableEndAfter();"/>
                      </uix:cellFormat>
                      <uix:cellFormat width="1"/>
                      <uix:cellFormat>
                        <uix:messageTextInput 
                            nameBinding="GRACE_PERIOD_HOUR_INPUT@asprovResourceBundle" 
                            columns="2" 
                            textBinding="gracePeriodHourInput@servletRequest" 
                            shortDescBinding="HOURS@scheduleResourceBundle" 
                            maximumLength="2">
                          <uix:onSubmitValidater>
                            <uix:regExp pattern="[0-9]+"/>
                          </uix:onSubmitValidater>
                          <uix:end>
                            <uix:styledText styleClass="OraInstructionText" textBinding="HOURS@scheduleResourceBundle"/>
                          </uix:end>
                        </uix:messageTextInput>
                      </uix:cellFormat>
                      <uix:cellFormat width="1"/>
                      <uix:cellFormat>
                        <uix:messageTextInput 
                            nameBinding="GRACE_PERIOD_MINUTE_INPUT@asprovResourceBundle" 
                            columns="2" 
                            maximumLength="2" 
                            textBinding="gracePeriodMinuteInput@servletRequest" 
                            shortDescBinding="MINUTES@scheduleResourceBundle">
                          <uix:onSubmitValidater>
                            <uix:regExp pattern="[0-9]+"/>
                          </uix:onSubmitValidater>
                          <uix:end>
                            <uix:styledText styleClass="OraInstructionText" textBinding="MINUTES@scheduleResourceBundle"/>
                          </uix:end>
                        </uix:messageTextInput>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:labeledFieldLayout>
          </uix:cellFormat>
        </uix:rowLayout>
	<uix:rowLayout>
		 <%--DP Instance Name--%>
       
	</uix:rowLayout>
      </uix:tableLayout>
      </uix:header>
      <uix:header textBinding="INSTANCE_NAME_ID@bpelprovRB" id="src">
      <uix:stackLayout>
        <uix:styledText textBinding="NSTANCE_NAME_MSG@bpelprovRB" styleClass="OraInstructionText"/>            
        <uix:spacer height="5"/>
        <uix:contents>
      <uix:tableLayout>
       <uix:messageTextInput 
        name="dpInstanceName"
          textBinding="dpInstanceName@servletRequest"
          promptBinding="INSTANCE_NAME@patchAdvisorRB"
          shortDescBinding="INSTANCE_NAME@patchAdvisorRB"
          tipBinding="INSTANCE_NAME_TIP_TXT@patchAdvisorRB"/>
	     
        </uix:tableLayout>      
        </uix:contents>
        </uix:stackLayout>
    </uix:header>
  </uix:buildTree>
<%@ include file="bpelprovTemplate.jspf"%>
