<%--
  - FILE
  -   ProvCCFUpload.jsp
  -
  - DESCRIPTION
  -   Common CCF Upload pop up page for provisioning projects
  -
  - MODIFIED   (MM/DD/YY)
  - rvaidhiy   07/19/07  - 
  - ipall      05/11/07  - Fix for node Name
  - suravind   08/17/06  - XbranchMerge suravind_ec_directives from main
  - suravind   08/08/06  - XbranchMerge suravind_ec_changes_review_page from
  -                        main
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - suravind   05/03/06  - created
--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%--Common UI messages --%>
  <uix:bundle 
       name="sdkUIMsg" 
       class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle 
       name="commonResourceBundle" 
       class="oracle.sysman.resources.CommonResourceBundle"/>
  <%--ResourceBundle for labels/headers specific to Provisioning projects--%>
  <uix:bundle 
       name="provCommonRB" 
       class="oracle.sysman.pp.common.ui.rb.ProvCommonRB"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form 
           name="ccfUploadForm" 
           usesUpload="true" 
           method="post">
        <uix:pageLayout titleBinding="CCF_HEADER_TEXT@provCommonRB">
          <%--To display the cancel and select buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <%--Cancel button--%>
              <uix:submitButton 
                   textBinding="CANCEL@sdkUIMsg" 
                   shortDescBinding="CANCEL@sdkUIMsg" 
                   name="event" 
                   value="ccfCancel"/>
              <%--Select Button--%>
              <uix:submitButton 
                   textBinding="OK@commonResourceBundle" 
                   name="event" 
                   value="uploadCCF"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <%-- The message box to show error/info messge etc--%>
          <uix:messageBox 
               messageTypeBinding="msgType@msgInfo@servletRequest" 
               messageBinding="msg@msgInfo@servletRequest" 
               rendered="false" 
               renderedBinding="rendered@msgInfo@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="20" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout width="90%">
            <uix:styledText 
                 textBinding="CCF_SELECTION_TEXT@provCommonRB" 
                 renderedBinding="ccfSelectionTextRendered@CCF_UPLOAD_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer width="20" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout width="90%">
            <uix:styledText 
                 textBinding="CCF_VIP_PRIV_TEXT@provCommonRB" 
                 renderedBinding="ccfVipPrivTextRendered@CCF_UPLOAD_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer width="20" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout width="90%">
            <uix:styledText 
                 textBinding="CCF_IGNORE_TEXT@provCommonRB" 
                 renderedBinding="ccfIgnoreTextRendered@CCF_UPLOAD_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer width="20" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout width="90%">
            <uix:styledText 
                 textBinding="ccfCustomText@CCF_UPLOAD_BEAN@servletRequest" 
                 renderedBinding="ccfCustomTextRendered@CCF_UPLOAD_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer width="100%" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:messageFileUpload 
                 promptBinding="CCF_FILEUPLOAD_LBL@provCommonRB" 
                 tipBinding="CCF_FILEUPLOAD_TIP@provCommonRB" 
                 columns="50"
                 name="ccfFileUpload"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer width="20" height="10"/>
          </uix:rowLayout>
          <uix:rowLayout width="70%">
            <uix:styledText 
                 textBinding="CCF_LBL_TEXT@provCommonRB" 
                 styleClass="OraPromptText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="40" width="100%"/>
          </uix:rowLayout>
          <uix:rowLayout width="100%">
            <uix:contentContainer
                 width="100%"
                 renderedBinding="ccfSampleContainerRendered@CCF_UPLOAD_BEAN@servletRequest"
                 textBinding="CCF_SAMPLE_TEXT@provCommonRB">
              <uix:tableLayout width="100%" cellSpacing="4">
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="5">
                    <uix:styledText textBinding="CCF_SAMPLE_TEXT_CCF@provCommonRB"
                         styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="5">
                    <uix:styledText textBinding="CCF_SAMPLE_TEXT_NODE@provCommonRB"
                         styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText 
                       textBinding="CCF_SAMPLE_TEXT_PUBLIC@provCommonRB" 
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="CCF_SAMPLE_TEXT_PRIV_NODE@provCommonRB" 
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="CCF_SAMPLE_TEXT_PRIV_IP@provCommonRB" 
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="CCF_SAMPLE_TEXT_VIP_NODE@provCommonRB"
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="CCF_SAMPLE_TEXT_VIP_IP@provCommonRB" 
                       styleClass="OraDataText"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText text=" node1.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" node1-priv.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" -" styleClass="OraDataText"/>
                  <uix:styledText text=" node1-vip.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" -" styleClass="OraDataText"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText text=" node2.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" node2-priv.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" 10.2.109.103" styleClass="OraDataText"/>
                  <uix:styledText text=" node2-vip.domain.com" styleClass="OraDataText"/>
                  <uix:styledText text=" 134.2.109.103" styleClass="OraDataText"/>
                </uix:rowLayout>
              </uix:tableLayout>

            </uix:contentContainer>
          </uix:rowLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
