<%--
  - FILE
  -   ProvLibStepSegment.jsp
  -
  - DESCRIPTION
  -   PageSegment to display the Library Step Section for Provisioning projects.
  -
  - MODIFIED   (MM/DD/YY)
  - suravind   09/05/06  - 
  - suravind   09/05/06  - 
  - suravind   09/05/06  - 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - suravind   06/13/06  - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>
    <%--Common UI messages --%>
    <uix:bundle
         name="sdkUIMsg"
         class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
         name="commonResourceBundle"
         class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers common to Provisioning Projects --%>
    <uix:bundle
      name="provCommonRB"
      class="oracle.sysman.pp.common.ui.rb.ProvCommonRB"/>
    <uix:spacer width="100%" height="10"/>
    <uix:header
         renderedBinding="libStepsApplicable@pageSegmentBean@"
         textBinding="LIB_STEP_SEG_HEADER_TEXT@provCommonRB">
      <uix:spacer height="10" width="100%"/>
      <uix:styledText
           textBinding="LIB_STEP_SEG_TXT@provCommonRB"
           styleClass="oraInstructionText"/>
      <uix:spacer height="10" width="100%"/>
      <uix:hGrid
           id="libPropHGrid"
           partialRenderMode="self"
           alternateTextBinding="LIB_STEP_SEG_MSG_NO_LIB_STEP_PARAMS_FOUND@provCommonRB"
           summaryBinding="LIB_STEP_SEG_ALL_LIB_STEPS@provCommonRB"
           treeDataBinding="rows@pageSegmentBean@"
           proxyBinding="hGridProxy@servletRequest"
           formSubmitted="true">
        <uix:nodeStamp>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText 
                   textBinding="LIB_STEP_SEG_COLUMN_LIB_STEP@provCommonRB"/>
            </uix:columnHeader>
	            <uix:rowLayout vAlign="middle">
	            <uix:cellFormat  vAlign="top">
		            <uix:styledText 
		                 textBinding="text"/>
		                 </uix:cellFormat>
	            </uix:rowLayout>
	                 
            </uix:column>
        </uix:nodeStamp>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText 
                 textBinding="LIB_STEP_SEG_COLUMN_PARAM_VALUE@provCommonRB"/>
          </uix:columnHeader>
          <uix:switcher
               childNameBinding="expandable">
            <uix:case name="no">
              <%-- 
               - prop value input box is placed inside the tableLayout, so
               - that the input boxes are properly aligned, when error message
               - is displayed
               --%>
                		<%--uix:tableLayout width="100%">
                			<uix:rowLayout hAlign="left" vAlign="top">
                  				<uix:messageTextInput
			                       name="propNodeField"
			                       columns="50"
			                       shortDescBinding="LIB_STEP_SEG_COLUMN_PARAM_VALUE@provCommonRB"
			                       readOnlyBinding="readOnly@pageSegmentBean@servletRequest"
			                       textBinding="PROP_VALUE"
			                       tipBinding="PROP_VALUE_TIP"
			                       messageTypeBinding="PROP_MSG_TYPE"
			                       messageBinding="PROP_MSG_VALUE">
			                  	</uix:messageTextInput>
			                 </uix:rowLayout>
			              </uix:tableLayout--%>
			              <uix:switcher childNameBinding="isReview@servletRequest">
               		<uix:case name="true">
              			<uix:tableLayout width="100%">
                			<uix:rowLayout hAlign="left" vAlign="top">
                  				<uix:styledText
			                       textBinding="PROP_VALUE">
			                  	</uix:styledText>
			                 </uix:rowLayout>
			              </uix:tableLayout>
              		</uix:case>
                  <uix:default>
              			<uix:tableLayout width="100%">
                			<uix:rowLayout hAlign="left" vAlign="top">
                  				<uix:messageTextInput
			                       name="propNodeField"
			                       columns="50"
			                       shortDescBinding="LIB_STEP_SEG_COLUMN_PARAM_VALUE@provCommonRB"
			                       textBinding="PROP_VALUE"
			                       tipBinding="PROP_VALUE_TIP"
			                       messageTypeBinding="PROP_MSG_TYPE"
			                       messageBinding="PROP_MSG_VALUE">
			                  	</uix:messageTextInput>
			                 </uix:rowLayout>
			              </uix:tableLayout>
            	  </uix:default>
              </uix:switcher>
			              
            	 		</uix:case>
            	 		
            	 		
            	 		
            <uix:default>
              <uix:text text=""/>
            </uix:default>
            
          </uix:switcher>
        </uix:column>
      </uix:hGrid>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
