<%--
  - FILE
  -   ProvRegClustersSegment.jsp
  -
  - DESCRIPTION
  -
  - MODIFIED    (MM/DD/YY)
  -  rvaidhiy    06/20/07 - fixing for generic message for non availability for
  -                         DN and EC
  -  suravind    08/17/06 - XbranchMerge suravind_ec_directives from main
  -  suravind    04/11/06 - Creation
  -
  - SINCE
  -  10.2+
  --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
         name="sdkUIMsg"
         class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
         name="commonResourceBundle"
         class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers common to Provisioning Projects --%>
    <uix:bundle
      name="provCommonRB"
      class="oracle.sysman.pp.common.ui.rb.ProvCommonRB"/>
    <uix:rowLayout>
      <uix:cellFormat>
      <uix:messageChoice
           id="searchChoice"
           name="searchChoice"
           labeledNodeId="searchValue"
           promptBinding="CLUSTER_IDENTIFICATION_SEARCH_TEXT@provCommonRB"
           selectedValueBinding="searchListSelVal@pageSegmentBean@">
        <uix:contents 
             childDataBinding="searchList@pageSegmentBean@">
          <uix:option
               textBinding="SEARCH_TYPE_TEXT" 
               valueBinding="SEARCH_TYPE_VAL"/>
        </uix:contents>
      </uix:messageChoice>
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:spacer width="10" height="10"/>
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:messageTextInput
           id="searchValue"
           name="searchValue"
           shortDescBinding="CLUSTER_IDENTIFICATION_SEARCH_TEXT@provCommonRB"
           columns="20"/>
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:spacer width="10" height="10"/>
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:button 
           textBinding="CLUSTER_IDENTIFICATION_SEARCH_GO@provCommonRB"
           shortDescBinding="CLUSTER_IDENTIFICATION_SEARCH_GO@provCommonRB"
           primaryClientActionBinding="onClickSearch@servletRequest"/>
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:spacer height="10"/>
    <uix:tip
        textBinding="WILD_CARD_TIP_TEXT@provCommonRB">
    </uix:tip>
    <uix:spacer width="100%" height="10"/>
    <uix:hGrid
         id="regClustersHGrid"
         summary="regClustersHGrid"
         partialRenderMode="self"
         alternateTextBinding="regClustersAltText@servletRequest"
         proxyBinding="regClustersHGridProxy@servletRequest"
         formSubmitted="true"
         childBlockSize="5"
         width="100%"
         treeDataBinding="rows@pageSegmentBean@">
      <uix:tableSelection>
        <uix:singleSelection 
             selectedBinding="IS_SELECTED"
             renderedBinding="IS_RENDERED"
             shortDescBinding="SELECT@commonResourceBundle"
             disabledBinding="IS_DISABLED"
             primaryClientActionBinding="ON_CLICK_RADIO"/>
      </uix:tableSelection>
      <uix:nodeStamp>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_NAME@provCommonRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="text"/>
        </uix:column>
      </uix:nodeStamp>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_NODES@provCommonRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="HOSTS_ATTR"/>
        </uix:column>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_HOME@provCommonRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="HOME_ATTR"/>
        </uix:column>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_PTFORM@provCommonRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="PTFORM_ATTR"/>
        </uix:column>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_PDT@provCommonRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="PDT_ATTR"/>
        </uix:column>
    </uix:hGrid>
    <uix:rowLayout id="regClustersAdvanced">
      <uix:hideShowHeader 
           id="regClustersHideShow"
           partialRenderMode="self"
           formSubmitted="true"  
           renderedBinding="advancedHeaderRendered@pageSegmentBean@"
           textBinding="advancedHeaderText@pageSegmentBean@"
           disclosedBinding="advancedHeaderDisclosed@pageSegmentBean@">
        <uix:spacer width="100%" height="10"/>
        <uix:labeledFieldLayout
              width="50%">
          <uix:messageChoice
               id="refTgtsChoice"
               name="refTgtsChoice"
               promptBinding="CLUSTER_IDENTIFICATION_ADVANCED_REF_TGT@provCommonRB"
               shortDescBinding="CLUSTER_IDENTIFICATION_ADVANCED_REF_TGT@provCommonRB"
               tipBinding="CLUSTER_IDENTIFICATION_ADVANCED_REF_TGT_TIP@provCommonRB"
               primaryClientActionBinding="onChangeRefTgtChoice@servletRequest"
               selectedValueBinding="refTgtListSelVal@pageSegmentBean@">
            <uix:contents 
                 childDataBinding="refTgtList@pageSegmentBean@">
              <uix:option
                   textBinding="REF_TGT_TYPE_TEXT" 
                   valueBinding="REF_TGT_TYPE_VAL"/>
            </uix:contents>
          </uix:messageChoice>
          <uix:messageTextInput
               id="refTgtsWork"
               name="refTgtsWork"
               promptBinding="CLUSTER_IDENTIFICATION_ADVANCED_WORK@provCommonRB"
               shortDescBinding="CLUSTER_IDENTIFICATION_ADVANCED_WORK@provCommonRB"
               tipBinding="CLUSTER_IDENTIFICATION_ADVANCED_WORK_TIP@provCommonRB"
               textBinding="refTgtWorkDir@pageSegmentBean@"/>
        </uix:labeledFieldLayout> 
        <uix:rowLayout 
             width="100%"
             renderedBinding="displayExcludeFilesTable@pageSegmentBean@">
          <uix:spacer width="100%" height="10"/>
          <%@ include file="ProvExcludeFiles.jspf" %>
        </uix:rowLayout>
      </uix:hideShowHeader>
    </uix:rowLayout>
  </uix:dataScope>
</oem:pageSegment>

