<%--
  - FILE
  -   DeleteNode.jsp
  -
  - DESCRIPTION
  -   The Extend Cluster main page, this page would consist of the 
  -   Clsuter Identification, the Target Selection, the Schedule
  -   and the Credntials sections.
  -
  - MODIFIED    (MM/DD/YY)
  -  rvaidhiy    07/17/07 - fixing exit review comments
  -  igoswami    08/27/06 - Plugging in the Select RAC Cluster and Select Nodes
  -                         to delete sections
  -  suravind    08/08/06 - XbranchMerge suravind_ec_changes_review_page from
  -                         main
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  suravind    04/11/06 - Creation
  -
  - SINCE
  -  10.2+
  --%>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <%-- Header for the Extend Cluster page --%>
    <uix:header textBinding="DELETE_NODE_PAGE_HEADER@deleteNodeRB">
        <uix:styledText 
             textBinding="DELETE_NODE_IDENTIFICATION_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
        <uix:spacer width="100%" height="5"/>
        <%-- Header for the Extend Cluster - Cluster Identification section--%> 
        <uix:header textBinding="CLUSTER_IDENTIFICATION_HEADER@deleteNodeRB">
            <uix:tip>
              <uix:styledText
                 textBinding="DEL_NODE_SELECTION_INFO_TEXT@deleteNodeRB"
                 styleClass="OraTipText"/>
            </uix:tip>
            <uix:spacer width="100%" height="10"/>
            <uix:ref refID="PAGE_SEGMENT_TYPE_RAC_REG_CLUSTERS"/>
            
        </uix:header>
		
		
        <%-- Select Nodes for deletion region--%>
        <uix:header textBinding="TARGET_SELECTION_HEADER@deleteNodeRB">
        <uix:styledText 
             textBinding="TARGET_SELECTION_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
        <uix:spacer width="100%" height="10"/>
        <uix:shuttle name="shuttleNodes"  reorderable="false"
            leadingHeaderBinding="AVAILABLE_NODES@deleteNodeRB"
            trailingHeaderBinding="SELECTED_NODES@deleteNodeRB"
						size="5">
				<uix:leading>
					<uix:list name="AvailableNodeList"
							  id="AvNodeListBox" shortDesc="AVAILABLE_NODES@deleteNodeRB">
						<uix:contents childDataBinding="availableNodeList@SEL_TAR_BEAN@servletRequest">
						   <uix:option 
                  textBinding="avlNodeTxt"
                  valueBinding="avlNodeVal">
               </uix:option>
						</uix:contents>
					</uix:list>
				</uix:leading>

				<uix:trailing>
					<uix:list name="SelectedNodeList" shortDesc="SELECTED_NODES@deleteNodeRB"
					          id="SelNodeListBox">
						 <uix:contents childDataBinding="selectedNodeList@SEL_TAR_BEAN@servletRequest">
						   <uix:option 
                  textBinding="selNodeTxt"
                  valueBinding="selNodeVal">
               </uix:option>
						</uix:contents>
					</uix:list>
				</uix:trailing>
			</uix:shuttle>    
        </uix:header>
<%--        <uix:flowLayout>
          <uix:styledText 
               textBinding="CLUSTER_IDENTIFICATION_SEARCH_TEXT@deleteNodeRB"
               styleClass="OraInstructionText"/>
          <uix:spacer width="10" height="10"/>
          <uix:choice
               id="searchChoice"
               name="searchChoice"
               selectedValueBinding="searchListSelVal@REG_CLUSTERS_BEAN@servletRequest">
            <uix:contents 
                 childDataBinding="searchList@REG_CLUSTERS_BEAN@servletRequest">
              <uix:option
                   textBinding="SEARCH_TYPE_TEXT" 
                   valueBinding="SEARCH_TYPE_VAL"/>
            </uix:contents>
          </uix:choice>
          <uix:spacer width="10" height="10"/>
          <uix:textInput
          	label="searchValue"
          	shortDesc="searchValue"
               id="searchValue"
               name="searchValue"
               columns="20"/>
          <uix:spacer width="10" height="10"/>
          <uix:button 
               textBinding="CLUSTER_IDENTIFICATION_SEARCH_GO@deleteNodeRB"
               primaryClientActionBinding="onClickSearch@servletRequest"/>
        </uix:flowLayout>
        <uix:spacer width="100%" height="10"/>
        <uix:hGrid
             id="regClustersHGrid"
             partialRenderMode="self"
             alternateTextBinding="CLUSTER_IDENTIFICATION_HGRID_ALT_TEXT@deleteNodeRB"
             proxyBinding="regClustersHGridProxy@servletRequest"
             formSubmitted="true"
             childBlockSize="5"
             width="100%"
             treeDataBinding="rows@REG_CLUSTERS_BEAN@servletRequest">
          <uix:tableSelection>
            <uix:singleSelection 
                 selectedBinding="IS_SELECTED"
                 renderedBinding="IS_RENDERED"
                 disabledBinding="IS_DISABLED"
                 primaryClientActionBinding="ON_CLICK_RADIO"/>
          </uix:tableSelection>
          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_NAME@deleteNodeRB"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_NODES@deleteNodeRB"/>
              </uix:columnHeader>
              <uix:styledText textBinding="HOSTS_ATTR"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_HOME@deleteNodeRB"/>
              </uix:columnHeader>
              <uix:styledText textBinding="HOME_ATTR"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_PTFORM@deleteNodeRB"/>
              </uix:columnHeader>
              <uix:styledText textBinding="PTFORM_ATTR"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="CLUSTER_IDENTIFICATION_HGRID_COLUMN_PDT@deleteNodeRB"/>
              </uix:columnHeader>
              <uix:styledText textBinding="PDT_ATTR"/>
            </uix:column>
        </uix:hGrid>
        <uix:rowLayout id="regClustersAdvanced">
        <uix:hideShowHeader 
             id="regClustersHideShow"
             partialRenderMode="self"
             formSubmitted="true"  
             renderedBinding="advancedHeaderRendered@REG_CLUSTERS_BEAN@servletRequest"
             textBinding="advancedHeaderText@REG_CLUSTERS_BEAN@servletRequest"
             disclosedBinding="advancedHeaderDisclosed@REG_CLUSTERS_BEAN@servletRequest">
          <uix:spacer width="100%" height="10"/>
          <uix:labeledFieldLayout
                width="50%">
            <uix:messageChoice
                 id="refTgtsChoice"
                 name="refTgtsChoice"
                 promptBinding="CLUSTER_IDENTIFICATION_ADVANCED_REF_TGT@deleteNodeRB"
                 tipBinding="CLUSTER_IDENTIFICATION_ADVANCED_REF_TGT_TIP@deleteNodeRB"
                 primaryClientActionBinding="onChangeRefTgtChoice@servletRequest"
                 selectedValueBinding="refTgtListSelVal@REG_CLUSTERS_BEAN@servletRequest">
              <uix:contents 
                   childDataBinding="refTgtList@REG_CLUSTERS_BEAN@servletRequest">
                <uix:option
                     textBinding="REF_TGT_TYPE_TEXT" 
                     valueBinding="REF_TGT_TYPE_VAL"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:messageTextInput
                 id="refTgtsWork"
                 name="refTgtsWork"
                 promptBinding="CLUSTER_IDENTIFICATION_ADVANCED_WORK@deleteNodeRB"
                 tipBinding="CLUSTER_IDENTIFICATION_ADVANCED_WORK_TIP@deleteNodeRB"
                 textBinding="refTgtWorkDir@REG_CLUSTERS_BEAN@servletRequest"/>
          </uix:labeledFieldLayout> 
        </uix:hideShowHeader>
</uix:rowLayout> --%>
      <%-- Header for the Extend Cluster - Selected Targets section  --%>

	  <%-- </uix:header> --%>
<%--        <uix:header textBinding="TARGET_SELECTION_HEADER@deleteNodeRB">
        <uix:styledText 
             textBinding="TARGET_SELECTION_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
        <uix:spacer width="100%" height="15"/>
        <uix:table 
             nameBinding="tableName@SEL_TAR_BEAN@servletRequest"
             id="hostTable"
             summary="hostTable"
             partialRenderMode="self"
             formSubmitted="true"
             tableDataBinding="rows@SEL_TAR_BEAN@servletRequest"
             valueBinding="currentValue@SEL_TAR_BEAN@servletRequest"
             minValueBinding="minValue@SEL_TAR_BEAN@servletRequest"
             blockSizeBinding="blockSize@SEL_TAR_BEAN@servletRequest"
             maxValueBinding="maxValue@SEL_TAR_BEAN@servletRequest"
             alternateTextBinding="hostTableAltText@servletRequest"
             columnHeaderDataBinding="columnHeaders@SEL_TAR_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>      
          <uix:tableActions >
	    <uix:flowLayout>
              <uix:cellFormat hAlign="left" width="5%">
                <uix:button 
                     name="addTargets"
                     onClickBinding="addButtonOnClick@SEL_TAR_BEAN@servletRequest"
                     textBinding="TARGET_SELECTION_TABLE_ACTION_ADD@deleteNodeRB"/>   
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="10%">
                <uix:button 
                     name="uploadCCF"
                     onClickBinding="ccfButtonOnClick@SEL_TAR_BEAN@servletRequest"
                     textBinding="TARGET_SELECTION_TABLE_ACTION_CCF@deleteNodeRB"/>   
              </uix:cellFormat>
              <uix:cellFormat hAlign="right" width="85%">
                <uix:hideShow
                     id="hostTableHideShow"
                     partialRenderMode="multiple" 
                     partialTargets="hostTable" 
                     formSubmitted="true"
                     undisclosedTextBinding="TARGET_SELECTION_TABLE_ACTION_ADV@deleteNodeRB"
                     disclosedTextBinding="TARGET_SELECTION_TABLE_ACTION_SIMPLE@deleteNodeRB"
                     disclosedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"/> 
             </uix:cellFormat>
	  </uix:flowLayout>
          </uix:tableActions>
          <uix:styledText textBinding="HOST_NAME"/>
          <uix:textInput 
          	label="private host name"
               name="privHostname" 
               renderedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"
               disabledBinding="rowDisabled"
               columns="15" 
               textBinding="PRIV_HOST"/>
          <uix:textInput 
               name="privHostIp" 
               label="private host ip"
               columns="15" 
               renderedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"
               disabledBinding="rowDisabled"
               textBinding="PRIV_IP"/>
          <uix:textInput 
               name="vipHostname" 
               label="vip host name"
               columns="15" 
               disabledBinding="rowDisabled"
               textBinding="VIP_HOST"/>
          <uix:textInput 
               name="vipHostIp" 
               label="vip host ip"
               columns="15" 
               disabledBinding="rowDisabled"
               renderedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"
               textBinding="VIP_IP"/>
          <uix:textInput 
          	label="tmp directory"
               name="tmpDir" 
               renderedBinding="hideShowDisclosed@SEL_TAR_BEAN@servletRequest"
               columns="25" 
               textBinding="TMP_DIR"/>
          <uix:image	
          	alt="TARGET_SELECTION_TABLE_ACTION_REMOVE@deleteNodeRB"
               source="/em/images/deleteicon_enabled.gif"
               primaryClientActionBinding="REMOVE_DEST"
               textBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE@deleteNodeRB"/>
          <uix:footer>
            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%" hAlign="right">
                <uix:button 
                     textBinding="TARGET_SELECTION_TABLE_ACTION_REMOVE_ALL@deleteNodeRB"
                     disabledBinding="removeAllButtonDisabled@SEL_TAR_BEAN@servletRequest"
                     primaryClientActionBinding="onClickRemoveAllHosts@servletRequest"/>
              </uix:rowLayout>  
            </uix:tableLayout>
          </uix:footer>
        </uix:table>      
      </uix:header> --%>
      <%-- Credentials Section Starts --%>
      <%-- disclosed="true" --%>
      <uix:hideShowHeader 
           id="credsHideShow"
           partialRenderMode="multiple"
           partialTargets="credsCollapsedText"
           formSubmitted="true"
           text="User Credentials (Override Preferred Credentials)"
           textBinding="hideShowHeaderText@CREDENTIALS_BEAN@servletRequest"
           disclosedBinding="hideShowDisclosed@CREDENTIALS_BEAN@servletRequest">
           <uix:spacer height="10" width="100%"/>         
        <uix:styledText 
             textBinding="CREDENTIALS_EXPANDED_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
        <uix:header textBinding="CREDENTIALS_CLUSTER_HEADER@deleteNodeRB">
          <%--<uix:spacer height="10"/>--%>
          <uix:tip>
            <uix:styledText
                 textBinding="CREDENTIALS_CLUSTER_TIP@deleteNodeRB"
                 renderedBinding="sudoTipRendered@CREDENTIALS_BEAN@servletRequest"
                 styleClass="OraPromptText"/>
          </uix:tip>
          <uix:spacer height="10"/>
          <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_HOMES_INSTANCE"/>
        </uix:header>
        <uix:tableLayout width="100%">
          <uix:rowLayout
               renderedBinding="credsForLibStepRendered@CREDENTIALS_BEAN@servletRequest">
            <uix:header 
                 textBinding="CREDENTIALS_LIB_STEP_HEADER@deleteNodeRB">
              <uix:spacer height="10"/>
              <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_LS_INSTANCE"/>
            </uix:header>  
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:tableLayout width="100%">
          <uix:rowLayout
               renderedBinding="asmCredsSecRendered@CREDENTIALS_BEAN@servletRequest">
            <uix:header 
                 textBinding="asmCredsHeaderText@CREDENTIALS_BEAN@servletRequest">
              <uix:spacer height="10"/>
              <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_ASM_INSTANCE"/>
            </uix:header>  
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:tableLayout width="100%">
          <uix:rowLayout
               renderedBinding="dbCredsSecRendered@CREDENTIALS_BEAN@servletRequest">
            <uix:header
                 textBinding="dbCredsHeaderText@CREDENTIALS_BEAN@servletRequest">
                 <uix:tip
                    textBinding="CREDENTIALS_TIP_DB_TEXT@deleteNodeRB">
               </uix:tip>
              <uix:spacer height="10"/>
              <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDENTIALS_SEGMENT_DB_INSTANCE"/>
            </uix:header>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:hideShowHeader>
      <uix:rowLayout id="credsCollapsedText">
        <uix:cellFormat width="5%">
          <uix:spacer/>         
        </uix:cellFormat>
        <uix:cellFormat width="90%">
          <uix:styledText 
               textBinding="CREDENTIALS_COLLAPSED_TEXT@deleteNodeRB"
               renderedBinding="collapsedTextRendered@CREDENTIALS_BEAN@servletRequest"
               styleClass="OraInstructionText"/>
        </uix:cellFormat>
      </uix:rowLayout>  
      <%-- Credentials Section Ends --%>
      <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_SCHEDULE"/>
    </uix:header>
  </uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
