<%--
  - FILE
  -   DeleteNodeReview.jsp
  -
  - DESCRIPTION
  -   The Extend Cluster main page, this page would consist of the 
  -   Clsuter Identification, the Target Selection, the Schedule
  -   and the Credntials sections.
  -
  - MODIFIED    (MM/DD/YY)
  -  igoswami    08/31/06 - 
  -  suravind    07/05/06 - Review page content building 
  -  suravind    04/12/06 - Review page for Extend Cluster project 
  -  suravind    04/11/06 - Creation
  -
  - SINCE
  -  10.2+
  --%>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:dataScope currentDataBinding="servletRequest">
    <uix:header 
         textBinding="REVIEW_HEADER_TEXT@deleteNodeRB">
      <uix:styledText 
             textBinding="REVIEW_LABEL_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
      <uix:header
           textBinding="REVIEW_HEADER_RAC@deleteNodeRB">
        <uix:messageComponentLayout promptWidth="10%">
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_DATABASE_NAME@deleteNodeRB"
               textBinding="racTgtName@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText" />
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@deleteNodeRB"
               textBinding="racOracleHome@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@deleteNodeRB"
               textBinding="racUsername@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
        </uix:messageComponentLayout>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_CRS@deleteNodeRB">
        <uix:messageComponentLayout promptWidth="10%">
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_CLUSTER_NAME@deleteNodeRB"
               textBinding="clusterTgtName@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@deleteNodeRB"
               textBinding="clusterOracleHome@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@deleteNodeRB"
               textBinding="clusterUsername@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
        </uix:messageComponentLayout>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_ASM@deleteNodeRB"
           renderedBinding="asmSectionRendered@REVIEW_BEAN@servletRequest">
        <uix:messageComponentLayout promptWidth="10%">
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ASM_NAME@deleteNodeRB"
               textBinding="asmTgtName@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@deleteNodeRB"
               textBinding="asmOracleHome@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@deleteNodeRB"
               textBinding="asmUsername@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
        </uix:messageComponentLayout>
      </uix:header>
	  <%--adding the shuttle for available/selected nodes display --%>
	  <uix:header textBinding="REVIEW_HEADER_NEW_NODES@deleteNodeRB">
	        <uix:messageComponentLayout promptWidth="10%">
          <%--<uix:styledText 
             textBinding="TARGET_SELECTION_REVIEW_TEXT@deleteNodeRB"
             styleClass="OraInstructionText"/>
            <uix:spacer width="100%" height="10"/>--%>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_SELECTED_CLUSTER_NAME@deleteNodeRB"
               textBinding="selectedCRSName@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
          <uix:messageLayout rendered="true" promptBinding="SELECTED_NODES@deleteNodeRB">
             <uix:contents>
  
           
			<%--<uix:spacer width="100%" height="2"/>
			<uix:shuttle name="shuttleNodes" 
						leadingHeaderBinding="AVAILABLE_NODES@deleteNodeRB"
						trailingHeaderBinding="SELECTED_NODES@deleteNodeRB"
						disabled="true" 
						reorderable="false" 
            size="5">
				<uix:leading>
					<uix:list name="AvailableNodeList">
						<uix:contents childDataBinding="availableNodeList@REVIEW_BEAN@servletRequest">
						   <uix:option 
								textBinding="avlNodeTxt"
								valueBinding="avlNodeVal">
							</uix:option>
						</uix:contents>
					</uix:list>
				</uix:leading>

				<uix:trailing>--%>
					<uix:list name="SelectedNodeList"  shortDesc="SELECTED_NODES@deleteNodeRB"
                    disabled="false" 
                    multiple="true"
                    size="6">
						 <uix:contents childDataBinding="selectedNodeList@REVIEW_BEAN@servletRequest">
						   <uix:option 
								textBinding="selNodeTxt"
								valueBinding="selNodeVal">
							</uix:option>
						</uix:contents>
					</uix:list>
          </uix:contents>
          </uix:messageLayout>
          </uix:messageComponentLayout>
		  <uix:spacer width="100%" height="10" renderedBinding="rvwTipRendered@REVIEW_BEAN@servletRequest"/>
		  <uix:tip renderedBinding="rvwTipRendered@REVIEW_BEAN@servletRequest">
            <uix:styledText
                 textBinding="DEL_ENTIRE_CLUSTER_INFO_TEXT@deleteNodeRB"
                 styleClass="OraTipText"/>
          </uix:tip>
				<%--</uix:trailing>
			  </uix:shuttle>    --%>
      </uix:header>
      <%--<uix:header
           textBinding="REVIEW_HEADER_EXISTING_NODES@deleteNodeRB">
        <uix:table 
             name="existingRACTgtsTable"
             id="existingRACTgtsTable"
             summary="existingRACTgtsTable"
             tableDataBinding="existingRACRows@REVIEW_BEAN@servletRequest"
             alternateTextBinding="TARGET_SELECTION_TABLE_ALT_TEXT@deleteNodeRB"
             columnHeaderDataBinding="existingRACColumnHeaders@REVIEW_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>
          <uix:styledText textBinding="HOST_NAME"/>
          <uix:styledText textBinding="PRIV_HOST"/>
          <uix:styledText textBinding="PRIV_IP"/>
          <uix:styledText textBinding="VIP_HOST"/>
          <uix:styledText textBinding="VIP_IP"/>
        </uix:table>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_NEW_NODES@deleteNodeRB">
        <uix:table 
             name="newTargetsTable"
             id="newTargetsTable"
             summary="newTargetsTable"
             tableDataBinding="newTargetsRows@REVIEW_BEAN@servletRequest"
             alternateTextBinding="TARGET_SELECTION_TABLE_ALT_TEXT@deleteNodeRB"
             columnHeaderDataBinding="newTargetsColumnHeaders@REVIEW_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>
          <uix:styledText textBinding="HOST_NAME"/>
          <uix:styledText textBinding="PRIV_HOST"/>
          <uix:styledText textBinding="PRIV_IP"/>
          <uix:styledText textBinding="VIP_HOST"/>
          <uix:styledText textBinding="VIP_IP"/>
          <uix:styledText textBinding="CRS_REQD"/>
          <uix:styledText textBinding="ASM_REQD"/>
        </uix:table>
      </uix:header>--%>
      <uix:header
           textBinding="REVIEW_HEADER_SCHEDULE@deleteNodeRB">
        <uix:messageComponentLayout promptWidth="10%">
           <uix:messageStyledText
               promptBinding="REVIEW_LABEL_SCH@deleteNodeRB"
               textBinding="scheduleInfo@REVIEW_BEAN@servletRequest"
               styleClass="OraDataText"/>
        <%--<uix:tableLayout>
        <uix:rowLayout vAlign="top">
          <uix:styledText
            textBinding="REVIEW_LABEL_SCH@deleteNodeRB"
            styleClass="OraPromptText">
          </uix:styledText>
          <uix:spacer width="5"/>
          <uix:formattedText
            textBinding="scheduleInfo@REVIEW_BEAN@servletRequest"
            styleClass="OraDataText">
          </uix:formattedText>
        </uix:rowLayout>
        </uix:tableLayout> --%> 
        </uix:messageComponentLayout>
      </uix:header>
    </uix:header>
  </uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>

