<%--
  - FILE
  -   SelectNodes.jsp
  -
  - DESCRIPTION
   -
  - MODIFIED   (MM/DD/YY)
  -   kmakhija   06/08/08  - Security fix
  -   igoswami   08/31/06  - 
  -   suravind   02/23/06  - Sample CCF link replacement 
  -   suravind   02/02/06  - CCF Upload page 
  -   suravind   01/06/06  - created
--%>

<%@ page contentType="text/html; charset=UTF-8" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
  <uix:bundle
    name="deleteNodeRB"
    class="oracle.sysman.pp.dn.ui.rb.DeleteNodeRB"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm"
        method="post">

        <uix:pageLayout titleBinding="TARGET_SELECTION_HEADER@deleteNodeRB">

          <%--To display the cancel and select buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="selNodeCancel">
              </uix:submitButton>

              <%--Select Button--%>
              <uix:submitButton
                textBinding="OK@commonResourceBundle"
                name="event"
                value="selNodeSubmit">
              </uix:submitButton>

            </uix:pageButtonBar>
          </uix:pageButtons>

          <%-- The message box to show error/info messge etc--%>
          <uix:messageBox 
            messageTypeBinding="msgType@msgInfo@servletRequest"
            messageBinding="msg@msgInfo@servletRequest"
            rendered="false"
            renderedBinding="rendered@msgInfo@servletRequest">
          </uix:messageBox>

         <uix:header  textBinding="SELECTED_NODES_ADD_REMOVE@deleteNodeRB">
		    <uix:spacer width="100%" height="15"/>
            <uix:shuttle name="shuttleNodes" 
            leadingHeaderBinding="AVAILABLE_NODES@deleteNodeRB"
            trailingHeaderBinding="SELECTED_NODES@deleteNodeRB"
						size="5">
				<uix:leading>
					<uix:list>
						<uix:contents>
						   <uix:option text="node6.example.com"/>
						   <uix:option text="node7.example.com"/>
						</uix:contents>
					</uix:list>
				</uix:leading>

				<uix:trailing>
					<uix:list>
						 <uix:contents>
						   <uix:option text="node1.example.com"/>
						   <uix:option text="node2.example.com"/>
						   <uix:option text="node3.example.com"/>
						   <uix:option text="node4.example.com"/>
						   <uix:option text="node5.example.com"/>
						 </uix:contents>
					</uix:list>
				</uix:trailing>
			</uix:shuttle>
         </uix:header>
                  
        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
