<%--
  - FILE
  -   ExtendCluster.jsp
  -
  - DESCRIPTION
  -   The Extend Cluster main page, this page would consist of the 
  -   Clsuter Identification, the Target Selection, the Schedule
  -   and the Credntials sections.
  -
  - MODIFIED    (MM/DD/YY)
  -  suravind    08/11/07 - Shared info changes
  -  suravind    08/17/06 - XbranchMerge suravind_ec_directives from main
  -  suravind    08/08/06 - XbranchMerge suravind_ec_changes_review_page from
  -                         main
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  vsagar      07/18/06 - ec 10.2.0.3.0 backport 
  -  suravind    07/05/06 - Review page content building 
  -  suravind    04/12/06 - Review page for Extend Cluster project 
  -  suravind    04/11/06 - Creation
  -
  - SINCE
  -  10.2+
  --%>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:dataScope currentDataBinding="servletRequest">
    <uix:header 
         textBinding="REVIEW_HEADER_TEXT@extendClusterRB">
      <uix:styledText 
             textBinding="REVIEW_LABEL_TEXT@extendClusterRB"
             styleClass="OraInstructionText"/>
      <uix:header
           textBinding="REVIEW_HEADER_CRS@extendClusterRB">
        <uix:labeledFieldLayout>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_CLUSTER_NAME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="clusterTgtName@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="clusterOracleHome@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_EXCLUDE_FILE_LIST@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="clusterExcludeList@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="clusterUsername@REVIEW_BEAN@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_RAC@extendClusterRB">
        <uix:labeledFieldLayout>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_CLUSTER_NAME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="racTgtName@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="racOracleHome@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_SHARED_HOME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="racHomeShared@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_EXCLUDE_FILE_LIST@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="racExcludeList@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="racUsername@REVIEW_BEAN@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_ASM@extendClusterRB"
           renderedBinding="asmSectionRendered@REVIEW_BEAN@servletRequest">
        <uix:labeledFieldLayout>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_CLUSTER_NAME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="asmTgtName@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_ORACLE_HOME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="asmOracleHome@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_SHARED_HOME@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="asmHomeShared@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_EXCLUDE_FILE_LIST@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="asmExcludeList@REVIEW_BEAN@servletRequest"/>
          <uix:messageStyledText
               promptBinding="REVIEW_LABEL_USER@extendClusterRB"
               styleClass="OraInstructionTextStrong"
               textBinding="asmUsername@REVIEW_BEAN@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_EXISTING_NODES@extendClusterRB">
        <uix:table 
             name="existingRACTgtsTable"
             id="existingRACTgtsTable"
             summary="existingRACTgtsTable"
             tableDataBinding="existingRACRows@REVIEW_BEAN@servletRequest"
             alternateTextBinding="TARGET_SELECTION_TABLE_ALT_TEXT@extendClusterRB"
             columnHeaderDataBinding="existingRACColumnHeaders@REVIEW_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>
          <uix:styledText textBinding="HOST_NAME"/>
          <uix:styledText textBinding="PRIV_HOST"/>
          <uix:styledText textBinding="PRIV_IP"/>
          <uix:styledText textBinding="VIP_HOST"/>
          <uix:styledText textBinding="VIP_IP"/>
        </uix:table>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_NEW_NODES@extendClusterRB">
        <uix:table 
             name="newTargetsTable"
             id="newTargetsTable"
             summary="newTargetsTable"
             tableDataBinding="newTargetsRows@REVIEW_BEAN@servletRequest"
             alternateTextBinding="TARGET_SELECTION_TABLE_ALT_TEXT@extendClusterRB"
             columnHeaderDataBinding="newTargetsColumnHeaders@REVIEW_BEAN@servletRequest">
          <uix:columnHeaderStamp>
            <uix:text
                 textBinding="text">
            </uix:text>
          </uix:columnHeaderStamp>
          <uix:styledText textBinding="HOST_NAME"/>
          <uix:styledText textBinding="PRIV_HOST"/>
          <uix:styledText textBinding="PRIV_IP"/>
          <uix:styledText textBinding="VIP_HOST"/>
          <uix:styledText textBinding="VIP_IP"/>
          <uix:styledText textBinding="CRS_REQD"/>
          <uix:styledText textBinding="ASM_REQD"/>
        </uix:table>
      </uix:header>
      <uix:header
           textBinding="REVIEW_HEADER_SCHEDULE@extendClusterRB">
        <uix:styledText
             styleClass="OraInstructionTextStrong"
             textBinding="schedule@REVIEW_BEAN@servletRequest"/>
      </uix:header>
    </uix:header>
  </uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>

