<%--
  - FILE
  -   credentials.jsp
  -
  - DESCRIPTION
  -   Credentials page
  -
  - MODIFIED    (MM/DD/YY)
  -  ktamtoro    03/02/06   -
  -  clo         10/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        text="Specify the necessary credentials to run the procedures on the indicated targets."
        styleClass="oraInstructionText"/>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>
  <uix:header text="Host Credentials">
    <uix:spacer height="10"/>
    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:messageRadioButton
            name="usePrefRdBtn"
            text="Use Preferred Credentials"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:messageRadioButton
            name="overridePrefRdBtn"
            text="Override Preferred Credentials"
            selected="true"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat width="3%">
        </uix:cellFormat>
        <uix:cellFormat>
                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout>
                      <uix:messageChoice
                        name="hostOptionsList"
                        prompt="Specify for">
                          <uix:option text="All hosts" selected="true"/>
                          <uix:option text="Each host"/>
                      </uix:messageChoice>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="username"
                        prompt="Username"
                        noAutoComplete="true"/>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="password"
                        prompt="Password"
                        secret="true"
                        noAutoComplete="true"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:messageTextInput columns="25"
                        name="confirmPassword"
                        prompt="Confirm Password"
                        secret="true"
                        noAutoComplete="true"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    </uix:header>
    <uix:spacer height="10"/>
</uix:buildTree>

<%
  int navIndex = 3;
  int maxIndex = 5;
  int minIndex = 1;
%>

<%@ include file="template.jspf" %>

