<%--
  - FILE
  -   TargetList.jsp
  -
  - DESCRIPTION
  -   Target list selection page
  -
  - MODIFIED    (MM/DD/YY)
  -  clo         10/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

  <%--All page contents should be within this tag--%>
  <uix:buildTree nodeID="pageContent" scope="request">
    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText text="The procedure operates on targets. This page allows you to specify the targets." 
                        styleClass="oraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>
    <uix:spacer height="10"/>

    <%--Should be dynamic--%>
    <uix:stackLayout>
      <uix:header text="Assign the target lists below.">
        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="left">
            <uix:cellFormat hAlign="left">
              <uix:button text="Assign"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:table id="targetTable" width="100%" partialRenderMode="self" showAll="yes" value="1">
          <uix:contents>
            <uix:column>
              <uix:columnHeader>
                <uix:text text="Select"/>
              </uix:columnHeader>
            </uix:column>          
            <uix:column>
              <uix:columnHeader>
                <uix:text text="Target List"/>
              </uix:columnHeader>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:text text="Target Type"/>
              </uix:columnHeader>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:text text="Assigned Targets"/>
              </uix:columnHeader>
            </uix:column>
          </uix:contents>
        </uix:table>
      </uix:header>
    </uix:stackLayout>
  </uix:buildTree>

<%   
  int navIndex = 1;
  int maxIndex = 5;
  int minIndex = 1;
%>
<%@ include file="template.jspf"%>
