<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder  id="renderingContext"/>

<%--ResourceBundle for labels/headers specific to Target Selector--%>
<uix:bundle
name="paRB"
class="oracle.sysman.pp.pa.ui.rb.PatchAdvisorRB"/>

<uix:document>

<%--To help in partial page renderring--%>
<%@ include file="/enablePPR.jspf" %>

<%--
- To display "Oracle Enterprise Manager" followed by
- UserName on PageTitle. To append page specific string
- in the title implement getPageHeader() in the
- CONTROLLER CLASS.
--%>
<%@ include file="/oemTitle.jspf" %>

<uix:body>
<uix:form
name="pageForm"
method="post">

<uix:pageLayout titleBinding="pageHeader@servletRequest">

  <%--To display GlobalTabs, Buttons, Footer, Copyright etc--%>
  <%@ include file="/oemGlobal.jspf" %>

  <%--The message box to show error/info messge etc--%>
  <uix:messageBox
    messageTypeBinding="msgType@msgInfo@servletRequest"
    messageBinding="msg@msgInfo@servletRequest"
    rendered="false"
    renderedBinding="rendered@msgInfo@servletRequest">
  </uix:messageBox>

  <uix:stackLayout>

    <uix:spacer height="10"/> 
    
    <uix:tableLayout width="100%" cellSpacing="10" rendered="true"> 
        <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                      <uix:cellFormat columnSpan="3">
                        <uix:contents> 
                            <uix:styledText textBinding="ARU_DLOAD_PAR_DESC1@paRB"
                                        styleClass="OraInstructionText">
                            </uix:styledText>
                        </uix:contents>
                      </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout>
              <uix:cellFormat columnSpan="3"/>
              </uix:rowLayout> 
              <uix:rowLayout>
                    <uix:contents> 
                            <uix:cellFormat width="20%" vAlign="top">
                              <uix:styledText textBinding="ARU_DLOAD_PAR_SELECT_LABEL@paRB"
                                styleClass="oraInstructionText">
                              </uix:styledText>
                            </uix:cellFormat>

                            <uix:cellFormat width="7%" vAlign="top">
                              <uix:messageRadioButton
                                id="dloadSingleFileRdBtnID"
                                name="dloadSingleFileRdBtn"
                                textBinding="ARU_DLOAD_SINGLE_LABEL@paRB"
                                shortDescBinding="ARU_DLOAD_SINGLE_LABEL@paRB"
                                selectedBinding="dloadSingleFileRdBtnStatus@pageBean@servletRequest"
                                primaryClientActionBinding="clkSingleFile@servletRequest"/>
                            </uix:cellFormat>
                       <%-- 
                        <uix:rowLayout id="singleSwitcher" vAlign="top">                              
                          <uix:switcher childNameBinding="dloadSingle@pageBean@servletRequest">

                            <uix:case name="Single"> --%>
                              <uix:messageTextInput
                                   name="fileID"
                                   textBinding="fileID@servletRequest"
                                   promptBinding="ARU_DLOAD_SINGLE_FILEID_LABEL@paRB"
                                   renderedBinding="dloadSingleFileRdBtnStatus@pageBean@servletRequest"
                                   shortDescBinding="ARU_DLOAD_SINGLE_FILEID_LABEL@paRB"
                                   tipBinding="ARU_DLOAD_SINGLE_FILE_TIP@paRB">
                              </uix:messageTextInput>
                     <%--
                            </uix:case>
			    <uix:default>
                               <uix:cellFormat columnSpan="2" vAlign="bottom"/>  
			    </uix:default>
                         </uix:switcher>
                       </uix:rowLayout> --%>
                      </uix:contents>    
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:contents>
                        <uix:spacer width="0"/>
                        <uix:cellFormat columnSpan="2" vAlign="top">  
                        <uix:contents>
                          <uix:messageRadioButton
                                id="dloadMultipleFilesRdBtnID"
                                name="dloadMultipleFilesRdBtn"
                                textBinding="ARU_DLOAD_ALL_LABEL@paRB"
                                shortDescBinding="ARU_DLOAD_ALL_LABEL@paRB"
                                selectedBinding="dloadMultipleFilesRdBtnStatus@pageBean@servletRequest"
                                primaryClientActionBinding="clkMultipleFiles@servletRequest"/>
                        </uix:contents>
                        </uix:cellFormat>
                     </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:contents>
                        <uix:spacer width="0"/>
                        <uix:cellFormat columnSpan="2">  
                        <uix:contents>
                          <uix:tip>
                              <uix:contents>
                                   <uix:styledText styleClass="OraTipText" textBinding="ARU_DLOAD_PAR_SELECT_TIP@paRB"/>
                              </uix:contents>
                          </uix:tip>
                         </uix:contents>     
                        </uix:cellFormat>
                   </uix:contents>     
                </uix:rowLayout> 
              </uix:contents>
        </uix:tableLayout> 

        <uix:spacer height="10"/> 

        <uix:tableLayout width="100%"  cellSpacing="10" rendered="true">
            <uix:contents>
              <uix:rowLayout>
                  <uix:messageTextInput
                           name="workDir"
                           textBinding="workDir@pageBean@servletRequest"
                           promptBinding="ARU_DLOAD_CS_DIR_LABEL@paRB"
                           tipBinding="ARU_DLOAD_DIR_TIP4@paRB"
                           shortDescBinding="ARU_DLOAD_CS_DIR_LABEL@paRB">
                  </uix:messageTextInput>
               </uix:rowLayout>

              <uix:rowLayout>
                    <uix:contents>
                        <uix:cellFormat columnSpan="2">  
                        <uix:contents>
                          <uix:tip>
                              <uix:contents>
                                   <uix:styledText styleClass="OraTipText" textBinding="ARU_DLOAD_DIR_TIP2@paRB"/>
                              </uix:contents>
                          </uix:tip>
                         </uix:contents>     
                        </uix:cellFormat>
                   </uix:contents>     
              </uix:rowLayout>

              <uix:rowLayout>
                    <uix:contents>
                        <uix:cellFormat columnSpan="2">  
                        <uix:contents>
                          <uix:tip>
                              <uix:contents>
                                   <uix:styledText styleClass="OraTipText" textBinding="ARU_DLOAD_DIR_TIP3@paRB"/>
                              </uix:contents>
                          </uix:tip>
                         </uix:contents>     
                        </uix:cellFormat>
                   </uix:contents>     
              </uix:rowLayout>

            </uix:contents>
        </uix:tableLayout> 


        <uix:spacer height="10"/> 

  <uix:rowLayout> 
   <uix:pageButtonBar>

    <%--Cancel button--%>
    <uix:submitButton
        textBinding="RESET@paRB"
        shortDescBinding="RESET@paRB"
        name="event"
        value="cancel">
    </uix:submitButton>

    <uix:spacer height="30"/>

    <uix:submitButton
        textBinding="ARU_DLOAD_DOWNLOAD_BTN@paRB"
        shortDescBinding="ARU_DLOAD_DOWNLOAD_BTN@paRB"
        name="event"
        value="go">
    </uix:submitButton>
    </uix:pageButtonBar>
   </uix:rowLayout> 
        <uix:spacer height="20"/>
        <uix:rowLayout>
          <uix:contents>
               <uix:cellFormat columnSpan="2">  
                    <uix:contents>
                         <uix:tip>
                              <uix:contents>
                                   <uix:styledText styleClass="OraTipText" textBinding="ARU_DLOAD_PAR_DLOAD_TIP@paRB"/>
                              </uix:contents>
                          </uix:tip>
                     </uix:contents>     
                </uix:cellFormat>
          </uix:contents>     
        </uix:rowLayout>
	<uix:spacer height="10"/>
          <uix:header 
            textBinding="RELATED_LINK@paRB">         

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                  <uix:link textBinding="PAR_UPLOAD_TOOL_LINK@paRB" 
                            destination="../paf/admin/procedureInstall"/>
              </uix:cellFormat>
            </uix:rowLayout>     
            
          </uix:tableLayout> 
          
          </uix:header>         

 
       </uix:stackLayout>	  
      </uix:pageLayout>
     </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
