<!---->
<%--
  - FILE
  -   credentials.jsp
  -
  - DESCRIPTION
  -  The credentials step in the Patch Advisor Interview Wizard.
  -
  - MODIFIED   (MM/DD/YY)
  -  kavkrish   09/21/06 - ADA changes
  -  tasingh    02/24/06 - XbranchMerge tasingh_bug-5054725 from 
  -                        st_empp_10.2.0.1.0 
  -  tasingh    02/23/06 - For password fields use noAutoComplete=true. 
  -  spahuja    10/21/05 - 
  -  spahuja    08/24/05   - 
  -  tasingh    07/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="CRED_TXT@patchAdvisorRB"
          styleClass="oraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height="10"/>

    <uix:header textBinding="HOST_CREDS@patchAdvisorRB"
         renderedBinding="hostCredRqd@stepsData@servletRequest" >


    <uix:spacer height="10"/>


    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:messageRadioButton
            name="usePrefRdBtn"
            textBinding="USE_PREF_CREDS@patchAdvisorRB"
            shortDescBinding="USE_PREF_CREDS@patchAdvisorRB"
            selectedBinding="usePrefRdBtn@stepsData@servletRequest"
            onClick="submitForm('pageForm', true, {'event':'clkUsePref'})"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:messageRadioButton
            name="overridePrefRdBtn"
            textBinding="OVERRIDE_PREF_CREDS@patchAdvisorRB"
            shortDescBinding="OVERRIDE_PREF_CREDS@patchAdvisorRB"
            selectedBinding="overridePrefRdBtn@stepsData@servletRequest"
            onClick="submitForm('pageForm', true, {'event':'clkOverridePref'})"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat width="3%">
        </uix:cellFormat>

        <uix:cellFormat>
          <uix:switcher childNameBinding="isOverridePrefClkd@stepsData@servletRequest">
            <uix:case name="true">

              <uix:switcher childNameBinding="isEachHostSelected@stepsData@servletRequest">
                <uix:case name="true">

                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout>
                      <uix:messageChoice
                        name="hostOptionsList"
                        promptBinding="SPECIFY_FOR@patchAdvisorRB"
                        selectedValueBinding="hostOptionSelVal@stepsData@servletRequest"
                        onChange="submitForm('pageForm', true, {'event':'changeHostOption'})">
                        <uix:contents
                          childDataBinding="hostOptionsList@pageData@servletRequest">
                          <uix:option
                            textBinding="hostOption"
                            valueBinding="hostOptionVal"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:table
                        width="100%"
                        name="setCred"
                        id="setCredID"
			summary="Credential Table"
                        partialRenderMode="self"
                        formSubmitted="true"
                        tableDataBinding="setCred@stepsData@servletRequest"
                        columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                        valueBinding="setCredCurrValue@pageData@servletRequest"
                        minValueBinding="setCredMinValue@pageData@servletRequest"
                        blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                        maxValueBinding="setCredMaxValue@pageData@servletRequest">

                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader
                            textBinding="text"
                            sortableBinding="sortable">
                          </uix:sortableHeader>
                        </uix:columnHeaderStamp>


                        <uix:styledText
                          textBinding="targetName"
                          shortDescBinding="HOST@patchAdvisorRB">
                        </uix:styledText>


                        <uix:messageTextInput
                          name="username"
			  prompt="UserName"
                          textBinding="username"
                          noAutoComplete="true"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="usernameMsgType"
                          messageBinding="usernameMsg"/>

                        <uix:messageTextInput
                          name="password"
                          prompt="Password"
                          textBinding="password"
                          noAutoComplete="true"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="passwordMsgType"
                          messageBinding="passwordMsg"
                          secret="true"/>

                       
  
                        
                      </uix:table>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:case>

                <uix:default>

                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:messageChoice
                        name="hostOptionsList"
                        promptBinding="SPECIFY_FOR@patchAdvisorRB"
                        selectedValueBinding="hostOptionSelVal@stepsData@servletRequest"
                        onChange="submitForm('pageForm', true, {'event':'changeHostOption'})">
                        <uix:contents
                          childDataBinding="hostOptionsList@pageData@servletRequest">
                          <uix:option
                            textBinding="hostOption"
                            valueBinding="hostOptionVal"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="username"
                        noAutoComplete="true"
                        promptBinding="USERNAME@patchAdvisorRB"
                        textBinding="username@stepsData@servletRequest"
                        maximumLength="255"
                        required="uiOnly"
                        messageTypeBinding="usernameMsgType@pageData@servletRequest"
                        messageBinding="usernameMsg@pageData@servletRequest"/>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="password"
                        noAutoComplete="true"
                        promptBinding="PASSWORD@patchAdvisorRB"
                        textBinding="password@stepsData@servletRequest"
                        maximumLength="255"
                        secret="true"
                        required="uiOnly"
                        messageTypeBinding="passwordMsgType@pageData@servletRequest"
                        messageBinding="passwordMsg@pageData@servletRequest"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:messageTextInput columns="25"
                        name="cfmPassword"
                        noAutoComplete="true"
                        promptBinding="CONFIRM_PWD@patchAdvisorRB"
                        textBinding="cfmPassword@stepsData@servletRequest"
                        maximumLength="255"
                        secret="true"
                        required="uiOnly"
                        />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:default>
              </uix:switcher>
            </uix:case>

            <uix:default>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:messageChoice
                    name="prefHostCredType"
                    promptBinding="HOST_CREDS@patchAdvisorRB"
                    selectedValueBinding="hostCredentialsTypeSelValue@stepsData@servletRequest">
                    <uix:contents
                      childDataBinding="prefHostCredTypeList@pageData@servletRequest">
                      <uix:option
                        textBinding="hostCredType"
                        valueBinding="hostCredTypeVal"/>
                    </uix:contents>
                  </uix:messageChoice>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:default>
          </uix:switcher>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    </uix:header>

    <uix:spacer height="10"/>

    <uix:header textBinding="HOME_CREDS@patchAdvisorRB"
      renderedBinding="homeCredRqd@stepsData@servletRequest">


    <uix:spacer height="10"/>


    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:messageRadioButton
            name="useOHPrefRdBtn"
            textBinding="USE_HOME_PREF_CREDS@patchAdvisorRB"
            shortDescBinding="USE_HOME_PREF_CREDS@patchAdvisorRB"
            selectedBinding="useOHPrefRdBtn@stepsData@servletRequest"
            onClick="submitForm('pageForm', true, {'event':'clkUseOHPref'})"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:messageRadioButton
            name="overrideOHPrefRdBtn"
            textBinding="OVERRIDE_HOME_PREF_CREDS@patchAdvisorRB"
            shortDescBinding="OVERRIDE_HOME_PREF_CREDS@patchAdvisorRB"
            selectedBinding="overrideOHPrefRdBtn@stepsData@servletRequest"
            onClick="submitForm('pageForm', true, {'event':'clkOverrideOHPref'})"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat width="3%">
        </uix:cellFormat>

        <uix:cellFormat>
          <uix:switcher childNameBinding="isOverrideOHPrefClkd@stepsData@servletRequest">
            <uix:case name="true">

              <uix:switcher childNameBinding="isEachHomeSelected@stepsData@servletRequest">
                <uix:case name="true">

                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout>
                      <uix:messageChoice
                        name="homeOptionsList"
                        promptBinding="SPECIFY_FOR@patchAdvisorRB"
                        selectedValueBinding="homeOptionSelVal@stepsData@servletRequest"
                        onChange="submitForm('pageForm', true, {'event':'changeHomeOption'})">
                        <uix:contents
                          childDataBinding="homeOptionsList@pageData@servletRequest">
                          <uix:option
                            textBinding="homeOption"
                            valueBinding="homeOptionVal"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:table
                        width="100%"
                        name="setOHCred"
                        id="setOHCredID"
			summary="OH Credential Table"
                        partialRenderMode="self"
                        formSubmitted="true"
                        tableDataBinding="setOHCred@stepsData@servletRequest"
                        columnHeaderDataBinding="setOHCredColHeader@stepsData@servletRequest"
                        valueBinding="setOHCredCurrValue@pageData@servletRequest"
                        minValueBinding="setOHCredMinValue@pageData@servletRequest"
                        blockSizeBinding="setOHCredBlockSize@pageData@servletRequest"
                        maxValueBinding="setOHCredMaxValue@pageData@servletRequest">

                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader
                            textBinding="text"
                            sortableBinding="sortable">
                          </uix:sortableHeader>
                        </uix:columnHeaderStamp>

                        <uix:styledText
                          textBinding="stagingDir"
                          shortDescBinding="STAGING_DIR@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="host"
                          shortDescBinding="HOST@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="target"
                          shortDescBinding="TARGET_NAME@patchAdvisorRB">
                        </uix:styledText>

                        <uix:messageTextInput
                          name="usernameOH"
            	          prompt="OH UserName"		
                          noAutoComplete="true"
                          textBinding="usernameOH"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="usernameOHMsgType"
                          messageBinding="usernameOHMsg"/>

                        <uix:messageTextInput
                          name="passwordOH"
                          prompt ="OH Password"
                          noAutoComplete="true"
                          textBinding="passwordOH"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="passwordOHMsgType"
                          messageBinding="passwordOHMsg"
                          secret="true"/>

                        <uix:checkBox
                          name="saveOHCredChkBx"
                          checked="saveOHCredChkBx"/>
                       
  
                        
                      </uix:table>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:case>

                <uix:default>

                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:messageChoice
                        name="homeOptionsList"
                        promptBinding="SPECIFY_FOR@patchAdvisorRB"
                        selectedValueBinding="homeOptionSelVal@stepsData@servletRequest"
                        onChange="submitForm('pageForm', true, {'event':'changeHomeOption'})">
                        <uix:contents
                          childDataBinding="homeOptionsList@pageData@servletRequest">
                          <uix:option
                            textBinding="homeOption"
                            valueBinding="homeOptionVal"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="usernameOH"
                        noAutoComplete="true"
                        promptBinding="USERNAME@patchAdvisorRB"
                        textBinding="usernameOH@stepsData@servletRequest"
                        maximumLength="255"
                        required="uiOnly"
                        messageTypeBinding="usernameOHMsgType@pageData@servletRequest"
                        messageBinding="usernameOHMsg@pageData@servletRequest"/>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:messageTextInput columns="25"
                        name="passwordOH"
                        noAutoComplete="true"
                        promptBinding="PASSWORD@patchAdvisorRB"
                        textBinding="passwordOH@stepsData@servletRequest"
                        maximumLength="255"
                        secret="true"
                        required="uiOnly"
                        messageTypeBinding="passwordOHMsgType@pageData@servletRequest"
                        messageBinding="passwordOHMsg@pageData@servletRequest"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:messageTextInput columns="25"
                        name="cfmPasswordOH"
                        noAutoComplete="true"
                        promptBinding="CONFIRM_PWD@patchAdvisorRB"
                        textBinding="cfmPasswordOH@stepsData@servletRequest"
                        maximumLength="255"
                        secret="true"
                        required="uiOnly"
                        />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:default>
              </uix:switcher>
            </uix:case>

            <uix:default>
              <uix:tableLayout>
                <uix:rowLayout>
                    <uix:table
                        width="100%"
                        name="OHCred"
                        id="OHCredID"
                        partialRenderMode="self"
                        formSubmitted="true"
                        tableDataBinding="OHCred@stepsData@servletRequest"
                        columnHeaderDataBinding="OHCredColHeader@stepsData@servletRequest"
                        valueBinding="OHCredCurrValue@pageData@servletRequest"
                        minValueBinding="OHCredMinValue@pageData@servletRequest"
                        blockSizeBinding="OHCredBlockSize@pageData@servletRequest"
                        maxValueBinding="OHCredMaxValue@pageData@servletRequest">

                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader
                            textBinding="text"
                            sortableBinding="sortable">
                          </uix:sortableHeader>
                        </uix:columnHeaderStamp>


                        <uix:styledText
                          textBinding="oracleHome"
                          shortDescBinding="ORACLE_HOME@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="host"
                          shortDescBinding="HOST@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="target"
                          shortDescBinding="TARGET_NAME@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="usernameOH"
                          shortDescBinding="USERNAME@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="passwordOH"
                          shortDescBinding="PASSWORD@patchAdvisorRB">
                        </uix:styledText>
                          
                          
                          
                       
  
                        
                      </uix:table>

                </uix:rowLayout>
              </uix:tableLayout>
            </uix:default>
          </uix:switcher>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

  </uix:header>







  </uix:dataScope>

</uix:buildTree>



<%@ include file="wizTemplate.jspf" %>

