<!---->
<%--
  - FILE
  -   fileUpload.jspf
  -
  - DESCRIPTION
  -   A page to upload a file (local file or file from s/w library) containing
  -   the patch data.
  -
  - MODIFIED   (MM/DD/YY)
  -   kavkrish  09/26/06   - OAC Fix
  -   svengali  09/12/06   - Add an example upload file
  -   tasingh   02/01/06   - Instead of remote file upload, supoort upload
  -                          from S/W library.
  -   tasingh   01/120/05  - created
    --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonRB"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Target Selector--%>
  <uix:bundle
    name="paRB"
    class="oracle.sysman.pp.pa.ui.rb.PatchAdvisorRB"/>

  <uix:document>

    <%--To help in partial page renderring--%>
    <%@ include file="/enablePPR.jspf" %>

    <%--
      - To display "Oracle Enterprise Manager" followed by
      - UserName on PageTitle. To append page specific string
      - in the title implement getPageHeader() in the
      - CONTROLLER CLASS.
      --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm"
        usesUploadBinding="uploadFromLocalMachineRdBtnStatus@pageBean@servletRequest"
        method="post">

        <uix:pageLayout titleBinding="pageHeader@servletRequest">

          <%--To display GlobalTabs, Buttons, Footer, Copyright etc--%>
          <%@ include file="/oemGlobal.jspf" %>


          <%--The message box to show error/info messge etc--%>
          <uix:messageBox
            messageTypeBinding="msgType@msgInfo@servletRequest"
            messageBinding="msg@msgInfo@servletRequest"
            rendered="false"
            renderedBinding="rendered@msgInfo@servletRequest">
          </uix:messageBox>


          <uix:stackLayout>

            <uix:styledText
              textBinding="UPLOAD_FILE_TEXT@paRB"
              styleClass="oraInstructionText">
            </uix:styledText>

            <uix:spacer height="5"/>

            <uix:rowLayout>
              <uix:messageRadioButton
                id="uploadFromLocalMachineRdBtnID"
                name="uploadFromLocalMachineRdBtn"
                textBinding="UPLOAD_FROM_LOCAL_MACHINE@paRB"
                shortDescBinding="UPLOAD_FROM_LOCAL_MACHINE@paRB"
                selectedBinding="uploadFromLocalMachineRdBtnStatus@pageBean@servletRequest"
                onClick="submitForm('pageForm', true, {'event':'clkLocalMachine'})"/>

              <uix:cellFormat width="5%"/>

              <uix:messageRadioButton
                id="uploadFromSWLibRdBtnID"
                name="uploadFromSWLibRdBtnID"
                textBinding="UPLOAD_FROM_SW_LIB@paRB"
                shortDescBinding="UPLOAD_FROM_SW_LIB@paRB"
                selectedBinding="uploadFromSWLibRdBtnStatus@pageBean@servletRequest"
                onClick="submitForm('pageForm', true, {'event':'clkSWLib'})"/>
            </uix:rowLayout>

            <uix:spacer height="5"/>

            <uix:stackLayout id="uploadFileMechID">
              <uix:switcher childNameBinding="uploadMech@pageBean@servletRequest">
                <uix:case name="SWLib">
                  <uix:stackLayout>
                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                        <uix:messageTextInput
                          name="compName"
                          textBinding="compName@servletRequest"
                          promptBinding="NAME@paRB"
                          shortDescBinding="NAME@paRB">
                        </uix:messageTextInput>

                        <uix:spacer width="5"/>

                        <uix:submitButton
                          textBinding="GO@sdkUIMsg"
                          shortDescBinding="GO@sdkUIMsg"
                          name="event"
                          value="go">
                        </uix:submitButton>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:spacer height="10"/>

                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:spacer width="20"/>

                        <uix:table
                          width="100%"
                          name="compTable"
                          id="compTableID"
                          partialRenderMode="self"
                          summaryBinding="COMPONENTS@patchAdvisorRB"
                          formSubmitted="true"
                          alternateTextBinding="COMP_TABLE_ALT_TEXT@patchAdvisorRB"
                          tableDataBinding="rows@pageBean@servletRequest"
                          valueBinding="currentValue@pageBean@servletRequest"
                          minValueBinding="minValue@pageBean@servletRequest"
                          blockSizeBinding="blockSize@pageBean@servletRequest"
                          maxValueBinding="maxValue@pageBean@servletRequest"
                          columnHeaderDataBinding="columnHeaders@pageBean@servletRequest">

                          <uix:tableSelection>
                            <uix:singleSelection
                              selectedIndex="0"
                              shortDescBinding="SELECT@commonRB"/>
                          </uix:tableSelection>

                          <uix:tableFormat tableBanding="rowBanding"/>

                          <uix:columnHeaderStamp>
                            <uix:sortableHeader
                              textBinding="text"
                              sortableBinding="sortable">
                            </uix:sortableHeader>
                          </uix:columnHeaderStamp>

                          <uix:styledText textBinding="compName"/>
                          <uix:styledText textBinding="type"/>
                          <uix:styledText textBinding="revision"/>
                          <uix:styledText textBinding="status"/>
                          <uix:styledText textBinding="creator"/>
                          <uix:styledText textBinding="createTime"/>
                          <uix:styledText textBinding="description"/>

                        </uix:table>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:stackLayout>
                </uix:case>

                <uix:default>
                  <uix:labeledFieldLayout
                    width="60%"
                    labelWidth="0%"
                    fieldWidth="100%">

                    <uix:messageFileUpload
                      promptBinding="FILE_NAME@paRB"
                      tipBinding="UPLOAD_FILE_INSTR@paRB"
                      name="file"/>
                  </uix:labeledFieldLayout>
                </uix:default>
              </uix:switcher>
            </uix:stackLayout>
          </uix:stackLayout>
   <%--
     <uix:tip >
         <uix:styledText
              textBinding="UPLOAD_FILE_INSTR@paRB"
              styleClass="OraTipText">
         </uix:styledText>
     </uix:tip>
      --%>
          <uix:spacer height="10"/>
          <uix:rowLayout width="100%">
            <uix:contentContainer
                 width="100%"
                 rendered="true"
                 textBinding="UPLOAD_FILE_SAMPLE_TEXT@paRB">
              <uix:tableLayout width="100%" >
                <uix:rowLayout>
                  <uix:styledText 
                       textBinding="UPLOAD_FILE_PATCHID@paRB" 
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="UPLOAD_FILE_PLATFORM_ID@paRB" 
                       styleClass="OraDataText"/>
                  <uix:styledText 
                       textBinding="UPLOAD_FILE_RELEASE@paRB" 
                       styleClass="OraDataText"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText text=" 4516865," styleClass="OraDataText"/>
                  <uix:styledText text=" 46," styleClass="OraDataText"/>
                  <uix:styledText text=" 10.2.0.1" styleClass="OraDataText"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText text=" 4547817," styleClass="OraDataText"/>
                  <uix:styledText text=" 46," styleClass="OraDataText"/>
                  <uix:styledText text=" 10.2.0.2" styleClass="OraDataText"/>
                </uix:rowLayout>
              </uix:tableLayout>

            </uix:contentContainer>
          </uix:rowLayout>

          <%--The cancel, next, back and select Buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="cancel">
              </uix:submitButton>

              <%--Upload Button--%>
              <uix:submitButton
                textBinding="UPLOAD@paRB"
                shortDescBinding="UPLOAD@paRB"
                name="event"
                value="upload">
              </uix:submitButton>

              <uix:submitButton
                textBinding="CONTINUE@paRB"
                shortDescBinding="CONTINUE@paRB"
                rendered="false"
                renderedBinding="showContinueBtn@servletRequest"
                name="event"
                value="continue">
              </uix:submitButton>

            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
