<!---->
<%--
  - FILE
  -  prePost.jsp
  -
  - DESCRIPTION
  -
  -
  - MODIFIED   (MM/DD/YY)
  -  kavkrish   09/26/06   - OAC Fix
  -  aloganda   05/16/06   - Adding GUI components 
  -  tasingh    07/12/05   - Created
  -
  - SINCE
  -  10.2.0.3.0
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <%--Put your page specific contents here--%>
    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="LIBRARY_STEP_TXT@osPatchRB"
          styleClass="oraInstructionText">
        </uix:styledText>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height="10"/>

    <%--to display error message--%>
    <uix:inlineMessage
      messageTypeBinding="msgType@pageData@servletRequest"
      messageBinding="infoMsg@pageData@servletRequest">

      <%--the hGrid--%>
      <uix:hGrid
        id="libPropHGrid"
        partialRenderMode="self"
        alternateTextBinding="MSG_NO_LIB_STEP_PROPS_FOUND@osPatchRB"
        summaryBinding="LIBRARY_STEP_PROPERTIES@osPatchRB"
        treeDataBinding="hGridData@stepsData@servletRequest"
        proxyBinding="hGridProxy@pageData@servletRequest"
        formSubmitted="true">
        <uix:nodeStamp>
          <uix:column>

             <uix:columnHeader>
              <uix:styledText textBinding="LIB_STEP@osPatchRB"/>
            </uix:columnHeader>
            <uix:styledText textBinding="text"/>
          </uix:column>
        </uix:nodeStamp>

        <%--Type col--%>
        <%--Comment out the type and description column
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="TYPE@osPatchRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="type"/>
        </uix:column>
        --%>

        <%--Description col--%>
        <%--
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="DESCRIPTION@osPatchRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="description"/>
        </uix:column>
        --%>

        <%--Property col--%>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="PROP_VALUE@osPatchRB"/>
          </uix:columnHeader>
          <uix:switcher
            childNameBinding="expandable">
            <uix:case name="no">
            <%-- prop value input box is placed inside the tableLayout, so
               - that the input boxes are properly aligned, when erorr message
               - is displayed
               --%>
              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right">
                  <uix:messageTextInput 
                    name="propNodeField" 
                    shortDescBinding="propNodeValue"
                    textBinding="propNodeValue"
                    messageTypeBinding="propNodeFieldMsgType"
                    messageBinding="propNodeFieldMsg">
                  </uix:messageTextInput>
                </uix:rowLayout>
              </uix:tableLayout>
                 
            </uix:case>
            <uix:default>
              <uix:text text=""/>
            </uix:default>
          </uix:switcher>
        </uix:column>
      </uix:hGrid>

    </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
