<%@ page contentType="text/html; charset=UTF-8"%>
<%-- uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%-- Common UI messages --%>
  <uix:bundle name="sdkUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <%-- ResourceBundle for common labels/headers etc--%>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="patchAdvisorRB" class="oracle.sysman.pp.pa.ui.rb.PatchAdvisorRB"/> 
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="prereqDisplayForm" usesUpload="true" method="post">
        <uix:pageLayout titleBinding="CCF_HEADER_TEXT@provCommonRB">
          <uix:contents>
            <uix:hGrid alternateTextBinding="EMPTY_MESSAGE@patchAdvisorRB" 
		       id="prereqHGrid"
                       formSubmitted="false"
                       proxyBinding="hGridProxy@servletRequest"
                       treeDataBinding="prereqData@servletRequest" width="100%">
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="PREREQUISITE_CHECKS@patchAdvisorRB"/>
                  </uix:columnHeader>
                  <uix:columnFormat width="30%" cellNoWrapFormat="true"/>
                  <uix:contents>
                    <uix:styledText textBinding="prereqName"/>
                  </uix:contents>
                </uix:column>
              </uix:nodeStamp>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="DESCRIPTION@patchAdvisorRB"/>
                </uix:columnHeader>
                <uix:columnFormat width="80%" cellNoWrapFormat="false"/>
                <uix:contents>
                  <uix:formattedText textBinding="description"/>
                </uix:contents>
              </uix:column>
            </uix:hGrid>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
