<!---->
<%--
  - FILE
  -  review.jsp
  -
  - DESCRIPTION
  -  The review step of the Patch Advisor Interview Wizard. It displays the
  -  deployment procedure with all the phases/steps/declarations along with
  -  the data the user has specified in the interview steps.
  -
  - MODIFIED   (MM/DD/YY)
  -  summukhe   07/26/07 - 
  -  kavkrish   06/20/07 - Printing the instance name info on the review
  -                        controller
  -  vsubrahm   09/27/06   - 
  -  kavkrish   09/21/06   - ADA changes
  -  rahgupta   05/16/06   - Fix incorrect tags 
  -  tasingh    12/05/05   - Show selected targets. 
  -  spahuja    10/07/05   - enabling credentials review 
  -  tasingh    10/06/05   - Add support to show multiple page segments for
  -                        - the selected software updates.
  -  spahuja    09/08/05   - omitting SelUpdtPage reviews in case not erquired 
  -  tasingh    07/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:header textBinding="ORA_UPDT_COMP@patchAdvisorRB"
      renderedBinding="selUpdtCompPageRendered@stepsData@servletRequest">
      
      <%--Stage Directory--%>
      <uix:rowLayout>
        <uix:styledText
          textBinding="STAGED_LOCATION@patchAdvisorRB"
          styleClass="OraPromptText">
        </uix:styledText>
        <uix:spacer width="5"/>
        <uix:styledText
          textBinding="stageDirLoc@stepsData@servletRequest"
          styleClass="OraDataText">
        </uix:styledText>
      </uix:rowLayout>

    <%
      String refIDs[] = ( String[]) request.getAttribute( "refIDs");
      String hdrTxts[] = ( String[]) request.getAttribute( "hdrTxts");
      String descTxts[] = ( String[]) request.getAttribute( "descTxts");

      String stageApplyTxts[]
        = ( String[]) request.getAttribute( "stageApplyTxts");

      int noOfPageSegments = 0;

      if( refIDs != null)
      {
        noOfPageSegments = refIDs.length;
      }
      for( int i = 0; i < noOfPageSegments; i++)
      {
      %>
      <uix:spacer height="10"/>
      <uix:header text="<%=hdrTxts[i]%>">
      <%--
        - For the time being don't show the following texts.
        -
        <uix:stackLayout>
          <uix:styledText
            text="<%=descTxts[i]%>"
            styleClass="oraInstructionText">
          </uix:styledText>
          <uix:styledText
            text="<%=stageApplyTxts[i]%>"
            styleClass="oraInstructionText">
          </uix:styledText>
          <uix:spacer height="10"/>
        --%>
          <uix:ref refID="<%=refIDs[i]%>"/>
        <uix:separator/>
      </uix:header>
      <%
      }
    %>
    </uix:header>


    <%--Target List--%>
    
    <uix:switcher childNameBinding ="racPage@stepsData@servletRequest">
    <uix:case name="yes">
    	<%@ include file="racTargetReview.jspf" %>
    </uix:case>
    <uix:case name="no">
   
    <uix:header textBinding="TARGET_LIST@patchAdvisorRB">

      <%
        String tgtListRefIDs[] 
          = ( String[]) request.getAttribute( "tgtListRefIDs" );
        String tgtListHdrs[] 
          = ( String[]) request.getAttribute( "tgtListHdrs");

        int noOfPageSegments = 0;

        if( tgtListRefIDs != null)
        {
          noOfPageSegments = tgtListRefIDs.length;
        }
        for( int i = 0; i < noOfPageSegments; i++)
        {
        %>
        <uix:header text="<%=tgtListHdrs[i]%>">
          <uix:ref refID="<%=tgtListRefIDs[i]%>"/>
          <uix:separator/>
        </uix:header>
        <%
        }
      %>
    </uix:header>
    </uix:case>
    </uix:switcher>


    <%--Library Step Parameters--%>
    <uix:header
      renderedBinding="libStepRendered@stepsData@servletRequest"
      textBinding="LIBRARY_STEP_PROPERTIES@patchAdvisorRB">

      <uix:hGrid
        id="libPropHGrid"
        width="500"
        partialRenderMode="self"
        alternateTextBinding="MSG_NO_LIB_STEP_PORPS_FOUND@patchAdvisorRB"
        summaryBinding="LIBRARY_STEP_PORPERTIES@patchAdvisorRB"
        treeDataBinding="hGridData@stepsData@servletRequest"
        proxyBinding="hGridProxy@pageData@servletRequest"
        formSubmitted="true">
        <uix:nodeStamp>
          <uix:column>
            <uix:columnFormat width="70%"/>
            <uix:columnHeader>
              <uix:styledText textBinding="LIB_STEP@patchAdvisorRB"/>
            </uix:columnHeader>
            <uix:styledText textBinding="text"/>
          </uix:column>
        </uix:nodeStamp>

        <%--Property col--%>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="PROP_VALUE@patchAdvisorRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="propNodeValue"/>
        </uix:column>
      </uix:hGrid>
      <uix:spacer height="5"/>
      <uix:separator/>
    </uix:header>

    <uix:header textBinding="CREDENTIALS@patchAdvisorRB">
      <uix:header textBinding="HOST_CREDS@patchAdvisorRB"
          renderedBinding="hostCredRqd@stepsData@servletRequest">
        <uix:switcher childNameBinding="hostCredsType@pageData@servletRequest">

          <uix:case name="prefCreds">
            <uix:rowLayout>
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@patchAdvisorRB"
                styleClass="OraPromptText">
              </uix:styledText>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="hostCredsTypeText@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:rowLayout>
          </uix:case>

          <uix:case name="overrideCreds">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:styledText
                  textBinding="CREDENTIALS_TYPE@patchAdvisorRB"
                  styleClass="OraPromptText">
                </uix:styledText>
                <uix:spacer width="5"/>
                <uix:styledText
                  textBinding="hostCredsTypeText@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:rowLayout>

              <uix:switcher childNameBinding="hostOverridenCredType@pageData@servletRequest">

                <uix:case name="allHosts">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:styledText
                        textBinding="USERNAME@patchAdvisorRB"
                        styleClass="OraPromptText">
                      </uix:styledText>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      textBinding="username@stepsData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:rowLayout>
                </uix:case>

                <uix:case name="eachHost">
                  <uix:table
                    width="500"
                    name="setCred"
                    summary="Overridden preferred credentials"
                    id="setCredID"
                    summaryBinding="OVERRIDDEN_PREF_CREDS_EACH_HOST@patchAdvisorRB"
                    partialRenderMode="self"
                    formSubmitted="true"
                    tableDataBinding="setCred@stepsData@servletRequest"
                    columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                    valueBinding="setCredCurrValue@pageData@servletRequest"
                    minValueBinding="setCredMinValue@pageData@servletRequest"
                    blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                    maxValueBinding="setCredMaxValue@pageData@servletRequest">


                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:sortableHeader
                        textBinding="text"
                        sortableBinding="sortable">
                      </uix:sortableHeader>
                    </uix:columnHeaderStamp>

                    <uix:styledText
                      textBinding="targetName"
                      shortDescBinding="SELECTED_TARGETS@patchAdvisorRB">
                    </uix:styledText>

                    <uix:styledText
                      textBinding="username">
                    </uix:styledText>
                  </uix:table>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>
      </uix:header>

      <uix:header textBinding="HOME_CREDS@patchAdvisorRB"
          renderedBinding="homeCredRqd@stepsData@servletRequest">
        <uix:switcher childNameBinding="homeCredsType@pageData@servletRequest">

          <uix:case name="prefCreds">
            <uix:rowLayout>
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@patchAdvisorRB"
                styleClass="OraPromptText">
              </uix:styledText>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="homeCredsTypeText@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:rowLayout>
          </uix:case>

          <uix:case name="overrideCreds">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:styledText
                  textBinding="CREDENTIALS_TYPE@patchAdvisorRB"
                  styleClass="OraPromptText">
                </uix:styledText>
                <uix:spacer width="5"/>
                <uix:styledText
                  textBinding="homeCredsTypeText@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:rowLayout>

              <uix:switcher childNameBinding="homeOverridenCredType@pageData@servletRequest">

                <uix:case name="allHomes">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:styledText
                        textBinding="USERNAME@patchAdvisorRB"
                        styleClass="OraPromptText">
                      </uix:styledText>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      textBinding="usernameOH@stepsData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:rowLayout>
                </uix:case>

                <uix:case name="eachHome">
                  <uix:table
                    width="500"
                    name="setOHCred"
                    id="setOHCredID"
                    summaryBinding="OVERRIDDEN_PREF_CREDS_EACH_HOST@patchAdvisorRB"
                    summary="Overridden preferred credentials"
                    partialRenderMode="self"
                    formSubmitted="true"
                    tableDataBinding="setOHCred@stepsData@servletRequest"
                    columnHeaderDataBinding="setOHCredColHeader@stepsData@servletRequest"
                    valueBinding="setOHCredCurrValue@pageData@servletRequest"
                    minValueBinding="setOHCredMinValue@pageData@servletRequest"
                    blockSizeBinding="setOHCredBlockSize@pageData@servletRequest"
                    maxValueBinding="setOHCredMaxValue@pageData@servletRequest">


                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:sortableHeader
                        textBinding="text"
                        sortableBinding="sortable">
                      </uix:sortableHeader>
                    </uix:columnHeaderStamp>

                       <uix:styledText
                          textBinding="stagingDir"
                          shortDescBinding="STAGING_DIR@@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="host"
                          shortDescBinding="HOST@@patchAdvisorRB">
                        </uix:styledText>

                        <uix:styledText
                          textBinding="target"
                          shortDescBinding="TARGET_NAME@@patchAdvisorRB">
                        </uix:styledText>
                        <uix:styledText
                          textBinding="usernameOH"
                          shortDescBinding="TARGET_NAME@@patchAdvisorRB">
                        </uix:styledText>

                  </uix:table>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>
      </uix:header>
    </uix:header>

    <uix:header textBinding="SCHEDULE@patchAdvisorRB">
      <uix:tableLayout>
        <uix:rowLayout vAlign="top">
          <uix:styledText
            textBinding="SCHEDULED@patchAdvisorRB"
            styleClass="OraPromptText">
          </uix:styledText>
          <uix:spacer width="5"/>
          <uix:formattedText
            textBinding="scheduleInfo@pageData@servletRequest"
            styleClass="OraDataText">
          </uix:formattedText>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>

  <uix:header textBinding="INSTANCE_NAME@patchAdvisorRB">
      <uix:tableLayout>
        <uix:rowLayout vAlign="top">
          <uix:styledText
            textBinding="INSTANCE_NAME_PROVIDED@patchAdvisorRB"
            styleClass="OraPromptText">
          </uix:styledText>
          <uix:spacer width="5"/>
          <uix:formattedText
            textBinding="instanceName@pageData@servletRequest"
            styleClass="OraDataText">
          </uix:formattedText>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>


     <uix:header textBinding="PREREQUISITE_CHECKS@patchAdvisorRB"
		 renderedBinding="showPrereqLink@pageData@servletRequest">
       <uix:link textBinding="LINK_TO_PREREQS@patchAdvisorRB"
              onClickBinding="prereqLink@pageData@servletRequest"
                          selected="false"/>
     </uix:header>

  </uix:dataScope>

</uix:buildTree>



<%@ include file="wizTemplate.jspf" %>

