<%--
  - FILE
  -  schedule.jsp
  -
  - DESCRIPTION
  -  A step to set the schedule for the jobs.
  -
  - MODIFIED   (MM/DD/YY)
  -  svengali   08/10/07   - Adding additional space before instance name
  -  kavkrish   06/14/07   - Adding a textBox for DP instance name
  -  kavkrish   09/21/06   - ADA changes
  -  vsubrahm   07/15/06   - Add the scheduleText text binding
  -  tasingh    07/27/05   - tasingh_patch_ad_ui
  -  tasingh    07/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="scheduleText@stepsData@servletRequest"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <%--include the schedule jspf--%>
      <uix:ref refID="SCHEDULE_SEGMENT" />

      <uix:spacer height="20"/>

       <%--DP Instance Name--%>
       <uix:messageTextInput
          name="dpInstanceName"
          textBinding="dpInstanceName@stepsData@servletRequest"
          promptBinding="INSTANCE_NAME@patchAdvisorRB"
          shortDescBinding="INSTANCE_NAME@patchAdvisorRB"
          tipBinding="INSTANCE_NAME_TIP_TXT@patchAdvisorRB"
          messageTypeBinding="instanceNameMsgType@pageData@servletRequest"
          messageBinding="instanceNameMsg@pageData@servletRequest">
      </uix:messageTextInput>

    </uix:dataScope>

</uix:buildTree>


<%@ include file="wizTemplate.jspf" %>

