<%--
  - FILE
  -  selUpdComponent.jsp
  -
  - DESCRIPTION
  -  The select update components step of the Patch Advisor Interview wizard.
  -  It captures the software update components.
  -
  - MODIFIED   (MM/DD/YY)
  -  srukumar   08/10/07   - Changing default staging directory
  -  rsah       05/08/07   - Bug 5704923: Change default stage location value.
  -  milshah    10/17/06   - Expand the hideshow for target properties by
  -                          default
  -  kavkrish   10/06/06   - GUI changes for AS DP
  -  kavkrish   09/21/06   - changes for OAC
  -  svengali   08/16/06   - Changing the instructions and tips on the page
  -  kavkrish   06/15/06   - Adding support for AS patching
  -  svengali   06/23/06   - Adding comments for target properties 
  -  tasingh    01/04/06   - ER:4928602 Add a feature to take patches from a 
  -                          file. 
  -  tasingh    07/27/05   - Change the Patch Selection mechanism.
  -  tasingh    07/20/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:stackLayout>
      <uix:styledText
        textBinding="pageText@stepsData@servletRequest"
        styleClass="oraInstructionText">
      </uix:styledText>
      <uix:spacer height="10"/>
    </uix:stackLayout>

    <%--Stage Directory--%>
    <uix:messageTextInput
      name="stageDirLoc"
      text="%emd_root%/EMStage"
      textBinding="stageDirLoc@stepsData@servletRequest"
      promptBinding="STAGED_LOCATION@patchAdvisorRB"
      shortDescBinding="STAGED_LOCATION@patchAdvisorRB"
      tipBinding="STAGED_LOC_TIP_TXT@patchAdvisorRB"
      messageTypeBinding="stageDirMsgType@pageData@servletRequest"
      messageBinding="stageDirMsg@pageData@servletRequest">
    </uix:messageTextInput>

    <%
      String refIDs[] = ( String[]) request.getAttribute( "refIDs");
      String hdrTxts[] = ( String[]) request.getAttribute( "hdrTxts");
      String selectUpdtTips[] = ( String[]) request.getAttribute( "selectUpdtTips");

      int noOfPageSegments = 0;

      if( refIDs != null)
      {
        noOfPageSegments = refIDs.length;
      }
      for( int i = 0; i < noOfPageSegments; i++)
      {
      %>
      <uix:spacer height="10"/>
      <uix:header text="<%=hdrTxts[i]%>">
        <uix:stackLayout>
          <uix:styledText 
            text="<%=selectUpdtTips[i]%>"
            styleClass="oraInstructionText">
          </uix:styledText>
          <uix:ref refID="<%=refIDs[i]%>"/>
        </uix:stackLayout>
        <uix:separator/>
      </uix:header>
      <%
      }
    %>
 
     <uix:spacer height="10"/>
     <uix:tableLayout cellSpacing="10">
       <uix:contents>
         <uix:rowLayout>
         <uix:contents>
             <uix:cellFormat>
               <uix:contents>
                 <spacer width="20"/>
               </uix:contents>
             </uix:cellFormat>
             <uix:cellFormat>
               <uix:contents>
                <uix:hideShow disclosedBinding="hideShowDisclosed@servletRequest" 
		              undisclosedTextBinding="TIP_TARGET_SHOW@patchAdvisorRB"
	                      disclosedTextBinding="TIP_TARGET_HIDE@patchAdvisorRB"
		              id="showHideOfTargetProperties"
	                      formSubmitted="true">
	        <uix:contents>
		<uix:tableLayout cellSpacing="5">
		     <uix:contents>
			<uix:rowLayout>
                            <uix:contents>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     text="%oracle_home%"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     textBinding="ORACLEHOME_DESC@patchAdvisorRB"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                            </uix:contents>
			</uix:rowLayout>
	
          		<uix:rowLayout>
                            <uix:contents>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     text="%emd_root%"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     textBinding="EMDROOT_DESC@patchAdvisorRB"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                            </uix:contents>
			</uix:rowLayout>
          		<uix:rowLayout>
                            <uix:contents>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     text="%perlbin%"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                                 <uix:cellFormat wrappingDisabled="true">
                                     <uix:contents>
                                         <uix:styledText styleClass="OraInstructionText"
                                                     textBinding="PERLBIN_DESC@patchAdvisorRB"/>
                                     </uix:contents>
                                 </uix:cellFormat>
                            </uix:contents>
			</uix:rowLayout>
		     </uix:contents>
		</uix:tableLayout>
                </uix:contents>
                </uix:hideShow>
               </uix:contents>
             </uix:cellFormat>
         </uix:contents>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:contents>
             <uix:cellFormat>
               <uix:contents>
                 <spacer width="20"/>
               </uix:contents>
             </uix:cellFormat>
             <uix:cellFormat>
               <uix:contents>
                    <uix:switcher
                       childNameBinding="isAsPatching@stepsData@servletRequest">
                        <uix:case name="PatchApplicationServer">
                           <uix:stackLayout>               
                             <uix:tip>
                               <uix:contents>
                                  <uix:styledText styleClass="OraTipText"
                                     textBinding="AS_TIP_TARGET_PROPERTIES@patchAdvisorRB"/>
                               </uix:contents>
                            </uix:tip>
                          </uix:stackLayout>
                        </uix:case>
                        <uix:default>
                           <uix:stackLayout>
                              <uix:tip>
                                <uix:contents>
                                   <uix:styledText styleClass="OraTipText"
                                     textBinding="TIP_TARGET_PROPERTIES@patchAdvisorRB"/>
                                </uix:contents>
                             </uix:tip>
                          </uix:stackLayout>
                       </uix:default>   
                      </uix:switcher>
                </uix:contents>
             </uix:cellFormat>
           </uix:contents>
         </uix:rowLayout>
       </uix:contents>
     </uix:tableLayout>
  

  </uix:dataScope> 
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
