<!---->
<%--
  - FILE
  -   softCompSeg.jsp
  -
  - DESCRIPTION
  -   PageSegment to display table for Oracle Software Component selection.
  -
  - MODIFIED   (MM/DD/YY)
  -   vsubrahm  02/27/09 - Fix OAC Violations
  -   vsriram   08/29/07 - Link for OPatch Download Instructions
  -   srukumar  07/30/07 - OPatch Upgrade Option
  -   milshah   10/18/06  - 
  -   mningomb  10/16/06  - Adding a tip for AS DP
  -   kavkrish  09/20/06  - changes for OAC
  -   svengali  08/16/06  - 
  -   nitijain  08/01/06  - Bug 5364072 
  -   svengali  07/17/06  - Add a tip for enter script to apply sql 
  -   rsah      06/09/06  - XbranchMerge rsah_bug-5089693 from 
  -                         st_empp_10.2.0.1.0 
  -   tasingh   02/24/06  - XbranchMerge tasingh_bug-5054725 from 
  -                         st_empp_10.2.0.1.0 
  -   tasingh   03/14/06  - Do not show default sql check box as a check box 
  -                         on the review page. 
  -   tasingh   02/23/06  - Handle pagination problem 
  -   tasingh   01/05/06  - ER:4928602 Provide support to upload patches from
  -                         a file.
  -   tasingh   12/30/05  - ER:4918810 Change popup to an embedded page.
  -   tasingh   12/01/05  - Disabling the provision to add Software Update 
  -                         Component by name. 
  -   tasingh   08/04/05  - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
      name="sdkUIMsg"
      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
      name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
    <uix:bundle
      name="patchAdvisorRB"
      class="oracle.sysman.pp.pa.ui.rb.PatchAdvisorRB"/>

    <uix:document>

      <uix:styledText
        textBinding="STAGE_APPLY_CHK_BX_TXT@patchAdvisorRB"
        renderedBinding="stageApplyChkBoxesTxtRendered@pageSegmentBean@"
        styleClass="oraInstructionText">
      </uix:styledText>
      <uix:inlineMessage
        renderedBinding="stageApplyChkBoxesRendered@pageSegmentBean@"
        messageTypeBinding="msgType@stageApplyErrMsg@pageSegmentBean@"
        messageBinding="msg@stageApplyErrMsg@pageSegmentBean@">
        <uix:tableLayout>
          <uix:rowLayout>
            <uix:messageCheckBox
              nameBinding="stageChkBxName@pageSegmentBean@"
              textBinding="STAGE@patchAdvisorRB"
              checkedBinding="stageChkBxVal@pageSegmentBean@"
              disabledBinding="viewOnlyModeBool@pageSegmentBean@">
            </uix:messageCheckBox>
            <uix:spacer width="5"/>
            <uix:checkBox
              nameBinding="applyChkBxName@pageSegmentBean@"
              textBinding="APPLY@patchAdvisorRB"
              checkedBinding="applyChkBxVal@pageSegmentBean@"
              disabledBinding="viewOnlyModeBool@pageSegmentBean@">
            </uix:checkBox>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:inlineMessage>

      <%-- For the time being disable the provision to add Software Update
           Component by its name. --%>
      <%--<uix:stackLayout 
        renderedBinding="oraUpdtCompInputBoxRendered@pageSegmentBean@"--%>
      <uix:stackLayout 
        rendered="false">
        <uix:messageTextInput
          nameBinding="oraUpdtCompInputBxName@pageSegmentBean@"
          textBinding="oraUpdtCompInputBxTxt@pageSegmentBean@"
          promptBinding="SEARCH_SOFT_UPDT_BY_NAME@patchAdvisorRB"
          shortDescBinding="SEARCH_SOFT_UPDT_BY_NAM@patchAdvisorRB"
          messageTypeBinding="msgType@searchSoftUpdtMsgInfo@pageSegmentBean@"
          messageBinding="msg@searchSoftUpdtMsgInfo@pageSegmentBean@">
          <uix:end>
            <uix:flowLayout>
              <uix:submitButton
                name="event"
                valueBinding="addCompFrmInputBxEventVal@pageSegmentBean@"
                textBinding="ADD@commonResourceBundle">
              </uix:submitButton>
            </uix:flowLayout>
          </uix:end>
        </uix:messageTextInput>
        <uix:spacer height="5"/>
      </uix:stackLayout>
      <%--ER:4928602 Add provision to upload patches from a file. --%>
        <uix:styledText
          textBinding="CONSULT_README_TXT@patchAdvisorRB"
          renderedBinding="addBtnRendered@pageSegmentBean@"
          styleClass="oraInstructionText">
        </uix:styledText>
      <%--End ER:4928602--%>

      <%--oracle software update component table--%>
      <uix:inlineMessage
        renderedBinding="softCompTableRendered@pageSegmentBean@"
        messageTypeBinding="msgType@softUpdtMsgInfo@pageSegmentBean@"
        messageBinding="msg@softUpdtMsgInfo@pageSegmentBean@">
        <%-- This is a hack to get the tableID. Since idBindingis not supported
           - I will get the pageSegmentBean from the pageSegmentContext and
           - get the tableID. The importance of tableID is, it is required for
           - partialPageRenderring. Since a page could use this pageSegment
           - many times, so the table ID should be unique for partial page
           - rendering to work.
           --%>
        <%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
        <%@ page import='oracle.sysman.pp.pa.ui.beans.SoftCompSegBean' %>
        <%
          PageSegmentContext psContext
            = ( PageSegmentContext) request.getAttribute( "pageSegmentContext");

          SoftCompSegBean pageSegBean
            = ( SoftCompSegBean) psContext.getPageSegmentBean( );

          String tableID = pageSegBean.getTableID( );
         %>

         <%-- The following line creats an anchor.--%>
         <uix:link nameBinding="tableName@pageSegmentBean@"/>

        <uix:table
          width="100%"
          nameBinding="tableName@pageSegmentBean@"
          id="<%=tableID%>"
          partialRenderMode="self"
          summaryBinding="SOFT_COMP_TABLE_SUMMARY@patchAdvisorRB"
          summary="Patches"
          formSubmitted="true"
          alternateTextBinding="SOFT_COMP_TABLE_ALT_TEXT@patchAdvisorRB"
          tableDataBinding="rows@pageSegmentBean@"
          valueBinding="currentValue@pageSegmentBean@"
          minValueBinding="minValue@pageSegmentBean@"
          blockSizeBinding="blockSize@pageSegmentBean@"
          maxValueBinding="maxValue@pageSegmentBean@"
          columnHeaderDataBinding="columnHeaders@pageSegmentBean@">

          <%-- ER: 4918810: Change popup to embedded page --%>
          <%--
          <uix:tableActions>
            <uix:button
              renderedBinding="addBtnRendered@pageSegmentBean@"
              onClickBinding="addBtnOnClickStr@pageSegmentBean@"
              textBinding="ADD@commonResourceBundle"/>
          </uix:tableActions>
          --%>
          <uix:tableActions>
            <uix:rowLayout renderedBinding="addBtnRendered@pageSegmentBean@">
              <uix:submitButton
                renderedBinding="addBtnRendered@pageSegmentBean@"
                shortDescBinding="ADD@commonResourceBundle"
                name="event"
                valueBinding="addBtnEvent@pageSegmentBean@"
                textBinding="ADD@commonResourceBundle"/>

              <%--ER:4928602--%>
              <uix:spacer width="5"/>
              <uix:submitButton
                renderedBinding="addBtnRendered@pageSegmentBean@"
                shortDescBinding=
                      "UPLOAD_SOFTWARE_UPDATES_FROM_FILE@patchAdvisorRB"
                name="event"
                valueBinding="uploadFileEventVal@pageSegmentBean@"
                textBinding="UPLOAD_SOFTWARE_UPDATES_FROM_FILE@patchAdvisorRB">
              </uix:submitButton>
            </uix:rowLayout>
            <%--End ER:4928602--%>

          </uix:tableActions>
          <%-- End ER: 4918810--%>

          <uix:tableSelection>
            <uix:multipleSelection
              renderedBinding="mulSelRendered@pageSegmentBean@"
              selectedBinding="rowSelected"
              shortDescBinding="SELECT@commonResourceBundle">

              <uix:submitButton
                name="event"
                valueBinding="remSoftCompEventVal@pageSegmentBean@"
                renderedBinding="remBtnRendered@pageSegmentBean@"
                shortDescBinding="REMOVE@commonResourceBundle"
                textBinding="REMOVE@commonResourceBundle"/>

            </uix:multipleSelection>
          </uix:tableSelection>

          <uix:tableFormat tableBanding="rowBanding"/>

          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"
              sortableBinding="sortable">
            </uix:sortableHeader>
          </uix:columnHeaderStamp>

          <uix:styledText textBinding="compName"/>
          <uix:styledText textBinding="patchID"/>
          <uix:styledText textBinding="createdOn"/>
          <uix:styledText textBinding="type"/>
          <uix:styledText textBinding="product"/>
          <uix:styledText textBinding="platform"/>
          <uix:styledText textBinding="release"/>
          <uix:styledText textBinding="interimPatchAppOn"/>
          <uix:styledText textBinding="description"/>
          <uix:button
             textBinding="README_BTN@patchAdvisorRB"
             rendered="true"
             onClickBinding="readme"
           />
         <uix:image
               source="/em/images/deleteicon_enabled.gif"
               renderedBinding="deleteIconRendered@pageSegmentBean@"
               primaryClientActionBinding="REMOVE_DEST"
               textBinding="Remove"/>
        </uix:table>
            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%" hAlign="right" >
                <uix:button 
                renderedBinding="removeAllBtn@pageSegmentBean@"
                   primaryClientActionBinding="removeAll@servletRequest"
                   textBinding="REMOVE_ALL_BTN_TEXT@patchAdvisorRB"
                      />
              </uix:rowLayout>  
            </uix:tableLayout>



      </uix:inlineMessage>

     <uix:tip renderedBinding="racTipRendered@pageSegmentBean@">
         <uix:styledText
              textBinding="racRollingNonRollingTip@pageSegmentBean@"
              styleClass="OraTipText">
         </uix:styledText>
     </uix:tip>
     <uix:tip rendered="true">
         <uix:styledText
              textBinding="VIEW_READ_ME_TIP@patchAdvisorRB"
              styleClass="OraTipText">
         </uix:styledText>
     </uix:tip>


     <uix:tip renderedBinding="asTipRendered@pageSegmentBean@">
         <uix:styledText
              textBinding="asTip@pageSegmentBean@"
              styleClass="OraTipText">
         </uix:styledText>
     </uix:tip>

      <uix:spacer height="20"/>

      <uix:switcher
        childNameBinding="viewOnlyModeStr@pageSegmentBean@">
      <uix:case name="yes">

          <uix:flowLayout renderedBinding="renderOPatchCheckbox@pageSegmentBean@">
          <uix:contents>
          <uix:header renderedBinding="renderOPatchCheckbox@pageSegmentBean@"
               textBinding="UPGRADE_OPATCH_HDR@patchAdvisorRB"/>
            <uix:styledText
              renderedBinding="enableOPatchUpgrade@pageSegmentBean@"
              textBinding="OPATCH_UPG_ENABLED@patchAdvisorRB"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:styledText
              renderedBinding="negEnableOPatchUpgrade@pageSegmentBean@"
              textBinding="OPATCH_UPG_NOT_ENABLED@patchAdvisorRB"
              styleClass="OraPromptText">
            </uix:styledText>
          </uix:contents>
          </uix:flowLayout>


      </uix:case>
      <uix:default>

          <uix:flowLayout>
          <uix:contents>
          <uix:header renderedBinding="renderOPatchCheckbox@pageSegmentBean@"
               textBinding="UPGRADE_OPATCH_HDR@patchAdvisorRB"/>

          <uix:checkBox
            nameBinding="ENABLE_UPGRADE_OPATCH_BOX@patchAdvisorRB"
            renderedBinding="renderOPatchCheckbox@pageSegmentBean@"
            textBinding="ENABLE_UPGRADE_OPATCH@patchAdvisorRB"
            checkedBinding="enableOPatchUpgrade@pageSegmentBean@"
            disabledBinding="viewOnlyModeBool@pageSegmentBean@"
            name="renderOPatchCheckbox"  >
          </uix:checkBox>

          <uix:rowLayout  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" >
          <uix:styledText  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" textBinding="ENABLE_UPGRADE_OPATCH_TIP@patchAdvisorRB" styleClass="OraTipText" />
          <uix:spacer width="10" />
          <uix:link  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" textBinding="LINK_GRID_AUTOMATION_DP_TEXT@patchAdvisorRB" destinationBinding="LINK_GRID_AUTOMATION_DP@patchAdvisorRB" />
          </uix:rowLayout>
          </uix:contents>
          </uix:flowLayout>

      </uix:default>
     </uix:switcher>

<%--          <uix:header renderedBinding="renderOPatchCheckbox@pageSegmentBean@"
               textBinding="UPGRADE_OPATCH_HDR@patchAdvisorRB"/>

          <uix:checkBox
            nameBinding="ENABLE_UPGRADE_OPATCH_BOX@patchAdvisorRB"
            renderedBinding="renderOPatchCheckbox@pageSegmentBean@"
            textBinding="ENABLE_UPGRADE_OPATCH@patchAdvisorRB"
            checkedBinding="enableOPatchUpgrade@pageSegmentBean@"
            disabledBinding="viewOnlyModeBool@pageSegmentBean@"
            name="renderOPatchCheckbox"  >
          </uix:checkBox>
          <uix:spacer height="5"/>

          <uix:rowLayout  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" >
          <uix:styledText  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" textBinding="ENABLE_UPGRADE_OPATCH_TIP@patchAdvisorRB" styleClass="OraTipText" />
          <uix:link  renderedBinding="renderOPatchCheckbox@pageSegmentBean@" textBinding="LINK_GRID_AUTOMATION_DP_TEXT@patchAdvisorRB" destinationBinding="LINK_GRID_AUTOMATION_DP@patchAdvisorRB" /> 
          </uix:rowLayout> --%>
      <uix:spacer height="10"/>
      <uix:header renderedBinding="sqlStepRendered@pageSegmentBean@"
               textBinding="APPLY_SQL_SCRIPT@patchAdvisorRB"/>


      <uix:switcher
        childNameBinding="viewOnlyModeStr@pageSegmentBean@">
        <uix:case name="yes">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
            <uix:styledText
              renderedBinding="defaultSql@pageSegmentBean@"
              textBinding="APPLY_DEFAULT_SQL@patchAdvisorRB"
              styleClass="OraPromptText">
            </uix:styledText>
          </uix:rowLayout>
        </uix:case>
        <uix:default>
          <uix:tableLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:flowLayout>
          <uix:radioButton name="applyDefaultSql"
               textBinding="APPLY_DEFAULT_SQL@patchAdvisorRB"
               selectedBinding="defaultSql@pageSegmentBean@"
               renderedBinding="sqlStepRendered@pageSegmentBean@"
               value="defsql"/>
          </uix:flowLayout>
        <%--
          <uix:checkBox
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            textBinding="APPLY_DEFAULT_SQL@patchAdvisorRB"
            name="applyDefaultSql"
               selectedBinding="defaultSql@pageSegmentBean@"
            checkedBinding="defaultSql@pageSegmentBean@">
          </uix:checkBox>
        --%>
          </uix:rowLayout>
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
            <uix:styledText textBinding="ENTER_SQL_SCRIPT_TIP@patchAdvisorRB"
               styleClass="OraTipText"/> 
          </uix:rowLayout>
          </uix:tableLayout>
        </uix:default>
      </uix:switcher>

     <uix:spacer height="10"/>

      <uix:switcher
        childNameBinding="viewOnlyModeStr@pageSegmentBean@">
        <uix:case name="yes">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
            <uix:styledText
              renderedBinding="negDefaultSql@pageSegmentBean@"
              textBinding="SQL_SCRIPT_LOCATION@patchAdvisorRB"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:styledText
              renderedBinding="negDefaultSql@pageSegmentBean@"
              textBinding="sqlScriptLoc@pageSegmentBean@"
              styleClass="OraDataText">
            </uix:styledText>
          </uix:rowLayout>
        </uix:case>
        <uix:default>
          <uix:tableLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:flowLayout>
          <uix:contents>
          <uix:radioButton name="applyDefaultSql"
               renderedBinding="sqlStepRendered@pageSegmentBean@"
               textBinding="ENTER_SCRIPT_TO_APPLY_SQL@patchAdvisorRB"
               selectedBinding="negDefaultSql@pageSegmentBean@"
               value="noDefsql"/>

          <uix:textInput
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            name="sqlScriptLoc"
            textBinding="sqlScriptLoc@pageSegmentBean@"
            shortDescBinding="ENTER_SCRIPT_TO_APPLY_SQL@patchAdvisorRB">
          </uix:textInput>
            <uix:styledText textBinding="ENTER_SQL_SCRIPT_EX@patchAdvisorRB"
               styleClass="OraTipText"/> 
          
          </uix:contents>
          </uix:flowLayout>
          </uix:rowLayout>
          </uix:tableLayout>
        </uix:default>
      </uix:switcher>


    </uix:document>
  </uix:dataScope>
</oem:pageSegment>
