<%--
  - FILE
  -  selStagingServer.jsp
  -
  - DESCRIPTION
  -
  -
  - MODIFIED   (MM/DD/YY)
  -  aloganda   07/29/07   - 
  -  tasingh    06/28/07   - Add UI elements
  -  tasingh    06/20/07   - Instead of wizard, just have one page for staging
  -                          server setup
  -  aloganda   05/12/07   - Created
  -
  - SINCE
  -  10.2.0.4.0
  --%>
   
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:dataScope currentDataBinding="pageData@servletRequest">
  		     
	<uix:styledText 
    textBinding="CONTEXTUAL_TXT@ulnRB"
    styleClass="OraInstructionText">
  </uix:styledText>

  <uix:header textBinding="STAGING_SERVER@ulnRB">
    <uix:tableLayout cellSpacing="4" width="100%">
      <uix:rowLayout vAlign="top">
        <uix:cellFormat width = "50%">

          <uix:tableLayout>
            <uix:rowLayout>
              <uix:styledText 
                textBinding="SEL_HOST_INST_TXT@ulnRB"
                styleClass="OraInstructionText">
              </uix:styledText>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>
          
            <uix:rowLayout>
              <uix:messageLovField 
                name="stageServer"
                promptBinding="HOST@commonResourceBundle"
                required="uiOnly"
                shortDescBinding="SEL_HOST_INST_TXT@ulnRB"
                messageTypeBinding="stageServerMsgType@servletRequest"
                messageBinding="stageServerMsg@servletRequest"
                textBinding="stageServer@pageBean@servletRequest"
                onClickBinding="showTgtSel@servletRequest"
                tipBinding="STAGING_SERVER_HOST_TIP@ulnRB">
              </uix:messageLovField>
            </uix:rowLayout>
	    
          </uix:tableLayout>
        </uix:cellFormat>
        
        <uix:cellFormat>
          <uix:contentContainer
            textBinding="CURRENTLY_CONFIGURED@ulnRB"
            background="light"
            width="100%">
            
            <uix:styledText
              textBinding="CURRENTLY_CONFIGURED_DTL_TXT@ulnRB"
              styleClass="OraInstructionText">
            </uix:styledText>

            <uix:spacer height="5"/>

            <uix:table
              width="100%"
              name="stagingServersTable"
              id="stagingServersTableID"
              summaryBinding="CURRENTLY_CONFIGURED_DTL_TXT@ulnRB"
              partialRenderMode="self"
              formSubmitted="true"
              alternateTextBinding="NO_STAGING_SERVER_CONFIGURED@ulnRB"
              tableDataBinding="rows@pageBean@servletRequest"
              valueBinding="currVal@pageBean@servletRequest"
              minValueBinding="minVal@pageBean@servletRequest"
              maxValueBinding="maxVal@pageBean@servletRequest"
              blockSizeBinding="blockSize@pageBean@servletRequest"
              detailDisclosureBinding="detailsState@pageBean@servletRequest"
              allDetailsEnabledBinding="allDetailsEnabled@servletRequest"
              columnHeaderDataBinding="colHeaders@pageBean@servletRequest">
              <uix:tableFormat tableBanding="rowBanding"/>

              <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"/>
              </uix:columnHeaderStamp>

              <uix:styledText textBinding="stagingServer"/>

              <uix:detail>
                <uix:header textBinding="ULN_CHANNELS@ulnRB">
                  <uix:bulletedList>
                    <uix:contents childDataBinding="ulnChannelList">
                      <uix:styledText 
                        textBinding="ulnChannel"
                        styleClass="OraDataText">
                      </uix:styledText>
                    </uix:contents>
                  </uix:bulletedList>
                </uix:header>
              </uix:detail>

            </uix:table>
          </uix:contentContainer>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>

  <uix:header textBinding="CREDENTIALS@osPatchRB">
    <uix:tableLayout cellSpacing="4" >
        <uix:rowLayout>
          <uix:cellFormat width="50%" columnSpan="2">
            <uix:rowLayout>
              <uix:messageRadioButton
                id="usePrefRdBtnID"
                name="usePrefRdBtn"
                shortDescBinding="USE_PREFERRED_CREDENTIALS@osPatchRB"
                selectedBinding="usePrefRdBtn@pageBean@servletRequest"
                primaryClientActionBinding="onChangeUsePrefRdBtn@servletRequest"/>
              <uix:messagePrompt promptBinding="USE_PREFERRED_CREDENTIALS@osPatchRB"/>
            </uix:rowLayout>
          </uix:cellFormat>
          <uix:cellFormat width="50%">
            <uix:rowLayout>
              <uix:messageRadioButton
                name="overridePrefRdBtn"
                id="overridePrefRdBtnID"
                shortDescBinding="OVERRIDE_PREFERRED_CREDENTIALS@osPatchRB"
                selectedBinding="overridePrefRdBtn@pageBean@servletRequest"
                primaryClientActionBinding="onChangeOverridePrefRdBtn@servletRequest"/>
              <uix:messagePrompt promptBinding="OVERRIDE_PREFERRED_CREDENTIALS@osPatchRB"/>
            </uix:rowLayout>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:tableLayout cellSpacing="4" id="overrideCredsID"  width="44%">
        <uix:rowLayout hAlign="left">
          <uix:cellFormat width="3%">
          </uix:cellFormat>

          <uix:cellFormat >
            <uix:switcher childNameBinding="isOverridePrefClkd@pageBean@servletRequest">
              <uix:case name="true">
                <uix:tableLayout cellSpacing="4"  hAlign="right" >
                  <uix:rowLayout hAlign="right">
		   

          <uix:cellFormat columnSpan="2">
                    <uix:messageTextInput columns="20"
                      name="username"
                      textBinding="username@pageBean@servletRequest"
                      promptBinding="USERNAME@osPatchRB"
                      shortDescBinding="USERNAME@osPatchRB"
                      noAutoComplete="true"
                      maximumLength="255"
                      required="uiOnly"
                      messageTypeBinding="usernameMsgType@servletRequest"
                      messageBinding="usernameMsg@servletRequest">
                    </uix:messageTextInput>
		    
		    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="right">
		  

          <uix:cellFormat columnSpan="2">
                    <uix:messageTextInput columns="20"
                      name="password"
                      textBinding="password@pageBean@servletRequest"
                      shortDescBinding="PASSWORD@osPatchRB"
                      promptBinding="PASSWORD@osPatchRB"
                      noAutoComplete="true"
                      maximumLength="255"
                      secret="true"
                      required="uiOnly"
                      messageTypeBinding="passwordMsgType@servletRequest"
                      messageBinding="passwordMsg@servletRequest">
                    </uix:messageTextInput>
		    
		    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="right">
		  

          <uix:cellFormat columnSpan="2">
                    <uix:messageTextInput columns="20"
                      name="cfmPassword"
                      textBinding="cfmPassword@pageBean@servletRequest"
                      shortDescBinding="CFM_PASSWORD@osPatchRB"
                      promptBinding="CFM_PASSWORD@osPatchRB"
                      noAutoComplete="true"
                      maximumLength="255"
                      secret="true"
                      required="uiOnly"
                      messageTypeBinding="cfmPasswordMsgType@servletRequest"
                      messageBinding="cfmPasswordMsg@servletRequest">
                    </uix:messageTextInput>
		    
		    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>

              <uix:default>
                <uix:tableLayout >
                  <uix:rowLayout hAlign="left">
                    <uix:spacer width="10"/>
                    <uix:messageChoice
                      name="prefHostCredType"
                      promptBinding="HOST_CREDENTIALS@osPatchRB"
                      shortDescBinding="HOST_CREDENTIALS_TYPE@osPatchRB"
                      selectedValueBinding="hostCredentialsTypeSelValue@pageBean@servletRequest">
                      <uix:contents
                        childDataBinding="prefHostCredTypeList@servletRequest">
                        <uix:option
                          textBinding="hostCredType"
                          valueBinding="hostCredTypeVal"/>
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:default>
            </uix:switcher>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
  </uix:header>
 </uix:dataScope>
</uix:buildTree>

<%@ include file="template.jspf" %>
