<%@ page contentType="text/html; charset=UTF-8"%>
<%-- uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%-- Common UI messages --%>
  <uix:bundle name="sdkUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <%-- ResourceBundle for common labels/headers etc--%>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="ulnRB" class="oracle.sysman.pp.pa.ulnpatch.rb.ULNResourceBundle"/> 
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="selStageServerForm" method="post">
         <uix:script
          id="ulnScripts" source="/em/pa/ulnpatch/ulnScripts.js"/>
	<uix:contents>
	<uix:pageLayout titleBinding="STAGE_SERVER_SEL@ulnRB">
          
	  <uix:contents>
           		
	   <uix:stackLayout>
	   	<uix:contents>
	   		<uix:rowLayout>
              <uix:styledText 
                textBinding="RUN_THE_UP2DATE_DIRECTIVE_DESCR@ulnRB"
                styleClass="OraInstructionText">
              </uix:styledText>
	     
	    </uix:rowLayout>
	    <uix:rowLayout>
	    	<uix:link textBinding="SWLIB_LOC@ulnRB"
      		destinationBinding="compURL@servletRequest"/> 
	    </uix:rowLayout>

			<uix:header textBinding="STAGE_SERVER_SEARCH@ulnRB">
				<uix:contents>	
					<uix:rowLayout>
                                          <uix:contents>
                                            <uix:messageTextInput name="searchHost" 
                                                              promptBinding="STAGE_SERVER_HOST_NAME@ulnRB" 
                                                              columns="40" 
                                                              textBinding="searchHost@servletRequest"
                                                              shortDescBinding="STAGE_SERVER_HOST_NAME@ulnRB"/>
                                            <uix:submitButton formName="selStageServerForm" textBinding="STAGE_SERVER_GO_BTN@ulnRB" name="event" value="GO" 
					     primaryClientActionBinding="onChangeGoBtn@servletRequest" unvalidated="true"/>
                                             
                                          </uix:contents>
                                        </uix:rowLayout>
				</uix:contents>
	   		</uix:header>
			<uix:header textBinding="STAGE_SERVER_RESULTS">
				<uix:contents>
					<uix:table
            				width="75%"
           				name="selServer"
            				id="selServerID"
            				summaryBinding="STAGE_SERVER_SUMMARY@ulnRB"
            				partialRenderMode="self"
            				formSubmitted="false"
             				alternateTextBinding="STAGE_SERVER_ALT_TEXT@ulnRB"
	     				tableDataBinding="hostDataList@servletRequest"
	    				valueBinding="valBind@servletRequest"
            				minValueBinding="minVal@servletRequest"
                    blockSizeBinding="BlkSize@servletRequest"
                    maxValueBinding="maxVal@servletRequest"
	    				columnHeaderDataBinding="colHeader@servletRequest">	
            
	    				<uix:tableSelection>
              					<uix:singleSelection selectedIndex="0" 
              					shortDescBinding="STAGE_SERVER_SUMMARY@ulnRB">
              					</uix:singleSelection>
	    				</uix:tableSelection>
					
					<uix:tableFormat tableBanding="rowBanding"/>
           					<uix:columnHeaderStamp>
              						<uix:sortableHeader
                					textBinding="text"
                					sortableBinding="sortable">
             						</uix:sortableHeader>
            					</uix:columnHeaderStamp>
              					<uix:styledText 
                					textBinding="hostName">
              					</uix:styledText>
	    					<uix:styledText 
                					textBinding="emdURL">
              					</uix:styledText>
          					<uix:formValue name="emdURL" valueBinding="emdURL"/>
                                            <uix:formValue name="hostName" valueBinding="hostName"/>
          				</uix:table>
				</uix:contents>
	   		</uix:header>
	   	</uix:contents>
		
	   </uix:stackLayout>	
          
          </uix:contents>
	  <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:contents>
                    <uix:button textBinding="STAGE_SERVER_CANCEL_BTN@ulnRB" 
                            onClick="top.close();" />
                    <uix:button textBinding="STAGE_SERVER_SEL_BTN@ulnRB" 
                            onClick="mySelect();"  />
	
                  </uix:contents>                 
                </uix:pageButtonBar>
              </uix:contentFooter>
        </uix:pageLayout>
	</uix:contents>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
