<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.  
 *
 * Page to deploy PAR file.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_upload_tool_ui from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_upload_tool_ui from main 
 *  ktamtoro  12/13/05 - Created
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_ADMIN_PAR_DEPLOY_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="/paf/pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:styledText textBinding="PA_ADMIN_PAR_DEPLOY_MSG@paResourceBundle"
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="swlibPathNotFoundRendered@servletRequest">
        <uix:spacer height="10" width="10"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="swlibPathNotFoundRendered@servletRequest">
        <uix:styledText textBinding="PA_SWLIB_PATH_MSG@paResourceBundle"
                        styleClass="OraErrorText "/>
        <uix:link textBinding="PA_SWLIB_ADMIN_PAGE_MSG@paResourceBundle"
                  styleClass="OraErrorText "
                  destinationBinding="adminPageLink@servletRequest"/>
<%--
                  targetFrame="_blank"/>
--%>
        <uix:styledText textBinding="PA_SWLIB_PATH_2_MSG@paResourceBundle"
                        styleClass="OraErrorText "/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="25" width="25"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:messageComponentLayout fieldWidth="100%">
          <uix:contents>
            <%-- PAR filename --%>
            <uix:messageLayout promptBinding="PA_ADMIN_PAR_FILENAME_PROMPT@paResourceBundle">
              <uix:contents>
                <uix:rowLayout width="100%">
                  <uix:cellFormat>
                    <uix:styledText textBinding="filename@parFileBean@servletRequest"
                                    styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:messageLayout>
            <%-- PAR name --%>
            <uix:messageLayout promptBinding="PA_ADMIN_PAR_NAME_PROMPT@paResourceBundle"
                               renderedBinding="displayNameRendered@parFileBean@servletRequest">
              <uix:contents>
                <uix:rowLayout width="100%">
                  <uix:cellFormat>
                    <uix:styledText textBinding="translatedDisplayName@parFileBean@servletRequest"
                                    styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:messageLayout>
            <%-- PAR description --%>
            <uix:messageLayout promptBinding="PA_ADMIN_PAR_DESC_PROMPT@paResourceBundle"
                               renderedBinding="descriptionRendered@parFileBean@servletRequest">
              <uix:contents>
                <uix:rowLayout width="100%">
                  <uix:cellFormat>
                    <uix:styledText textBinding="translatedDescription@parFileBean@servletRequest"
                                    styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:messageLayout>
            <%-- Force upload checkbox
            <uix:messageLayout promptBinding="PA_ADMIN_FORCE_UPLOAD_PROMPT@paResourceBundle"
                               renderedBinding="hasConflict@parFileBean@servletRequest">
              <uix:contents>
                <uix:rowLayout width="100%">
                  <uix:cellFormat>
                    <uix:checkBox nameBinding="PA_ADMIN_FORCE_UPLOAD_CHECK@paResourceBundle"
                                  checkedBinding="forceUpload@parFileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:messageLayout>
            --%>
          </uix:contents>
        </uix:messageComponentLayout>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="10" width="10"/>
      </uix:rowLayout>
      <uix:rowLayout width="100%">
        <uix:hGrid alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                   id="parHGrid"
                   formSubmitted="true"
                   partialRenderMode="self"
                   proxyBinding="proxy@proxyBean@servletRequest"
                   treeDataBinding="treeData@parFileBean@servletRequest"
                   renderedBinding="treeRendered@parFileBean@servletRequest"
                   width="100%">
          <%-- hGrid columns --%>
          <uix:nodeStamp>
            <%-- name column --%>
            <uix:column renderedBinding="nameColumnRendered@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_PAR_NAME_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="10%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:styledText textBinding="name"
                                styleClassBinding="style"/>
              </uix:contents>
            </uix:column>
          </uix:nodeStamp>
          <uix:contents>
            <%-- display name
           	<uix:column renderedBinding="displayNameColumnRendered@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_PAR_DISPLAY_NAME_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="20%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:styledText textBinding="displayName"
                                styleClassBinding="style"/>
              </uix:contents>
            </uix:column>
            --%>
            <%-- description --%>
            <uix:column renderedBinding="descriptionColumnRendered@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_PAR_DESCRIPTION_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="1" cellNoWrapFormat="false"/>
              <uix:contents>
                <uix:styledText textBinding="description"
                                styleClassBinding="style"/>
              </uix:contents>
            </uix:column>
            <%-- type --%>
            <uix:column renderedBinding="typeRendered@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_TYPE_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="10%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:styledText textBinding="type"
                                styleClassBinding="style"/>
              </uix:contents>
            </uix:column>
            <%-- component directory --%>
            <uix:column renderedBinding="swlibInfoRendered@parFileBean@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_SWLIB_DIRECTORY_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="10%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:styledText textBinding="directory"
                                styleClassBinding="style"/>
              </uix:contents>
            </uix:column>
            <%-- entity filename --%>
           	<uix:column renderedBinding="displayNameColumnRendered@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_PAR_FILENAME_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="20%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:styledText textBinding="entityFile"
                                styleClassBinding="entityFileStyle"/>
              </uix:contents>
            </uix:column>
          </uix:contents>
          <uix:end>
         </uix:end>
        </uix:hGrid>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="hasConflict@parFileBean@servletRequest">
        <uix:tip>
          <uix:contents>
            <uix:styledText textBinding="PA_ADMIN_CONFLICT_MSG@paResourceBundle"/>
          </uix:contents>
        </uix:tip>
 </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="/paf/templateBase.jspf" %>
