<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.
 *
 * Page to install new procedures using PAR file.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  07/25/07 - For uploading from agent machine
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main
 *  ktamtoro  12/08/05 - Created
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_ADMIN_PROC_INSTALL_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="/paf/pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:styledText textBinding="PA_ADMIN_PROC_INSTALL_MSG@paResourceBundle"
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="swlibPathNotFoundRendered@servletRequest">
        <uix:spacer height="10" width="10"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="swlibPathNotFoundRendered@servletRequest">
        <uix:styledText textBinding="PA_ADMIN_SWLIB_WARNING_MSG@paResourceBundle"
                        styleClass="OraInstructionTextStrong"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="25" width="25"/>
      </uix:rowLayout>
      <uix:rowLayout>

        <uix:stackLayout>
          <uix:contents>

            <uix:radioButton nameBinding="PA_ADMIN_UPLOAD_CRITERIA_RADIO_BTN@paResourceBundle"
                             textBinding="PA_UPLOAD_LOCAL_MACHINE@paResourceBundle"
                             selectedBinding="localUploadSectionRendered@servletRequest"
                             value="localMachine"
                             onClick="handleUploadMechanism('localMachine')"/>

            <uix:spacer height="10"
                        width="10"
                        renderedBinding="localUploadSectionRendered@servletRequest"/>

            <uix:labeledFieldLayout width="40%"
                                    renderedBinding="localUploadSectionRendered@servletRequest">
              <uix:messageFileUpload nameBinding="PA_ADMIN_PAR_FILE_UPLOAD_INPUT@paResourceBundle"
                                     promptBinding="PA_ADMIN_PAR_FILE_UPLOAD_INPUT_PROMPT@paResourceBundle"
                                     required="yes">
              </uix:messageFileUpload>
              <uix:spacer height="1" width="10"/>
              <uix:submitButton textBinding="PA_ADMIN_UPLOAD_BTN@paResourceBundle"
                                name="event"
                                valueBinding="PA_ADMIN_UPLOAD@paResourceBundle"
                                renderedBinding="uploadBtnRendered@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:spacer height="15"
                        width="10"
                        renderedBinding="localUploadSectionRendered@servletRequest"/>

            <uix:radioButton nameBinding="PA_ADMIN_UPLOAD_CRITERIA_RADIO_BTN@paResourceBundle"
                             textBinding="PA_UPLOAD_AGENT_MACHINE@paResourceBundle"
                             selectedBinding="remoteUploadSectionRendered@servletRequest"
                             value="remoteMachine"
                             onClick="handleUploadMechanism('remoteMachine')"/>

            <uix:spacer height="10" width="10"/>

            <uix:labeledFieldLayout width="40%"
                                    renderedBinding="remoteUploadSectionRendered@servletRequest">
              <uix:messageTextInput nameBinding="PA_ADMIN_TARGET_NAME_INPUT@paResourceBundle"
                                    textBinding="targetNameValue@servletRequest"
                                    renderedBinding="remoteUploadSectionRendered@servletRequest"
                                    promptBinding="PA_HOST_TARGET_INPUT_PROMPT@paResourceBundle"
                                    required="yes">
                <uix:end>
                  <oem:targetSelection textBinding="PA_ADD_TARGET_BTN@paResourceBundle"
                                       event="initializeTargetSelection:targetNameValue"/>
                </uix:end>
              </uix:messageTextInput>
              <uix:messageTextInput nameBinding="PA_ADMIN_SOURCE_FILENAME_INPUT@paResourceBundle"
                                    promptBinding="PA_FILENAME_INPUT_PROMPT@paResourceBundle"
                                    renderedBinding="remoteUploadSectionRendered@servletRequest"
                                    textBinding="fileNameValue@servletRequest"
                                    required="yes">
                <uix:end>
                <uix:button textBinding="PA_SELECT_FILE@paResourceBundle"
                            onClick="launchRfs(\"handleRfsLaunch\");"/>
                </uix:end>
              </uix:messageTextInput>
              <uix:spacer height="1" width="10"/>
              <uix:submitButton textBinding="PA_ADMIN_UPLOAD_BTN@paResourceBundle"
                                name="event"
                                valueBinding="PA_ADMIN_UPLOAD@paResourceBundle"
                                renderedBinding="uploadBtnRendered@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:tip textBinding="PA_ADMIN_PREFERRED_CREDENTIALS_WARNING_MSG@paResourceBundle"
                     renderedBinding="remoteUploadSectionRendered@servletRequest"/>
            <uix:spacer height="10" width="10"/>

          </uix:contents>
          <script>
            function myCallBack(lovWindow, event)
            {
              return true;
            }

            function launchRfs(obj)
            {
              openWindow(top, '../../page/rfs/postBackWithEvent$event='+obj, 'lovWindow', {width:750, height:550}, true, 'dialog',
              myCallBack);
            }

            function handleUploadMechanism(obj)
            {
              formObj = document.forms[0];
              var url = formObj.action+"?event=toggleUploadMechanism&uploadMechanism="+obj;
              window.location.href = url;
            }
          </script>
        </uix:stackLayout>

      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="/paf/templateBase.jspf" %>
