<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.  
 *
 * Page to configure Provisioning Daemon.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_paf_ui_fixes_2 from main 
 *  ktamtoro  12/08/05 - Created
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_ADMIN_PROV_DAEMON_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout>
        <uix:styledText textBinding="PA_ADMIN_PROV_DAEMON_MSG@paResourceBundle"
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer height="20" width="20"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:messageComponentLayout>
          <uix:contents>
            <uix:messageLayout promptBinding="PA_ADMIN_DAEMON_STATUS_PROMPT@paResourceBundle">
              <uix:contents>
                <uix:styledText textBinding="(daemonStatus@servletRequest)@paResourceBundle"
                                styleClass="OraDataText"/>
              </uix:contents>
            </uix:messageLayout>
            <uix:messageLayout prompt="">
              <uix:contents>
                <uix:spacer height="5"/>
              </uix:contents>
            </uix:messageLayout>
            <uix:messageLayout promptBinding="PA_ADMIN_DAEMON_INTERVAL_CHOICE_PROMPT@paResourceBundle">
              <uix:contents>
                <uix:choice nameBinding="PA_ADMIN_DAEMON_INTERVAL_CHOICE@paResourceBundle"
                            selectedValueBinding="selectedInterval@servletRequest">
                  <uix:contents childDataBinding="intervals@servletRequest">
                    <uix:option textBinding="text"
                                valueBinding="value"/>
                  </uix:contents>
                </uix:choice>
              </uix:contents>
            </uix:messageLayout>
            <uix:messageLayout prompt="">
              <uix:contents>
                <uix:spacer height="10"/>
              </uix:contents>
            </uix:messageLayout>
            <uix:messageLayout prompt="">
              <uix:contents>
            <uix:submitButton textBinding="PA_ADMIN_START_DAEMON_BTN@paResourceBundle"
                              name="event"
                              valueBinding="PA_ADMIN_START_DAEMON@paResourceBundle"
                              renderedBinding="startBtnRendered@servletRequest"
                              disabledBinding="startBtnDisabled@servletRequest"/>
            <uix:submitButton textBinding="PA_ADMIN_STOP_DAEMON_BTN@paResourceBundle"
                              name="event"
                              valueBinding="PA_ADMIN_STOP_DAEMON@paResourceBundle"
                              renderedBinding="stopBtnRendered@servletRequest"
                              disabledBinding="stopBtnDisabled@servletRequest"/>
            <uix:submitButton textBinding="PA_ADMIN_RESTART_DAEMON_BTN@paResourceBundle"
                              name="event"
                              valueBinding="PA_ADMIN_RESTART_DAEMON@paResourceBundle"
                              renderedBinding="restartBtnRendered@servletRequest"
                              disabledBinding="restartBtnDisabled@servletRequest"/>
              </uix:contents>
            </uix:messageLayout>
          </uix:contents>
        </uix:messageComponentLayout>
      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="/paf/templateBase.jspf" %>
