<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.
 *
 * Table to display search criteria and a selectable list of components in the creation page.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%-- Search criteria --%>
<uix:rowLayout width="100%">
	<uix:cellFormat width="100%">
		<uix:contents>
			<uix:labeledFieldLayout width="60%" columns="2">
				<uix:contents>
					<%-- Reference Name --%>
					<uix:messageTextInput nameBinding="PA_REF_NAME_INPUT@paResourceBundle"
																promptBinding="PA_REF_NAME_INPUT_PROMPT@paResourceBundle"
																textBinding="referenceName@componentsTable@servletRequest"
																id="referenceNameInput"/>
					<%-- Revision --%>
					<uix:messageChoice nameBinding="PA_REVISION_CHOICE@paResourceBundle"
														 promptBinding="PA_REVISION_CHOICE_PROMPT@paResourceBundle"
														 selectedValueBinding="revision@componentsTable@servletRequest"
														 id="revisionChoice">
						<uix:contents childDataBinding="revisionOptions@servletRequest">
							<uix:option textBinding="(text)@paResourceBundle"
													valueBinding="optionKey"/>
						</uix:contents>
					</uix:messageChoice>
					<%-- Subtype --%>
					<uix:messageChoice nameBinding="PA_COMP_SUBTYPE_CHOICE@paResourceBundle"
														 promptBinding="PA_COMP_SUBTYPE_CHOICE_PROMPT@paResourceBundle"
														 selectedValueBinding="subType@componentsTable@servletRequest"
														 readOnlyBinding="subTypeChoiceReadOnly@servletRequest"
														 vAlign="middle"
														 renderedBinding="subTypeRendered@servletRequest"
														 id="compSubTypeChoice">
						<uix:contents childDataBinding="subTypeOptions@servletRequest">
							<uix:option textBinding="text"
													valueBinding="optionKey"/>
						</uix:contents>
					</uix:messageChoice>
					<%-- Filename --%>
					<uix:messageTextInput nameBinding="PA_FILENAME_INPUT@paResourceBundle"
																promptBinding="PA_FILENAME_INPUT_PROMPT@paResourceBundle"
																textBinding="filename@componentsTable@servletRequest"
																id="filename"/>
					<%-- Maturity --%>
					<uix:messageChoice nameBinding="PA_MATURITY_CHOICE@paResourceBundle"
														 promptBinding="PA_MATURITY_CHOICE_PROMPT@paResourceBundle"
														 selectedValueBinding="maturity@componentsTable@servletRequest"
														 id="maturityChoice">
						<uix:contents childDataBinding="maturityOptions@servletRequest">
							<uix:option textBinding="text"
													valueBinding="optionKey"/>
						</uix:contents>
					</uix:messageChoice>
					<%-- Status --%>
					<uix:messageChoice nameBinding="PA_COMP_STATUS_CHOICE@paResourceBundle"
														 promptBinding="PA_COMP_STATUS_CHOICE_PROMPT@paResourceBundle"
														 selectedValueBinding="status@componentsTable@servletRequest"
														 id="compStatusChoice">
						<uix:contents childDataBinding="statusOptions@servletRequest">
							<uix:option textBinding="text"
													valueBinding="optionKey"/>
						</uix:contents>
					</uix:messageChoice>
					<%-- Author --%>
					<uix:messageTextInput nameBinding="PA_AUTHOR_INPUT@paResourceBundle"
																promptBinding="PA_AUTHOR_INPUT_PROMPT@paResourceBundle"
																textBinding="author@servletRequest"
																id="authorInput"/>
					<%-- Product Name --%>
					<uix:messageTextInput nameBinding="PA_PRODUCT_NAME_INPUT@paResourceBundle"
																promptBinding="PA_PRODUCT_NAME_INPUT_PROMPT@paResourceBundle"
																textBinding="productName@componentsTable@servletRequest"
																id="productNameInput"/>
				</uix:contents>
			</uix:labeledFieldLayout>
		</uix:contents>
	</uix:cellFormat>
</uix:rowLayout>
<uix:rowLayout width="18%">
	<uix:contents>
		<uix:cellFormat hAlign="right">
			<uix:contents>
				<%-- Search button --%>
				<uix:submitButton textBinding="PA_SEARCH_BTN@paResourceBundle"
													name="event"
													rendered="true"
													valueBinding="PA_COMPONENT_SEARCH@paResourceBundle"/>
				<uix:spacer height="10" width="10"/>
			</uix:contents>
		</uix:cellFormat>
	</uix:contents>
</uix:rowLayout>
<uix:rowLayout>
	<uix:contents>
		<uix:spacer height="10" width="10"/>
	</uix:contents>
</uix:rowLayout>

<%-- The actual table --%>
<uix:rowLayout width="100%">
	<uix:cellFormat width="100%">
		<uix:contents>
			<%-- TODO: value needs to be specified for blockSize, minValue, and maxValue to matter --%>
			<uix:table id="componentsTable"
			           nameBinding="PA_COMPONENTS_TABLE@paResourceBundle"
								 alternateTextBinding="PA_COMPONENT_TABLE_NO_ITEMS_FOUND@paResourceBundle"
								 tableDataBinding="value@translatedDisplayedTableData@componentsTable@servletRequest"
                 blockSizeBinding="blockSize@componentsTable@servletRequest"
                 maxValueBinding="maxValue@componentsTable@servletRequest"
                 minValueBinding="minValue@componentsTable@servletRequest"
                 valueBinding="currentValue@componentsTable@servletRequest"
                 partialRenderMode="self"
                 formSubmitted="true"
								 width="100%">
				<uix:contents>
					<%@ include file="componentsTableColumns.jspf" %>
				</uix:contents>
				<uix:tableSelection>
					<uix:singleSelection selectedIndexBinding="selectedIndexInDisplayedRowsInteger@componentsTable@servletRequest"/>
				</uix:tableSelection>
			</uix:table>
		</uix:contents>
	</uix:cellFormat>
</uix:rowLayout>
