<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.  
 *
 * First create page: select the type for the deployment procedure step or phase.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <%-- General Information about the step/phase --%>
  <uix:labeledFieldLayout width="60%">
    <uix:contents>
      <%-- Step or Phase --%>
      <uix:messageChoice nameBinding="PA_STEP_PHASE_CHOICE@paResourceBundle"
                         promptBinding="PA_STEP_PHASE_CHOICE_PROMPT@paResourceBundle"
                         selectedValueBinding="type@currentStep@trainBean@servletRequest"
                         readOnlyBinding="typeChoiceReadOnly@trainBean@servletRequest"
                         onChange="submitForm('pafForm', false, {'event':'typeChange'})">
        <uix:contents>
          <uix:option textBinding="PA_PHASE_OPTION@paResourceBundle"
                      valueBinding="PA_PHASE_OPTION_VALUE@paResourceBundle"/>
          <uix:option textBinding="PA_STEP_OPTION@paResourceBundle"
                      valueBinding="PA_STEP_OPTION_VALUE@paResourceBundle"/>
          <uix:option textBinding="PA_GROUP_OPTION@paResourceBundle"
                      valueBinding="PA_GROUP_OPTION_VALUE@paResourceBundle"
                      renderedBinding="groupOptionRendered@servletRequest"/>
        </uix:contents>
      </uix:messageChoice>
      <uix:spacer height="10" width="10"/>
      <%-- Name --%>
      <uix:messageTextInput nameBinding="PA_PROC_NAME_INPUT@paResourceBundle"
                            promptBinding="PA_PROC_NAME_PROMPT@paResourceBundle"
                            maximumLength="128"
                            required="yes"
                            textBinding="translatedName@currentStep@trainBean@servletRequest"
                            readOnlyBinding="nameInputReadOnly@servletRequest"
                            id="nameInput"/>
      <uix:spacer height="10" width="10"/>
      <%-- Description --%>
      <uix:messageTextInput nameBinding="PA_DESCRIPTION_INPUT@paResourceBundle"
                            promptBinding="PA_DESCRIPTION_PROMPT@paResourceBundle"
                            rows="5"
                            maximumLength="400"
                            textBinding="translatedDescription@currentStep@trainBean@servletRequest"
                            readOnlyBinding="descInputReadOnly@servletRequest"
                            id="descInput"/>
      <uix:spacer height="10" width="10"/>
      <%-- Insertion place --%>
      <uix:messageChoice nameBinding="PA_INSERT_PLACE_CHOICE@paResourceBundle"
                         promptBinding="PA_INSERT_PLACE_CHOICE_PROMPT@paResourceBundle"
                         selectedValueBinding="positionToInsertString@trainBean@servletRequest"
                         readOnlyBinding="insertPlaceChoiceReadOnly@servletRequest"
                         renderedBinding="renderInsertPlace@trainBean@servletRequest"
                         tipBinding="(insertPlaceChoiceTipTextKey@trainBean@servletRequest)@paResourceBundle"
                         onChange="submitForm('pafForm', false, {'event':'insertPlaceChange'})">
        <uix:contents childDataBinding="insertPlaceOptions@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
      <uix:spacer height="10" width="10"/>
      <%-- Type of step/phase --%>
      <uix:messageChoice nameBinding="PA_TYPE_CHOICE@paResourceBundle"
                         promptBinding="PA_TYPE_CHOICE_PROMPT@paResourceBundle"
                         selectedValueBinding="stepType@currentStep@trainBean@servletRequest"
                         readOnlyBinding="stepTypeChoiceReadOnly@trainBean@servletRequest"
                         onChange="submitForm('pafForm', false, {'event':'stepPhaseChoiceChange'})"
                         renderedBinding="stepTypeRendered@currentStep@trainBean@servletRequest"
                         tipBinding="(typeChoiceTipTextKey@trainBean@servletRequest)@paResourceBundle">
        <uix:contents childDataBinding="choiceTypes@servletRequest">
          <uix:option textBinding="(textKey)@paResourceBundle"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
      <uix:spacer height="10" width="10"/>
      <%-- Error Handling --%>
      <uix:messageChoice nameBinding="PA_ERROR_HANDLING_CHOICE@paResourceBundle"
                         promptBinding="PA_ERROR_HANDLING_CHOICE_PROMPT@paResourceBundle"
                         selectedValueBinding="errorMode@currentStep@trainBean@servletRequest"
                         renderedBinding="errorModeRendered@servletRequest"
                         readOnlyBinding="errorHandlingChoiceReadOnly@servletRequest">
        <uix:contents childDataBinding="errorHandlingChoices@servletRequest">
          <uix:option textBinding="(textKey)@paResourceBundle"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
      <uix:spacer height="10" width="10"/>
    </uix:contents>
  </uix:labeledFieldLayout>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>
