<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.
 *
 * Creation page: select a generic component from the software library.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:rowLayout width="100%"
                 renderedBinding="isComponentURNExpression@currentStep@trainBean@servletRequest">
    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:messageRadioButton nameBinding="PA_RETAIN_COMP_RADIO_BTN@paResourceBundle"
                                  textBinding="PA_RETAIN_COMP_RADIO_OPTION@paResourceBundle"
                                  selectedBinding="retainComponent@currentStep@trainBean@servletRequest"
                                  onClick="submitForm('pafForm', true, {'event':'selRetainCompOption'})"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:messageRadioButton nameBinding="PA_SELECT_NEW_COMP_RADIO_BTN@paResourceBundle"
                                  textBinding="PA_SELECT_NEW_COMP_RADIO_OPTION@paResourceBundle"
                                  selectedBinding="selectNewComponent@currentStep@trainBean@servletRequest"
                                  onClick="submitForm('pafForm', true, {'event':'selSelectNewCompOption'})"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:rowLayout>
  <uix:spacer width="10" height="10"/>
  <uix:rowLayout width="100%"
                 renderedBinding="isComponentURNExpression@currentStep@trainBean@servletRequest">
    <uix:messageLayout promptBinding="PA_CURRENT_COMPONENT_PROMPT@paResourceBundle"
                       renderedBinding="retainComponent@currentStep@trainBean@servletRequest">
      <uix:contents>
        <uix:rowLayout width="100%">
          <uix:cellFormat>
            <uix:styledText textBinding="componentURNToDisplay@currentStep@trainBean@servletRequest"
                            styleClass="OraDataText"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:contents>
    </uix:messageLayout>
  </uix:rowLayout>
  <uix:header textBinding="PA_CHOOSE_COMPONENT_HDR@paResourceBundle"
              renderedBinding="selectNewComponent@currentStep@trainBean@servletRequest">
    <uix:contents>
      <uix:include node="componentsTable.jsp"/>
      <uix:spacer width="10" height="10"/>
      <uix:messageComponentLayout columns="1"
                                  fieldWidth="100%">
        <uix:contents>
          <%-- Always use latest revision --%>
          <uix:messageLayout promptBinding="PA_ALWAYS_USE_LATEST_REVISION_PROMPT@paResourceBundle"
                             tipBinding="PA_CREATE_COMPONENT_USE_LATEST_REVISION_INFO_MSG@paResourceBundle"
                             renderedBinding="selectNewComponent@currentStep@trainBean@servletRequest">
            <uix:checkBox nameBinding="PA_ALWAYS_USE_LATEST_REVISION_CHECK@paResourceBundle"
                          checkedBinding="componentAlwaysUseLatestRevision@currentStep@trainBean@servletRequest"/>
          </uix:messageLayout>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>
