<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.
 *
 * Creation page: select a directive from the software library.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:rowLayout width="100%"
                 renderedBinding="isDirectiveURNExpression@currentStep@trainBean@servletRequest">
    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:messageRadioButton nameBinding="PA_RETAIN_COMP_RADIO_BTN@paResourceBundle"
                                  textBinding="PA_RETAIN_COMP_RADIO_OPTION@paResourceBundle"
                                  selectedBinding="retainDirective@currentStep@trainBean@servletRequest"
                                  onClick="submitForm('pafForm', true, {'event':'selRetainCompOption'})"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:messageRadioButton nameBinding="PA_SELECT_NEW_COMP_RADIO_BTN@paResourceBundle"
                                  textBinding="PA_SELECT_NEW_DIR_RADIO_OPTION@paResourceBundle"
                                  selectedBinding="selectNewDirective@currentStep@trainBean@servletRequest"
                                  onClick="submitForm('pafForm', true, {'event':'selSelectNewCompOption'})"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:rowLayout>
  <uix:spacer width="10" height="10"/>
  <uix:rowLayout width="100%"
                 renderedBinding="isDirectiveURNExpression@currentStep@trainBean@servletRequest">
    <uix:messageLayout promptBinding="PA_CURRENT_DIRECTIVE_PROMPT@paResourceBundle"
                       renderedBinding="retainDirective@currentStep@trainBean@servletRequest">
      <uix:contents>
        <uix:rowLayout width="100%">
          <uix:cellFormat>
            <uix:styledText textBinding="directiveURNToDisplay@currentStep@trainBean@servletRequest"
                            styleClass="OraDataText"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:contents>
    </uix:messageLayout>
  </uix:rowLayout>
  <uix:header textBinding="PA_CHOOSE_DIRECTIVE_HDR@paResourceBundle"
              renderedBinding="selectNewDirective@currentStep@trainBean@servletRequest">
    <uix:contents>
      <uix:include node="componentsTable.jsp"/>
      <uix:spacer width="10" height="10"/>
      <uix:messageComponentLayout columns="1"
                                  fieldWidth="100%">
        <uix:contents>
          <%-- Always use latest revision --%>
          <uix:messageLayout promptBinding="PA_ALWAYS_USE_LATEST_REVISION_PROMPT@paResourceBundle"
                             tipBinding="PA_CREATE_DIRECTIVE_USE_LATEST_REVISION_INFO_MSG@paResourceBundle"
                             renderedBinding="selectNewDirective@currentStep@trainBean@servletRequest">
            <uix:checkBox nameBinding="PA_ALWAYS_USE_LATEST_REVISION_CHECK@paResourceBundle"
                          checkedBinding="directiveAlwaysUseLatestRevision@currentStep@trainBean@servletRequest"/>
          </uix:messageLayout>
        </uix:contents>
      </uix:messageComponentLayout>

    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>
