<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.
 *
 * Creation page: create a group.
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:spacer height="10" width="10"/>
  <uix:rowLayout width="100%">
    <uix:cellFormat width="100%">
      <uix:contents>
        <uix:styledText renderedBinding="isNotInserting@trainBean@servletRequest"
                        textBinding="groupAlreadySelectedText@servletRequest"
                        styleClass="OraInstructionText"/>
        <%-- TODO: value needs to be specified for blockSize, minValue, and maxValue to matter --%>
        <uix:table renderedBinding="isInserting@trainBean@servletRequest"
                   nameBinding="PA_GROUP_TYPES_TABLE@paResourceBundle"
                   alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                   tableDataBinding="displayedTableData@groupTypesTable@servletRequest"
                   blockSize="5"
                   maxValue="4"
                   minValue="1"
                   formSubmitted="false"
                   width="100%">
          <uix:contents>
            <%-- group type --%>
            <uix:formValue nameBinding="PA_GROUP_TYPE_FORM_VALUE@paResourceBundle"
                           valueBinding="groupType"/>
            <%-- group name --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader valueBinding="PA_GROUP_NAME_CH_NAME@paResourceBundle"
                                    sortableBinding="PA_GROUP_NAME_CH_NAME@sortColumnHeader@procTable@servletRequest"
                                    textBinding="PA_GROUP_NAME_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:styledText textBinding="groupDisplayName"/>
              </uix:contents>
              <uix:columnFormat cellNoWrapFormat="false" width="30%"/>
            </uix:column>
            <%-- group description --%>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader valueBinding="PA_GROUP_DESCRIPTION_CH_NAME@paResourceBundle"
                                    sortableBinding="PA_GROUP_DESCRIPTION_CH_NAME@sortColumnHeader@procTable@servletRequest"
                                    textBinding="PA_GROUP_DESCRIPTION_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:styledText textBinding="groupDescription"/>
              </uix:contents>
              <uix:columnFormat cellNoWrapFormat="false" />
            </uix:column>
          </uix:contents>
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedGroupTypeIndex@servletRequest"/>
          </uix:tableSelection>
        </uix:table>
      </uix:contents>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>