<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.
 *
 * Creation page: create a host command step.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:rowLayout width="100%">
    <uix:contents>
      <uix:cellFormat width="40%" hAlign="left">
        <uix:contents>
          <uix:spacer height="10" width="10"/>
        </uix:contents>
      </uix:cellFormat>
    </uix:contents>
  </uix:rowLayout>
  <uix:rowLayout>
    <uix:contents>
      <uix:cellFormat width="40%" hAlign="left" vAlign="top">
        <uix:contents>
          <uix:labeledFieldLayout width="100">
            <uix:contents>
              <%-- Choice for type of host command --%>
              <uix:messageChoice nameBinding="PA_COMMAND_TYPE_CHOICE@paResourceBundle"
                                 promptBinding="PA_COMMAND_TYPE_CHOICE_PROMPT@paResourceBundle"
                                 selectedValueBinding="commandType@currentStep@trainBean@servletRequest"
                                 readOnlyBinding="typeChoiceReadOnly@servletRequest"
                                 onChange="submitForm('pafForm', false, {'event':'commandTypeChange'})">
                <uix:contents>
                  <uix:option textBinding="PA_COMMAND_OPTION@paResourceBundle"
                              valueBinding="PA_COMMAND_OPTION_VALUE@paResourceBundle"/>
                  <uix:option textBinding="PA_SCRIPT_OPTION@paResourceBundle"
                              valueBinding="PA_SCRIPT_OPTION_VALUE@paResourceBundle"/>
                </uix:contents>
              </uix:messageChoice>
              <%-- Script --%>
              <uix:messageTextInput nameBinding="PA_SCRIPT_INPUT@paResourceBundle"
                                    promptBinding="PA_SCRIPT_INPUT_PROMPT@paResourceBundle"
                                    columns="60"
                                    rows="20"
                                    requiredBinding="scriptRequired@currentStep@trainBean@servletRequest"
                                    readOnlyBinding="scriptInputReadOnly@servletRequest"
                                    renderedBinding="hasScript@currentStep@trainBean@servletRequest"
                                    textBinding="script@currentStep@trainBean@servletRequest"
                                    tipBinding="PA_SCRIPT_INPUT_TIP@paResourceBundle"/>
              <%-- Interpreter --%>
              <uix:messageTextInput nameBinding="PA_INTERPRETER_INPUT@paResourceBundle"
                                    columns="60"
                                    promptBinding="PA_INTERPRETER_INPUT_PROMPT@paResourceBundle"
                                    requiredBinding="commandRequired@currentStep@trainBean@servletRequest"
                                    readOnlyBinding="interpreterInputReadOnly@servletRequest"
                                    textBinding="interpreter@currentStep@trainBean@servletRequest"
                                    renderedBinding="hasScript@currentStep@trainBean@servletRequest"
                                    tipBinding="PA_INTERPRETER_INPUT_TIP@paResourceBundle"/>
              <%-- Command --%>
              <uix:messageTextInput nameBinding="PA_COMMAND_INPUT@paResourceBundle"
                                    columns="60"
                                    promptBinding="PA_COMMAND_INPUT_PROMPT@paResourceBundle"
                                    requiredBinding="commandRequired@currentStep@trainBean@servletRequest"
                                    readOnlyBinding="commandInputReadOnly@servletRequest"
                                    textBinding="command@currentStep@trainBean@servletRequest"
                                    renderedBinding="hasCommand@currentStep@trainBean@servletRequest"
                                    tipBinding="PA_COMMAND_INPUT_TIP@paResourceBundle"/>
              <%-- Arguments (hide the arguments since we dont need it now
              <uix:messageTextInput nameBinding="PA_ARGUMENTS_INPUT@paResourceBundle"
                                    prompt=""
                                    readOnlyBinding="argumentsInputReadOnly@servletRequest"
                                    textBinding="arguments@currentStep@trainBean@servletRequest"
                                    tipBinding="PA_ARGUMENTS_INPUT_TIP@paResourceBundle"/>
              --%>
              <%-- Execution Privilege Choice --%>
              <uix:messageChoice nameBinding="PA_EXECUTION_PRIVILEGE_CHOICE@paResourceBundle"
                                 promptBinding="PA_EXECUTION_PRIVILEGE_CHOICE_PROMPT@paResourceBundle"
                                 onChange="submitForm('pafForm', false, {'event':'execPrivChoiceChange'})"
                                 renderedBinding="renderSudo@currentStep@trainBean@servletRequest"
                                 selectedValueBinding="runAsString@currentStep@trainBean@servletRequest">
                <uix:contents childDataBinding="privileges@servletRequest">
                  <uix:option textBinding="text"
                              valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageTextInput nameBinding="PA_EXECUTION_PRIVILEGE_DETAIL_INPUT@paResourceBundle"
                                    promptBinding="PA_EXECUTION_PRIVILEGE_DETAIL_PROMPT@paResourceBundle"
                                    renderedBinding="isPrivilegeSudoOrPAM@currentStep@trainBean@servletRequest"
                                    tipBinding="(privilegeCommandTip@servletRequest)@paResourceBundle"
                                    textBinding="privilegeCommand@currentStep@trainBean@servletRequest"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:cellFormat>
      <uix:cellFormat hAlign="right">
        <uix:contents>
          <uix:spacer width="20"/>
        </uix:contents>
      </uix:cellFormat>
      <uix:cellFormat vAlign="top">
        <uix:contents>
          <%-- Target Properties table --%>
          <uix:header textBinding="PA_TARGET_PROPERTIES_HDR@paResourceBundle">
            <uix:contents>
              <uix:styledText textBinding="PA_TARGET_PROPERTIES_DESCRIPTION@paResourceBundle"/>
              <uix:table nameBinding="PA_TARGET_PROPERTIES_TABLE@paResourceBundle"
                         alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                         tableDataBinding="targetProperties@servletRequest">
                <uix:columnHeaderStamp/>
                <uix:contents>
                  <%-- Target property name --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PA_TARGET_PROPERTY_NAME_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="name"/>
                    </uix:contents>
                  </uix:column>
                  <%-- Target property description --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PA_TARGET_PROPERTY_DESC_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="desc"/>
                    </uix:contents>
                  </uix:column>
                </uix:contents>
              </uix:table>
              <uix:tip>
                <uix:contents>
                  <uix:formattedText textBinding="PA_TARGET_PROPERTIES_TIP@paResourceBundle"/>
                </uix:contents>
              </uix:tip>
            </uix:contents>
          </uix:header>
          <%-- Procedure Variables table --%>
          <uix:header textBinding="PA_PROCEDURE_VARIABLES_HDR@paResourceBundle"
                      renderedBinding="proceduresVariablesRendered@servletRequest">
            <uix:contents>
              <uix:styledText textBinding="PA_PROCEDURE_VARIABLES_DESCRIPTION@paResourceBundle"/>
              <uix:table nameBinding="PA_PROCEDURE_VARIABLES_TABLE@paResourceBundle"
                         alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                         tableDataBinding="procedureVariables@servletRequest">
                <uix:columnHeaderStamp/>
                <uix:contents>
                  <%-- Procedure variable name --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PA_PROCEDURE_VARIABLE_NAME_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="name"/>
                    </uix:contents>
                  </uix:column>
                  <%-- Procedure variable description --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PA_PROCEDURE_VARIABLE_DESC_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="desc"/>
                    </uix:contents>
                  </uix:column>
                </uix:contents>
              </uix:table>
            </uix:contents>
          </uix:header>
        </uix:contents>
      </uix:cellFormat>
    </uix:contents>
  </uix:rowLayout>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>
