<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.
 *
 * Creation page: create a generic job step.
 *
 * Inputs:
 *   String jobTypeAlreadySelectedText@servletRequest
 *   JobTypesTableBean jobTypes@httpSession
 *   Integer jobTypeSelectedIndex@servletRequest
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:spacer height="10" width="10"/>
  <uix:rowLayout width="100%">
    <uix:cellFormat width="100%">
      <uix:contents>
        <uix:styledText renderedBinding="isNotInserting@trainBean@servletRequest"
                        textBinding="jobTypeAlreadySelectedText@servletRequest"
                        styleClass="OraInstructionText"/>
        <%-- TODO: value needs to be specified for blockSize, minValue, and maxValue to matter --%>
        <uix:table renderedBinding="isInserting@trainBean@servletRequest"
                   name="jobTypeTable"
                   alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                   tableDataBinding="jobTypes@httpSession"
                   blockSize="5"
                   maxValue="4"
                   minValue="1"
                   formSubmitted="false"
                   width="100%">
          <uix:contents>
            <%@ include file="jobTypeTableColumns.jspf" %>
          </uix:contents>
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="jobTypeSelectedIndex@servletRequest"/>
          </uix:tableSelection>
        </uix:table>
      </uix:contents>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>