<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.
 *
 * Creation page: select target list for each phase inserted along with a group.
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:spacer height="10" width="10"/>
  <uix:rowLayout width="100%">
    <uix:cellFormat width="100%">
      <uix:contents>
        <uix:hGrid alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                   id="phaseHGrid"
                   formSubmitted="true"
                   partialRenderMode="self"
                   proxyBinding="proxy@proxyBean@servletRequest"
                   treeDataBinding="phaseTargetListTreeData@servletRequest">
          <%-- hGrid columns --%>
          <uix:nodeStamp>
            <%-- phase name column --%>
            <uix:column renderedBinding="phaseColumn@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_PHASE_NAME_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="30%" cellNoWrapFormat="false"/>
              <uix:contents>
                <uix:styledText textBinding="name"/>
              </uix:contents>
            </uix:column>
          </uix:nodeStamp>
          <uix:contents>
            <%-- save the step name --%>
            <uix:formValue name="name"
                           valueBinding="name"/>
            <%-- save the GUID --%>
            <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                           valueBinding="guid"/>
            <%-- target list --%>
            <uix:column renderedBinding="targetListColumn@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="PA_TARGET_LIST_CH@paResourceBundle"/>
              </uix:columnHeader>
              <uix:columnFormat width="70%" cellNoWrapFormat="true"/>
              <uix:contents>
                <uix:messageChoice nameBinding="PA_TARGET_LIST_CHOICE@paResourceBundle"
                                   readOnlyBinding="targetListChoiceReadOnly"
                                   renderedBinding="targetListChoiceRendered"
                                   onChange="submitForm('pafForm', false, {'event':'targetListChoiceChange'})"
                                   selectedValueBinding="selectedTargetList">
                  <uix:contents childDataBinding="targetLists">
                    <uix:option textBinding="shownText"
                                valueBinding="value"/>
                  </uix:contents>
                </uix:messageChoice>
              </uix:contents>
            </uix:column>
          </uix:contents>
        </uix:hGrid>
      </uix:contents>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:buildTree>

<%@ include file="templateCreate.jspf" %>