<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.
 *
 * Creation page: map component/directive variables with deployment procedure variables.
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%--All page content is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:stackLayout id="propertyBindingLayout">

    <%@page import="oracle.sysman.pp.paf.ui.CreateTrainBean"%>
    <%@page import="oracle.sysman.pp.paf.ui.StepBean"%>
    <%
    final CreateTrainBean trainBean = (CreateTrainBean)request.getAttribute("trainBean");
    final StepBean currentStep = trainBean.getCurrentStep();
    %>

    <uix:header textBinding="PA_CREATE_MAP_EXECUTION_MODE_HDR@paResourceBundle"
                renderedBinding="renderSudo@currentStep@trainBean@servletRequest">
      <uix:spacer height="8"/>
      <uix:messageComponentLayout columns="1"
                                  fieldWidth="100%">
        <uix:contents>
          <%-- Execution Privilege Choice --%>
          <uix:messageLayout promptBinding="PA_EXECUTION_PRIVILEGE_CHOICE_PROMPT@paResourceBundle"
                             renderedBinding="renderSudo@currentStep@trainBean@servletRequest">
            <uix:choice nameBinding="PA_EXECUTION_PRIVILEGE_CHOICE@paResourceBundle"
                        onChange="submitForm('pafForm', false, {'event':'execPrivChoiceChange'})"
                        selectedValueBinding="runAsString@currentStep@trainBean@servletRequest">
              <uix:contents childDataBinding="privileges@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>
            </uix:choice>
          </uix:messageLayout>
          <%-- Execution Privilege Command --%>
          <uix:messageLayout promptBinding="PA_EXECUTION_PRIVILEGE_DETAIL_PROMPT@paResourceBundle"
                             tipBinding="(privilegeCommandTip@servletRequest)@paResourceBundle"
                             renderedBinding="isPrivilegeSudoOrPAM@currentStep@trainBean@servletRequest">
            <uix:textInput nameBinding="PA_EXECUTION_PRIVILEGE_DETAIL_INPUT@paResourceBundle"
                           textBinding="privilegeCommand@currentStep@trainBean@servletRequest"/>
          </uix:messageLayout>
          <%-- Execute Directive --%>
          <uix:messageLayout promptBinding="PA_EXECUTE_DIRECTIVE_PROMPT@paResourceBundle"
                             tipBinding="PA_EXECUTE_DIRECTIVE_TIP@paResourceBundle"
                             renderedBinding="isDirectiveOrComponent@currentStep@trainBean@servletRequest">
            <uix:checkBox nameBinding="PA_EXECUTE_DIRECTIVE_CHECK@paResourceBundle"
                          checkedBinding="executeDirective@currentStep@trainBean@servletRequest"/>
          </uix:messageLayout>
          <%-- Do Cleanup --%>
          <uix:messageLayout promptBinding="PA_DO_CLEANUP_PROMPT@paResourceBundle"
                             tipBinding="PA_DO_CLEANUP_TIP@paResourceBundle"
                             renderedBinding="isDirectiveOrComponent@currentStep@trainBean@servletRequest">
            <uix:checkBox nameBinding="PA_DO_CLEANUP_CHECK@paResourceBundle"
                          checkedBinding="doCleanUp@currentStep@trainBean@servletRequest"/>
          </uix:messageLayout>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>

    <uix:header textBinding="PA_CREATE_MAP_FILE_TRANSFER_HDR@paResourceBundle"
                renderedBinding="renderFileTransferProperties@servletRequest">
      <uix:spacer height="8"/>
      <uix:messageComponentLayout columns="4" width="1">
        <uix:contents childDataBinding="value@translatedJobTypePropertiesList@currentStep@trainBean@servletRequest">
          <%@ include file="fileTransferPropertiesRowLayout.jspf" %>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>
    <uix:header textBinding="PA_CREATE_MAP_VOL_CLONING_HDR@paResourceBundle"
                renderedBinding="renderVolCloningProperties@servletRequest">
      <uix:spacer height="8"/>
      <uix:messageComponentLayout columns="4" width="1">
        <uix:contents childDataBinding="value@translatedJobTypePropertiesList@currentStep@trainBean@servletRequest">
          <%@ include file="volClonePropertiesRowLayout.jspf" %>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>



    <uix:header textBinding="PA_CREATE_MAP_JOB_TYPE_HDR@paResourceBundle"
                renderedBinding="renderJobTypeProperties@servletRequest">
      <uix:spacer height="8"/>
      <uix:styledText textBinding="PA_JOB_TYPE_NO_PROPERTIES_TO_MAP@paResourceBundle"
                      rendered="<%= currentStep.getJobTypePropertiesList().getLength() == 0 %>"
                      styleClass="OraInstructionText"/>
      <uix:messageComponentLayout columns="4" width="1">
        <uix:contents childDataBinding="value@translatedJobTypePropertiesList@currentStep@trainBean@servletRequest">
          <%@ include file="propertiesRowLayout.jspf" %>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>

    <uix:header textBinding="PA_CREATE_MAP_COMPONENT_HDR@paResourceBundle"
                renderedBinding="renderComponentProperties@servletRequest">
      <uix:spacer height="8"/>
      <uix:styledText textBinding="PA_COMPONENT_NO_PROPERTIES_TO_MAP@paResourceBundle"
                      rendered="<%= currentStep.getComponentPropertiesList().getLength() == 0 %>"
                      styleClass="OraInstructionText"/>
      <uix:messageComponentLayout columns="4" width="1">
        <uix:contents childDataBinding="value@translatedComponentPropertiesList@currentStep@trainBean@servletRequest">
          <%@ include file="propertiesRowLayout.jspf" %>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>

    <uix:header textBinding="PA_CREATE_MAP_DIRECTIVE_HDR@paResourceBundle"
                renderedBinding="renderDirectiveProperties@servletRequest">
      <uix:spacer height="8"/>
      <uix:styledText textBinding="PA_DIRECTIVE_NO_PROPERTIES_TO_MAP@paResourceBundle"
                      rendered="<%= currentStep.getDirectivePropertiesList().getLength() == 0 %>"
                      styleClass="OraInstructionText"/>
      <uix:messageComponentLayout columns="4" width="1">
        <uix:contents childDataBinding="value@translatedDirectivePropertiesList@currentStep@trainBean@servletRequest">
          <%@ include file="propertiesRowLayout.jspf" %>
        </uix:contents>
      </uix:messageComponentLayout>
    </uix:header>

  </uix:stackLayout>
</uix:buildTree>
<%@ include file="templateCreate.jspf" %>
