<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="psBundle"
              class="oracle.sysman.pp.paf.ui.resource.PASectionResourceBundle"/>

  <uix:bundle name="demoBundle"
              class="oracle.sysman.pp.paf.sample.ui.rsc.PAFDemoResourceBundle"/>

  <%--ResourceBundle for Schedule page labels/headers etc--%>
  <uix:bundle name="scheduleResourceBundle"
              class="oracle.sysman.eml.rsc.page.seg.sch.scheduleMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
      <uix:form name="pageForm" method="POST">

        <uix:switcher childNameBinding="isError@servletRequest">
          <uix:case name="error">
            <uix:pageLayout
              title="Demo Application"
              titleBinding="PAF_DEMO_HEADER@demoBundle"
              >
              <%@ include file="/oemGlobal.jspf" %>

              <uix:messageBox messageType="error"
                  messageBinding="errMsgKey@servletRequest">
              </uix:messageBox>

              <uix:pageButtons>
                <uix:pageButtonBar>

                  <uix:submitButton
                    name="event"
                    value="ok"
                    text="Ok"
                    textBinding="PAF_DEMO_OK_BUTTON@demoBundle"/>

                </uix:pageButtonBar>
              </uix:pageButtons>
            </uix:pageLayout>
          </uix:case>
          <uix:default>
            <uix:pageLayout
              title="Demo Application"
              titleBinding="PAF_DEMO_HEADER@demoBundle"
              >
              <%@ include file="/oemGlobal.jspf" %>

              <uix:rowLayout width="100%">
                <uix:cellFormat width="100%">
                  <uix:header text="Credentials">
                    <uix:labeledFieldLayout
                      width="60%"
                      labelWidth="0%"
                      fieldWidth="100%">

                      <uix:messageTextInput
                        name="hostname"
                        prompt="Hostname"
                        promptBinding="PAF_DEMO_HOSTNAME@demoBundle"
                        tip="Please enter the hostname"
                        tipBinding="PAF_DEMO_HOSTNAME_TIP@demoBundle"
                        textBinding="hostName@pafDemoBean@servletRequest"/>

                      <uix:messageTextInput
                        name="username"
                        prompt="Username"
                        tip="Please enter the host username"
                        promptBinding="PAF_DEMO_USERNAME@demoBundle"
                        tipBinding="PAF_DEMO_USERNAME_TIP@demoBundle"
                        textBinding="userName@pafDemoBean@servletRequest"
                        noAutoComplete="true"
                        />

                      <uix:messageTextInput
                        name="password"
                        prompt="Password"
                        promptBinding="PAF_DEMO_PWD@demoBundle"
                        tip="Please enter the host user password"
                        tipBinding="PAF_DEMO_PWD_TIP@demoBundle"
                        textBinding="userPwd@pafDemoBean@servletRequest"
                        noAutoComplete="true"
                        secret="true"/>
                    </uix:labeledFieldLayout>
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout width="100%">
                <uix:cellFormat width="100%">
                  <uix:spacer width="10" height="10"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout width="100%">
                <uix:cellFormat width="100%">
                  <uix:header textBinding="PAF_DEMO_SCHEDULE_HDR@demoBundle">
                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:spacer width="21"/>
                        <uix:messageRadioButton name="startOption"
                                                textBinding="IMMEDIATELY@scheduleResourceBundle"
                                                promptBinding="TYPE@scheduleResourceBundle"
                                                selectedBinding="isStartNowSelected@demoScheduleSegmentBean@servletRequest"
                                                renderedBinding="isStartNowRendered@demoScheduleSegmentBean@servletRequest"
                                        	      primaryClientActionBinding="startNowFireAction@demoScheduleSegmentBean@servletRequest"
                                                shortDescBinding="IMMEDIATELY@scheduleResourceBundle"/>
                        <uix:spacer width="10"/>
                        <uix:messageRadioButton name="startOption"
                                                textBinding="LATER@scheduleResourceBundle"
                                                selectedBinding="isStartLaterSelected@demoScheduleSegmentBean@servletRequest"
                                                renderedBinding="isStartLaterRendered@demoScheduleSegmentBean@servletRequest"
                                        	      primaryClientActionBinding="startLaterFireAction@demoScheduleSegmentBean@servletRequest"
                                                shortDescBinding="LATER@scheduleResourceBundle"/>
                        <uix:spacer width="10"/>
                        <uix:messageRadioButton name="startOption"
                                                textBinding="REPEATING@scheduleResourceBundle"
                                                selectedBinding="isRepeatingSelected@demoScheduleSegmentBean@servletRequest"
                                                renderedBinding="isRepeatingRendered@demoScheduleSegmentBean@servletRequest"
                                                primaryClientActionBinding="repeatingFireAction@demoScheduleSegmentBean@servletRequest"
                                                shortDescBinding="REPEATING@scheduleResourceBundle"/>

                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:spacer height="10" width="10"/>

                    <uix:tableLayout width="50%" id="scheduleID">

                      <%-- frequency type --%>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="frequencyTypeRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messageChoice nameBinding="PAF_DEMO_SCHEDULE_FREQUENCY_TYPE_CHOICE@demoBundle"
                                           promptBinding="FREQUENCY_TYPE@scheduleResourceBundle"
                                           shortDescBinding="FREQUENCY_TYPE@scheduleResourceBundle"
                                           renderedBinding="frequencyTypeRendered@demoScheduleSegmentBean@servletRequest"
                                           selectedValueBinding="selectedFrequencyType@servletRequest"
                                           primaryClientActionBinding="frequencyTypeFireAction@demoScheduleSegmentBean@servletRequest">
                          <uix:contents childDataBinding="frequencyTypes@servletRequest">
                            <uix:option textBinding="text"
                                        valueBinding="value"/>
                          </uix:contents>
                        </uix:messageChoice>
                      </uix:labeledFieldLayout>
                      <uix:spacer height="5"
                                  width="5"
                                  renderedBinding="frequencyTypeRendered@demoScheduleSegmentBean@servletRequest"/>
                      <%-- frequency details --%>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="frequencyDetailsRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messageTextInput nameBinding="PAF_DEMO_SCHEDULE_REPEAT_INTERVAL_INPUT@demoBundle"
                                              columns="2"
                                              promptBinding="REPEAT_EVERY@scheduleResourceBundle"
                                              textBinding="repeatIntervalObject@demoScheduleSegmentBean@servletRequest"
                                              shortDescBinding="REPEAT_EVERY@scheduleResourceBundle"
                                              disabledBinding="readOnlyMode@servletRequest"
                                              messageTypeBinding="repeatIntervalMsgType@errors@servletRequest"
                                              messageBinding="repeatIntervalInlineMsg@errors@servletRequest"
                                              anchorBinding="repeatIntervalAnchor@errors@servletRequest"
                                              vAlign="center">
                          <uix:onSubmitValidater>
                            <uix:regExp pattern="[0-9]+"/>
                          </uix:onSubmitValidater>
                          <uix:end>
                            <uix:messagePrompt promptBinding="MINUTES@scheduleResourceBundle"
                                               vAlign="center"/>
                          </uix:end>
                        </uix:messageTextInput>
                      </uix:labeledFieldLayout>
                      <uix:spacer height="5"
                                  width="5"
                                  renderedBinding="frequencyDetailsRendered@demoScheduleSegmentBean@servletRequest"/>
                      <%-- timezone --%>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="timezoneRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messageChoice nameBinding="PAF_DEMO_SCHEDULE_TIMEZONE_CHOICE@demoBundle"
                                           promptBinding="TIME_ZONE@scheduleResourceBundle"
                                           shortDescBinding="TIME_ZONE@scheduleResourceBundle"
                                           renderedBinding="timezoneRendered@demoScheduleSegmentBean@servletRequest"
                                           selectedValueBinding="selectedTimeZoneSB@demoScheduleSegmentBean@servletRequest">
                          <uix:contents childDataBinding="timezones@servletRequest">
                            <uix:option textBinding="text"
                                        valueBinding="value"/>
                          </uix:contents>
                        </uix:messageChoice>
                      </uix:labeledFieldLayout>
                      <uix:spacer height="5"
                                  width="5"
                                  renderedBinding="timezoneRendered@demoScheduleSegmentBean@servletRequest"/>
                      <%-- start date --%>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="startDateRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messageDateField id="startDate"
                                              nameBinding="PAF_DEMO_SCHEDULE_START_DATE_FIELD@demoBundle"
                                              valueBinding="startDate@servletRequest"
                                              promptBinding="START_DATE@scheduleResourceBundle"
                                              shortDescBinding="START_DATE@scheduleResourceBundle"
                                              messageTypeBinding="startDateMsgType@errors@servletRequest"
                                              messageBinding="startDateInlineMsg@errors@servletRequest"
                                              anchorBinding="startDateAnchor@errors@servletRequest"
                                              columns="12"
                                              disabledBinding="readOnlyMode@servletRequest">
                          <uix:onSubmitValidater>
                            <uix:date dateStyle="medium"/>
                          </uix:onSubmitValidater>
                        </uix:messageDateField>
                      </uix:labeledFieldLayout>
                      <uix:spacer height="5"
                                  width="5"
                                  renderedBinding="startDateRendered@demoScheduleSegmentBean@servletRequest"/>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="startDateRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messagePrompt promptBinding="START_TIME@scheduleResourceBundle"/>
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:messageTextInput nameBinding="PAF_DEMO_SCHEDULE_START_HOUR_INPUT@demoBundle"
                                                    columns="2"
                                                    textBinding="startHour@servletRequest"
                                                    shortDescBinding="HOURS@scheduleResourceBundle"
                                                    disabledBinding="readOnlyMode@servletRequest"
                                                    maximumLength="2"
                                                    messageTypeBinding="startHourMsgType@errors@servletRequest"
                                                    messageBinding="startHourInlineMsg@errors@servletRequest"
                                                    anchorBinding="startHourAnchor@errors@servletRequest"
                                                    vAlign="top">
                                <uix:onSubmitValidater>
                                  <uix:regExp pattern="[0-9]+"/>
                                </uix:onSubmitValidater>
                                <uix:end>
                                  <uix:styledText textBinding="TIME_SEPERATOR@scheduleResourceBundle" />
                                </uix:end>
                              </uix:messageTextInput>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messageTextInput nameBinding="PAF_DEMO_SCHEDULE_START_MINUTE_INPUT@demoBundle"
                                                    columns="2"
                                                    maximumLength="2"
                                                    textBinding="startMinute@servletRequest"
                                                    shortDescBinding="MINUTES@scheduleResourceBundle"
                                                    disabledBinding="readOnlyMode@servletRequest"
                                                    messageTypeBinding="startMinuteMsgType@errors@servletRequest"
                                                    messageBinding="startMinuteInlineMsg@errors@servletRequest"
                                                    anchorBinding="startMinuteAnchor@errors@servletRequest"
                                                    vAlign="top">
                                <uix:onSubmitValidater>
                                  <uix:regExp pattern="[0-9]+"/>
                                </uix:onSubmitValidater>
                              </uix:messageTextInput>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messageRadioButton nameBinding="PAF_DEMO_START_TIME_AMPM_RB@demoBundle"
                                                      textBinding="AM_LABEL@scheduleResourceBundle"
                                                      selectedValueBinding="startAmPm@servletRequest"
                                                      valueBinding="PAF_DEMO_START_TIME_AM_VALUE@demoBundle"
                                                      renderedBinding="isStartAMRendered@demoScheduleSegmentBean@servletRequest"
                                                      shortDescBinding="AM_LABEL@scheduleResourceBundle"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messageRadioButton nameBinding="PAF_DEMO_START_TIME_AMPM_RB@demoBundle"
                                                      textBinding="PM_LABEL@scheduleResourceBundle"
                                                      selectedValueBinding="startAmPm@servletRequest"
                                                      valueBinding="PAF_DEMO_START_TIME_PM_VALUE@demoBundle"
                                                      renderedBinding="isStartAMRendered@demoScheduleSegmentBean@servletRequest"
                                                      shortDescBinding="PM_LABEL@scheduleResourceBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:labeledFieldLayout>
                      <uix:spacer height="5"
                                  width="5"
                                  renderedBinding="startDateRendered@demoScheduleSegmentBean@servletRequest"/>
                      <%-- duration --%>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="durationRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:messageRadioButton nameBinding="PAF_DEMO_DURATION_RB@demoBundle"
                                                promptBinding="GRACE_PERIOD@scheduleResourceBundle"
                                                textBinding="INDEFINITE@scheduleResourceBundle"
                                                shortDescBinding="INDEFINITE@scheduleResourceBundle"
                                                valueBinding="PAF_DEMO_DURATION_INDEFINITE_VALUE@demoBundle"
                                                selectedValueBinding="durationType@demoScheduleSegmentBean@servletRequest"
                                                disabledBinding="readOnlyMode@servletRequest"/>
                      </uix:labeledFieldLayout>
                      <uix:labeledFieldLayout columns="1"
                                              width="60%"
                                              renderedBinding="durationRendered@demoScheduleSegmentBean@servletRequest">
                        <uix:spacer height="5" width="5"/>
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:messageRadioButton nameBinding="PAF_DEMO_DURATION_RB@demoBundle"
                                                      textBinding="END_AFTER@scheduleResourceBundle"
                                                      shortDescBinding="END_AFTER@scheduleResourceBundle"
                                                      valueBinding="PAF_DEMO_DURATION_INTERVAL_VALUE@demoBundle"
                                                      selectedValueBinding="durationType@demoScheduleSegmentBean@servletRequest"
                                                      disabledBinding="readOnlyMode@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:spacer height="5" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messageTextInput nameBinding="PAF_DEMO_SCHEDULE_DURATION_HOUR_INPUT@demoBundle"
                                                    columns="2"
                                                    textBinding="durationIntervalHoursObject@demoScheduleSegmentBean@servletRequest"
                                                    shortDescBinding="HOURS@scheduleResourceBundle"
                                                    disabledBinding="readOnlyMode@servletRequest"
                                                    maximumLength="2"
                                                    messageTypeBinding="durationHourMsgType@errors@servletRequest"
                                                    messageBinding="durationHourInlineMsg@errors@servletRequest"
                                                    anchorBinding="durationHourAnchor@errors@servletRequest"
                                                    vAlign="top">
                                <uix:onSubmitValidater>
                                  <uix:regExp pattern="[0-9]+"/>
                                </uix:onSubmitValidater>
                              </uix:messageTextInput>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:spacer height="5" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messagePrompt promptBinding="HOURS@scheduleResourceBundle"
                                                 vAlign="center"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:spacer height="5" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messageTextInput nameBinding="PAF_DEMO_SCHEDULE_DURATION_MINUTE_INPUT@demoBundle"
                                                    columns="2"
                                                    maximumLength="2"
                                                    textBinding="durationIntervalMinutesObject@demoScheduleSegmentBean@servletRequest"
                                                    shortDescBinding="MINUTES@scheduleResourceBundle"
                                                    disabledBinding="readOnlyMode@servletRequest"
                                                    messageTypeBinding="durationMinutesMsgType@errors@servletRequest"
                                                    messageBinding="durationMinutesInlineMsg@errors@servletRequest"
                                                    anchorBinding="durationMinutesAnchor@errors@servletRequest"
                                                    vAlign="top">
                                <uix:onSubmitValidater>
                                  <uix:regExp pattern="[0-9]+"/>
                                </uix:onSubmitValidater>
                              </uix:messageTextInput>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:spacer height="5" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:messagePrompt promptBinding="MINUTES@scheduleResourceBundle"
                                                 vAlign="center"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:labeledFieldLayout>

                    </uix:tableLayout>
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>


              <%--
                Buttons on the page
               --%>

              <uix:pageButtons>
                <uix:pageButtonBar>

                  <uix:submitButton
                    name="event"
                    value="cancel"
                    text="Cancel"
                    textBinding="PAF_DEMO_CANCEL_BUTTON@demoBundle"/>

                  <uix:submitButton
                    name="event"
                    value="submit"
                    text="Submit"
                    textBinding="PAF_DEMO_SUBMIT_BUTTON@demoBundle"/>

                  <uix:submitButton
                    name="event"
                    value="save"
                    text="Save"
                    textBinding="PAF_DEMO_SAVE_BUTTON@demoBundle"/>
                                                                                                  

                </uix:pageButtonBar>
              </uix:pageButtons>
            </uix:pageLayout>
          </uix:default>
        </uix:switcher>
      </uix:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

