<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbBundle" class="oracle.sysman.pp.paf.ui.resource.DBResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/enablePPR.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <oem:messageBox messageType="error" titleTextKey="titleText" mainTextKey="mainText" errorTableBinding="errors@servletRequest"/>
        <oem:messageBox messageType="info" titleTextKey="titleText" mainTextKey="mainText" errorTableBinding="info@servletRequest"/>
        <uix:header textBinding="PAF_GS_HEADER@dbBundle">
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PARA_1@dbBundle"/>
                <uix:spacer width="10" height="10"/>
                <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PARA_2@dbBundle"/>
                <uix:spacer width="10" height="10"/>
                <uix:flowLayout>
                  <uix:spacer width="20"/>
                  <uix:formattedText text="pafctl &lt;action&gt; &lt;sysman password&gt; &lt;interval&gt;"/>
                </uix:flowLayout>
                <uix:spacer width="10" height="10"/>
                <uix:bulletedList>
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:flowLayout>
                          <uix:styledText styleClass="OraInstructionTextStrong" text="action : "/>
                          <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_ACTION@dbBundle"/>
                        </uix:flowLayout>
                        <uix:bulletedList>
                          <uix:contents>
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraInstructionTextStrong" text="start : "/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_START@dbBundle"/>
                            </uix:flowLayout>
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraInstructionTextStrong" text="stop : "/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_STOP@dbBundle"/>
                            </uix:flowLayout>
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraInstructionTextStrong" text="status : "/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_STATUS@dbBundle"/>
                            </uix:flowLayout>
                          </uix:contents>
                        </uix:bulletedList>
                      </uix:contents>
                    </uix:stackLayout>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" text="sysman password : "/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PASSWORD@dbBundle"/>
                    </uix:flowLayout>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionTextStrong" text="interval : "/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_INTERVAL@dbBundle"/>
                    </uix:flowLayout>
                  </uix:contents>
                </uix:bulletedList>
              </uix:contents>
            </uix:stackLayout>
          </uix:contents>
        </uix:header>
        <uix:spacer width="10" height="10"/>
        <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PARA_3@dbBundle"/>
        <uix:spacer width="10" height="10"/>
        <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PARA_4@dbBundle"/>
        <uix:spacer width="10" height="10"/>
        <uix:spacer width="10" height="10"/>
        <uix:bulletedList>
          <uix:contents>
            <uix:flowLayout>
              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="PAF_GS_PROC_TAB@dbBundle"/>
              <uix:styledText styleClass="OraInstructionTextStrong" text=" : "/>
              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_PROC_TAB_TEXT@dbBundle"/>
            </uix:flowLayout>
            <uix:flowLayout>
              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="PAF_GS_STATUS_TAB@dbBundle"/>
              <uix:styledText styleClass="OraInstructionTextStrong" text=" : "/>
              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_STATUS_TAB_TEXT@dbBundle"/>
            </uix:flowLayout>
            <uix:flowLayout>
              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="PAF_GS_RBIN_TAB@dbBundle"/>
              <uix:styledText styleClass="OraInstructionTextStrong" text=" : "/>
              <uix:styledText styleClass="OraInstructionText" textBinding="PAF_GS_RBIN_TAB_TEXT@dbBundle"/>
            </uix:flowLayout>
          </uix:contents>
        </uix:bulletedList>
        <uix:spacer width="10" height="10"/>

<uix:switcher childNameBinding="PAF_GS_LINK_BOOLEAN@dbBundle">
  <uix:case name="PAF_GS_LINK_BOOLEAN">
        <uix:header textBinding="PAF_GS_RELATED@dbBundle">
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:link destinationBinding="PAF_GS_D_ABOUT@dbBundle" textBinding="PAF_GS_L_ABOUT@dbBundle"/>
                <uix:link destinationBinding="PAF_GS_D_CUS@dbBundle" textBinding="PAF_GS_L_CUS@dbBundle"/>
                <uix:link destinationBinding="PAF_GS_D_CRE@dbBundle" textBinding="PAF_GS_L_CRE@dbBundle"/>
                <uix:link destinationBinding="PAF_GS_D_EM@dbBundle" textBinding="PAF_GS_L_EM@dbBundle"/>
              </uix:contents>
            </uix:stackLayout>
          </uix:contents>
        </uix:header>
  </uix:case>
</uix:switcher>
               
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

