<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       instances.jsp
 *
 *      NOTES
 *       Home Page for Provisioning Advisor Framework (showing instances)
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ktamtoro  01/09/06 - XbranchMerge ktamtoro_ui_bugs_4925024_4925037_4927434 
 *                       from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/12/05 -
 *  fantic    10/06/05 - adding run button
 *  ktamtoro  09/02/05 - Remove auto refresh
 *  ktamtoro  08/22/05 - Add auto refresh
 *  ktamtoro  08/19/05 - Add status/progress bar
 *  ktamtoro  08/16/05 - Add delete button
 *  sonorato  08/16/05 -
 *  ktamtoro  08/12/05 -
 *  ktamtoro  08/11/05 - Move search filters to second row
 *  ktamtoro  08/09/05 - add link to current status page
 *  ktamtoro  07/30/05 -
 *  ktamtoro  07/29/05 -
 *  ktamtoro  07/22/05 -
 *  clo       07/13/05 - Changing UI text
 *  ktamtoro  06/22/05 - ktamtoro_ui_updates
 *  ktamtoro  06/21/05 - Move Instances table to instances.jsp
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/15/05 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="mainPageContent" scope="request">
  <%-- auto refresh every 1 min --%>
<%--
  <uix:rawText>
    <meta http-equiv="Refresh" content="60"/>
  </uix:rawText>
--%>
  <uix:spacer height="10" width="10"/>
  <%-- Running Instances table --%>
  <uix:table id="instTable"
             nameBinding="PA_INSTANCE_TABLE@paResourceBundle"
             alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
             blockSizeBinding="blockSize@instTable@servletRequest"
             maxValueBinding="maxValue@instTable@servletRequest"
             minValueBinding="minValue@instTable@servletRequest"
             valueBinding="currentValue@instTable@servletRequest"
             tableDataBinding="displayedTableData@instTable@servletRequest"
             partialRenderMode="self"
             showAll="yes"
             formSubmitted="true"
             width="100%">
    <uix:contents>
      <%@ include file="instancesTableColumns.jspf" %>
    </uix:contents>
    <uix:tableSelection>
      <uix:singleSelection selectedIndexBinding="instSelectedIndex@servletRequest"
                           primaryClientActionBinding="instClientAction@servletRequest">
        <uix:contents>
          <%-- Stop a running instance --%>
          <%--
          <uix:submitButton textBinding="PA_STOP_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_STOP@paResourceBundle"
                            disabledBinding="stopBtnDisabled@servletRequest"
                            shortDescBinding="stopBtnShortDesc@servletRequest"
                            renderedBinding="stopBtnRendered@servletRequest"/>
          --%>
          <%-- Abort a running instance --%>
          <uix:submitButton textBinding="PA_ABORT_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_ABORT@paResourceBundle"
                            disabledBinding="abortBtnDisabled@servletRequest"
                            shortDescBinding="abortBtnShortDesc@servletRequest"
                            renderedBinding="abortBtnRendered@servletRequest"/>
          <%-- Pause a running instance --%>
          <uix:submitButton textBinding="PA_PAUSE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_PAUSE@paResourceBundle"
                            disabledBinding="pauseBtnDisabled@servletRequest"
                            shortDescBinding="pauseBtnShortDesc@servletRequest"
                            renderedBinding="pauseBtnRendered@servletRequest"/>
          <%-- Resume a paused instance --%>
          <uix:submitButton textBinding="PA_RESUME_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RESUME@paResourceBundle"
                            disabledBinding="resumeBtnDisabled@servletRequest"
                            shortDescBinding="resumeBtnShortDesc@servletRequest"
                            renderedBinding="resumeBtnRendered@servletRequest"/>
          <%-- Retry a failed instance --%>
          <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RETRY@paResourceBundle"
                            disabledBinding="retryBtnDisabled@servletRequest"
                            shortDescBinding="retryBtnShortDesc@servletRequest"
                            renderedBinding="retryBtnRendered@servletRequest"/>
          <%-- Delete an instance --%>
          <uix:submitButton textBinding="PA_DELETE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_DELETE@paResourceBundle"
                            disabledBinding="deleteBtnDisabled@servletRequest"
                            shortDescBinding="deleteBtnShortDesc@servletRequest"
                            renderedBinding="deleteBtnRendered@servletRequest"/>
          <%-- Run a saved instance --%>
          <uix:submitButton textBinding="PA_RUN_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RUN_PROCEDURE@paResourceBundle"
                            shortDescBinding="runBtnShortDesc@servletRequest"
                            disabledBinding="runBtnDisabled@servletRequest"
                            renderedBinding="runBtnRendered@servletRequest"/>
        </uix:contents>
      </uix:singleSelection>
    </uix:tableSelection>
  </uix:table>
</uix:buildTree>

<%@ include file="templateMainPage.jspf" %>
