<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       pageButtons.jsp
 *
 *      NOTES
 *       Page buttons for Provisioning Advisor pages.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  07/13/07 - adding delete button
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_paf_ui_fixes_2 from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_upload_tool_ui from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/14/05 -
 *  fantic    10/07/05 - adding disabled binding and short desc to run button
 *  ktamtoro  09/19/05 - Move refresh button to base template
 *  ktamtoro  08/25/05 - Add disabled binding and short desc
 *  ktamtoro  08/10/05 - Add revert button
 *  sonorato  08/05/05 -
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/28/05 - created
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:pageButtonBar renderedBinding="pageButtonBarRendered@servletRequest">
  <uix:contents>
    <%-- Discard changes of a deployment procedure --%>
    <uix:submitButton textBinding="PA_CANCEL_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_CANCEL@paResourceBundle"
                      unvalidated="true"
                      shortDescBinding="PA_CANCEL_BTN_TIP@paResourceBundle"
                      renderedBinding="cancelBtnRendered@servletRequest"/>
    <%-- View a deployment procedure --%>
    <uix:submitButton textBinding="PA_VIEW_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_VIEW_PROCEDURE@paResourceBundle"
                      shortDescBinding="PA_VIEW_BTN_TIP@paResourceBundle"
                      renderedBinding="viewBtnRendered@servletRequest"/>
    <%-- Edit a deployment procedure --%>
    <uix:submitButton textBinding="PA_EDIT_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_EDIT_PROCEDURE@paResourceBundle"
                      disabledBinding="editBtnDisabled@servletRequest"
                      shortDescBinding="editBtnShortDesc@servletRequest"
                      renderedBinding="editBtnRendered@servletRequest"/>
    <%-- Delete a procedure --%>
    <uix:submitButton textBinding="PA_DELETE_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_DELETE@paResourceBundle"
                      disabledBinding="deleteBtnDisabled@servletRequest"
                      shortDescBinding="deleteBtnShortDesc@servletRequest"
                      renderedBinding="deleteBtnRendered@servletRequest"/>
    <%-- Create a new deployment procedure like this one --%>
    <uix:submitButton textBinding="PA_CREATE_LIKE_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_CREATE_LIKE_PROCEDURE@paResourceBundle"
                      shortDescBinding="PA_CREATE_LIKE_BTN_TIP@paResourceBundle"
                      renderedBinding="createLikeBtnRendered@servletRequest"/>
    <%-- Revert a deployment procedure to older version --%>
    <uix:submitButton textBinding="PA_REVERT_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_REVERT@paResourceBundle"
                      disabledBinding="revertBtnDisabled@servletRequest"
                      shortDescBinding="revertBtnShortDesc@servletRequest"
                      renderedBinding="revertBtnRendered@servletRequest"/>
    <%-- Run a deployment procedure --%>
    <uix:submitButton textBinding="PA_RUN_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_RUN_PROCEDURE@paResourceBundle"
                      disabledBinding="runBtnDisabled@servletRequest"
                      shortDescBinding="PA_RUN_BTN_TIP@paResourceBundle"
                      renderedBinding="runBtnRendered@servletRequest"/>
    <%-- Save a deployment procedure --%>
    <uix:submitButton textBinding="PA_SAVE_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_SAVE@paResourceBundle"
                      disabledBinding="saveBtnDisabled@servletRequest"
                      shortDescBinding="PA_SAVE_BTN_TIP@paResourceBundle"
                      renderedBinding="saveBtnRendered@servletRequest"/>
    <%-- Stop a running instance of a procedure --%>
    <uix:submitButton textBinding="PA_STOP_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_STOP@paResourceBundle"
                      disabledBinding="stopBtnDisabled@servletRequest"
                      shortDescBinding="PA_STOP_BTN_TIP@paResourceBundle"
                      renderedBinding="stopBtnRendered@servletRequest"/>
    <%-- Abort a running instance --%>
    <uix:submitButton textBinding="PA_ABORT_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_ABORT@paResourceBundle"
                      disabledBinding="abortBtnDisabled@servletRequest"
                      shortDescBinding="PA_ABORT_BTN_TIP@paResourceBundle"
                      renderedBinding="abortBtnRendered@servletRequest"/>
    <%-- Pause a running instance --%>
    <uix:submitButton textBinding="PA_PAUSE_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_PAUSE@paResourceBundle"
                      disabledBinding="pauseBtnDisabled@servletRequest"
                      shortDescBinding="PA_PAUSE_BTN_TIP@paResourceBundle"
                      renderedBinding="pauseBtnRendered@servletRequest"/>
    <%-- Resume a paused instance --%>
    <uix:submitButton textBinding="PA_RESUME_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_RESUME@paResourceBundle"
                      disabledBinding="resumeBtnDisabled@servletRequest"
                      shortDescBinding="PA_RESUME_BTN_TIP@paResourceBundle"
                      renderedBinding="resumeBtnRendered@servletRequest"/>
    <%-- Retry a failed procedure/job --%>
    <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_RETRY@paResourceBundle"
                      disabledBinding="retryBtnDisabled@servletRequest"
                      shortDescBinding="PA_RETRY_BTN_TIP@paResourceBundle"
                      renderedBinding="retryBtnRendered@servletRequest"/>
    <%-- Deploy a PAR file to install a new procedure --%>
    <uix:submitButton textBinding="PA_ADMIN_DEPLOY_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_ADMIN_DEPLOY@paResourceBundle"
                      shortDescBinding="PA_ADMIN_DEPLOY_BTN_TIP@paResourceBundle"
                      unvalidated="true"
                      renderedBinding="deployBtnRendered@servletRequest"/>
    <%-- Finish viewing/editing a procedure --%>
    <uix:submitButton textBinding="PA_DONE_BTN@paResourceBundle"
                      name="event"
                      valueBinding="PA_DONE@paResourceBundle"
                      shortDescBinding="PA_DONE_BTN_TIP@paResourceBundle"
                      unvalidated="true"
                      renderedBinding="doneBtnRendered@servletRequest"/>
  </uix:contents>
</uix:pageButtonBar>
