<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.  
 *
 * HGrid to display procedure detail in view, edit, and status pages.
 *
 * Inputs:
 *   SimpleTreeData procedureTreeData@servletRequest
 *   HGridProxyBean proxyBean@servletRequest
 *   a bunch more (see oracle.sysman.pp.paf.ui.controller.ProcedureEditController.initializeRenderedAttributes())
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:hGrid alternateTextBinding="NO_ITEMS_FOUND@paResourceBundle"
           id="procHGrid"
           formSubmitted="true"
           proxyBinding="proxy@proxyBean@servletRequest"
           treeDataBinding="prereqResultTreeData@servletRequest"
           width="100%">
  <%-- hGrid columns --%>
  <uix:nodeStamp>
    <%-- prereq column --%>
    <uix:column renderedBinding="prereqColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PREREQUISITE@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="30%" cellNoWrapFormat="true"/>
      <uix:contents>
        <uix:styledText textBinding="prereqName"/>
      </uix:contents>
    </uix:column>
  </uix:nodeStamp>
  <uix:contents>
    <%-- status --%>
   	<uix:column renderedBinding="statusColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PREREQ_STATUS@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="10%" columnDataFormat="iconButtonFormat" cellNoWrapFormat="true"/>
      <uix:contents>
        <uix:styledText styleClassBinding="style" textBinding="status"/>		
      </uix:contents>
    </uix:column>
    <%-- detail --%>
    <uix:column renderedBinding="detailsColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PREREQ_DETAILS@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="80%" cellNoWrapFormat="false"/>
      <uix:contents>
        <uix:formattedText textBinding="description"/>
      </uix:contents>
    </uix:column>
  </uix:contents>
</uix:hGrid>
