<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.
 *
 * Page to edit a deployment procedure.
 *
 * Inputs:
 *   String headerKey@servletRequest
 *   [everything expected by pageButtons.jsp]
 *   ProcedureBean procedureBean@servletRequest
 *   boolean nameInputReadOnly@servletRequest
 *   boolean descInputReadOnly@servletRequest
 *   [everything expected by procedureHGrid.jsp]
 *   [everything expected by templateBase.jspf]
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="(headerKey@servletRequest)@paResourceBundle">
    <uix:contents>
      <%-- Run and Save buttons --%>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:labeledFieldLayout width="75%" columns="1">
        <uix:contents>
          <%-- Procedure Name --%>
          <uix:messageTextInput nameBinding="PA_NAME_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_NAME_EDIT_INPUT_PROMPT@paResourceBundle"
                                required="yes"
                                textBinding="translatedName@procedureBean@servletRequest"
                                disabledBinding="nameInputDisabledOnly@servletRequest"
                                columns="40"
                                maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>
          <%-- Procedure Description --%>
          <uix:messageTextInput nameBinding="PA_DESC_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_DESC_EDIT_INPUT_PROMPT@paResourceBundle"
                                textBinding="translatedDescription@procedureBean@servletRequest"
                                readOnlyBinding="descInputReadOnly@servletRequest"
                                columns="40"
                                maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>
          <%-- Staging Area --%>
          <uix:messageTextInput nameBinding="PA_STAGING_AREA_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_STAGING_AREA_EDIT_INPUT_PROMPT@paResourceBundle"
                                textBinding="stagingArea@procedureBean@servletRequest"
                                tipBinding = "PA_STAGING_AREA_TIP@paResourceBundle"
                                readOnlyBinding="stagingAreaInputReadOnly@servletRequest"
                                columns="40"
                                maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>
          <%-- Sudo Command and Path--%>
          <uix:messageTextInput nameBinding="PA_SUDO_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_SUDO_EDIT_INPUT_PROMPT@paResourceBundle"
                                textBinding="sudoCommand@procedureBean@servletRequest"
                                tipBinding = "PA_SUDO_COMMAND_TIP@paResourceBundle"
                                readOnlyBinding="sudoInputReadOnly@servletRequest"
                                columns="40"
                                maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>
          <%-- Pam Command and Path--%>
          <uix:messageTextInput nameBinding="PA_PAM_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_PAM_EDIT_INPUT_PROMPT@paResourceBundle"
                                textBinding="pamCommand@procedureBean@servletRequest"
                                tipBinding = "PA_PAM_COMMAND_TIP@paResourceBundle"
                                readOnlyBinding="PamInputReadOnly@servletRequest"
                                columns="40"
                                maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>
          <uix:messageLayout promptBinding="PA_SHELL_EDIT_PROMPT@paResourceBundle"
                             tipBinding="PA_SHELL_TYPE_COMMAND_TIP@paResourceBundle">
            <uix:choice nameBinding="PA_SHELL_TYPE_CHOICE@paResourceBundle"
                        selectedValueBinding="shellType@procedureBean@servletRequest"
                        readOnlyBinding="shellInputReadOnly@servletRequest">
              <uix:contents>
                <uix:option text="perl"
                            value="perl"/>
                <uix:option text="sh"
                            value="sh"/>
              </uix:contents>
            </uix:choice>
            <uix:textInput nameBinding="PA_SHELL_COMMAND_EDIT_INPUT@paResourceBundle"
                           textBinding="shellCommand@procedureBean@servletRequest"
                           readOnlyBinding="shellInputReadOnly@servletRequest"
                           columns="31"
                           maximumLength="2000"/>
          </uix:messageLayout>
          <%-- Shell type and command --%>
          <uix:spacer height="10" width="10"/>
          <%-- Environment Variables --%>
          <uix:messageTextInput nameBinding="PA_ENV_VAR_EDIT_INPUT@paResourceBundle"
                                promptBinding="PA_ENV_VAR_EDIT_INPUT_PROMPT@paResourceBundle"
                                textBinding="setupEnvironmentVariables@procedureBean@servletRequest"
                                tipBinding = "PA_ENV_VAR_TIP@paResourceBundle"
                                readOnlyBinding="envVarInputReadOnly@servletRequest"
                                rows="7"
                                columns="42"
                                wrap="off"
                                maximumLength="4000"/>
          <uix:spacer height="10" width="10"/>
          <%-- Notification Flag --%>
          <uix:messageCheckBox nameBinding="PA_NOTIFICATION_CHECK@paResourceBundle"
                               promptBinding="PA_NOTIFICATION_PROMPT@paResourceBundle"
                               checkedBinding="isNotificationEnabled@procedureBean@servletRequest"/>
          <uix:spacer height="10" width="10"/>
          <%-- Notification Prepend String --%>
          <uix:messageTextInput nameBinding="PA_NOTIFICATION_PREPEND_INPUT@paResourceBundle"
                                promptBinding="PA_NOTIFICATION_PREPEND_INPUT_PROMPT@paResourceBundle"
                                tipBinding = "PA_NOTIFICATION_PREPEND_TIP@paResourceBundle"
                                textBinding="notificationPrependString@procedureBean@servletRequest"
                                columns="35"
                                maximumLength="30"/>
          <uix:spacer height="10" width="10"/>
          <%-- Notification Status List --%>
          <uix:messageList nameBinding="PA_NOTIFICATION_STATUS_LIST@paResourceBundle"
                           promptBinding="PA_NOTIFICATION_STATUS_LIST_PROMPT@paResourceBundle"
                           tipBinding="PA_NOTIFICATION_STATUS_LIST_TIP@paResourceBundle"
                           multiple="true"
                           size="7">
            <uix:contents childDataBinding="statusList@servletRequest">
              <uix:option textBinding="(statusStringID)@paResourceBundle"
                          valueBinding="statusCode"
                          selectedBinding="selected"/>
            </uix:contents>
          </uix:messageList>
          <uix:spacer height="10" width="10"/>
          <%-- Note Area --%>
          <uix:messageTextInput nameBinding="PA_NOTEMESSAGE_AREA_EDIT_INPUT@paResourceBundle"
                    promptBinding="PA_TARGETS_NOTES_CH@paResourceBundle"
                    textBinding="noteMessage@procedureBean@servletRequest"
                    columns="40"
                    maximumLength="2000"/>
          <uix:spacer height="10" width="10"/>

        </uix:contents>
      </uix:labeledFieldLayout>
      <%-- Procedure Detail HGrid --%>
      <uix:include node="procedureHGrid.jsp"/>
      <uix:spacer width="10" height="10"/>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
