<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 * HGrid to display procedure detail in view, edit, and status pages.
 *
 * Inputs:
 *   SimpleTreeData procedureTreeData@servletRequest
 *   HGridProxyBean proxyBean@servletRequest
 *   a bunch more (see oracle.sysman.pp.paf.ui.controller.ProcedureEditController.initializeRenderedAttributes())
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:hGrid alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
           id="procHGrid"
           formSubmitted="true"
           partialRenderMode="self"
           proxyBinding="proxy@proxyBean@servletRequest"
           treeDataBinding="procedureTreeData@servletRequest"
           width="100%">
  <%-- hGrid columns --%>
  <uix:nodeStamp>
    <%-- Step name column --%>
    <uix:column renderedBinding="stepColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_STEP_NAME_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="30%" cellNoWrapFormat="false"/>
      <uix:contents>
        <uix:styledText styleClassBinding="style"
                        textBinding="stepName"
                        destinationBinding="destination"/>
      </uix:contents>
    </uix:column>
  </uix:nodeStamp>
  <uix:contents>
    <%-- save the step name --%>
    <uix:formValue name="name"
                   valueBinding="stepName"/>
    <%-- save the GUID --%>
    <uix:formValue name="guid"
                   valueBinding="guid"/>
    <%-- breakpoint --%>
    <uix:column renderedBinding="breakpointColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_BREAKPOINT_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="iconButtonFormat" />
      <uix:contents>
        <uix:image sourceBinding="breakpoint_img"/>
      </uix:contents>
    </uix:column>
    <%-- running status --%>
   	<uix:column renderedBinding="statusColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_STATUS_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="10%" columnDataFormat="iconButtonFormat" cellNoWrapFormat="true"/>
      <uix:contents>
        <uix:styledText textBinding="status"/>
      </uix:contents>
    </uix:column>
    <%-- step type --%>
    <uix:column renderedBinding="typeColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_TYPE_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="1" cellNoWrapFormat="false"/>
      <uix:contents>
        <uix:styledText styleClassBinding="style"
                        textBinding="type"/>
      </uix:contents>
    </uix:column>
    <%-- step description --%>
    <uix:column renderedBinding="descriptionColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_DESCRIPTION_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="80%" cellNoWrapFormat="false"/>
      <uix:contents>
        <uix:styledText styleClassBinding="style"
                        textBinding="description"/>
      </uix:contents>
    </uix:column>
    <%-- Execution Privilege --%>
    <uix:column renderedBinding="executionPrivilegeColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_EXECUTION_PRIVILEGE_CHOICE_PROMPT@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="0%" cellNoWrapFormat="true"/>
      <uix:contents>
      
       <uix:styledText renderedBinding="executionPrivilegeColumnTextRendered"
                       textBinding="runAsString"/>

       <uix:messageChoice nameBinding="PA_EXECUTION_PRIVILEGE_CHOICE@paResourceBundle"
                           renderedBinding="executionPrivilegeColumnRendered"
                           onChange="submitForm('pafForm', false, {'event':'execPrivChoiceChange'})"
                           selectedValueBinding="runAsString">
          <uix:contents childDataBinding="privileges">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
      </uix:contents>
    </uix:column>
    <%-- Execution Privilege Command --%>
    <uix:column renderedBinding="executionPrivilegeColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_EXECUTION_PRIVILEGE_DETAIL_SHORT_PROMPT@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="0%" cellNoWrapFormat="true"/>
      <uix:contents>
        <uix:messageTextInput nameBinding="PA_EXECUTION_PRIVILEGE_DETAIL_INPUT@paResourceBundle"
                              renderedBinding="privilegeCommandRendered"
                              textBinding="privilegeCommand"
                              readOnlyBinding="executionPrivilegeCommandColumnReadOnly@servletRequest"
                              columns="20"/>
      </uix:contents>
    </uix:column>
    <%-- Error handling --%>
    <uix:column renderedBinding="errorHandlingColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_ERROR_HANDLING_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat width="0%" cellNoWrapFormat="true"/>
      <uix:contents>
        <uix:styledText textBinding="errorHandling"
                        renderedBinding="errorHandlingColumnTextRendered@servletRequest"/>
        <uix:messageChoice nameBinding="PA_ERROR_HANDLING_EDIT_CHOICE@paResourceBundle"
                           renderedBinding="errorHandlingColumnChoiceRendered@servletRequest"
                           onChange="submitForm('pafForm', false, {'event':'errorModeChoiceChange'})"
                           selectedValueBinding="errorHandling">
          <uix:contents childDataBinding="errorHandlingChoices">
            <uix:option textBinding="(textKey)@paResourceBundle"
                        valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
      </uix:contents>
    </uix:column>
    <%-- delete icon --%>
    <uix:column renderedBinding="deleteColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_DELETE_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="iconButtonFormat" />
      <uix:contents>
        <uix:image sourceBinding="delete_img" destination="procedureEdit?event=delete"/>
      </uix:contents>
     </uix:column>
    <%-- step is enabled icon
    <uix:column renderedBinding="enabledColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_ENABLED_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="iconButtonFormat" />
      <uix:contents>
        <uix:image sourceBinding="status_img"
                   shortDescBinding="enabledStatusDesc"/>
      </uix:contents>
    </uix:column>
    --%>
    <%-- time and date when the step is run --%>
   	<uix:column renderedBinding="startDateColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_START_DATE_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:contents>
        <uix:styledText textBinding="startDate"/>
      </uix:contents>
    </uix:column>
    <%-- elapsed time from start date --%>
   	<uix:column renderedBinding="elapsedTimeColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_ELAPSED_TIME_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:contents>
        <uix:styledText textBinding="elapsedTime"/>
      </uix:contents>
    </uix:column>
    <%-- time and date when the step is completed --%>
   	<uix:column renderedBinding="completedDateColumn@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="PA_PROC_COMPLETED_DATE_CH@paResourceBundle"/>
      </uix:columnHeader>
      <uix:contents>
        <uix:styledText textBinding="completedDate"/>
      </uix:contents>
    </uix:column>
  </uix:contents>
  <uix:tableSelection>
    <uix:multipleSelection renderedBinding="hGridSelectionRendered@servletRequest"
                           disabledBinding="disabled"
                           selectionBinding="selected">
      <uix:contents>
        <%-- Enable a step --%>
        <uix:submitButton textBinding="PA_ENABLE_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_ENABLE@paResourceBundle"
                          disabledBinding="enabledBtnDisabled@servletRequest"
                          renderedBinding="enabledBtnRendered@servletRequest"
                          shortDescBinding="PA_ENABLE_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Disable a step --%>
        <uix:submitButton textBinding="PA_DISABLE_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_DISABLE@paResourceBundle"
                          disabledBinding="disabledBtnDisabled@servletRequest"
                          renderedBinding="disabledBtnRendered@servletRequest"
                          shortDescBinding="PA_DISABLE_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Delete a step --%>
        <uix:submitButton textBinding="PA_DELETE_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_DELETE@paResourceBundle"
                          disabledBinding="deleteBtnDisabled@servletRequest"
                          renderedBinding="deleteBtnRendered@servletRequest"
                          shortDescBinding="PA_DELETE_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Insert a step --%>
        <uix:submitButton textBinding="PA_INSERT_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_INSERT@paResourceBundle"
                          disabledBinding="insertBtnDisabled@servletRequest"
                          renderedBinding="insertBtnRendered@servletRequest"
                          shortDescBinding="PA_INSERT_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Edit a step --%>
        <uix:submitButton textBinding="PA_EDIT_STEP_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_EDIT_STEP@paResourceBundle"
                          disabledBinding="editStepBtnDisabled@servletRequest"
                          renderedBinding="editStepBtnRendered@servletRequest"
                          shortDescBinding="PA_EDIT_STEP_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Stop a running instance --%>
        <uix:submitButton textBinding="PA_STOP_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_STOP@paResourceBundle"
                          disabledBinding="stopBtnDisabled@servletRequest"
                          renderedBinding="stopBtnRendered@servletRequest"
                          shortDescBinding="PA_STOP_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Pause a running instance --%>
        <uix:submitButton textBinding="PA_PAUSE_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_PAUSE@paResourceBundle"
                          disabledBinding="pauseBtnDisabled@servletRequest"
                          renderedBinding="pauseBtnRendered@servletRequest"
                          shortDescBinding="PA_PAUSE_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Resume a paused instance --%>
        <uix:submitButton textBinding="PA_RESUME_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_RESUME@paResourceBundle"
                          disabledBinding="resumeBtnDisabled@servletRequest"
                          renderedBinding="resumeBtnRendered@servletRequest"
                          shortDescBinding="PA_RESUME_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Ignore a failed job --%>
        <uix:submitButton textBinding="PA_IGNORE_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_IGNORE@paResourceBundle"
                          disabledBinding="ignoreBtnDisabled@servletRequest"
                          renderedBinding="ignoreBtnRendered@servletRequest"
                          shortDescBinding="PA_IGNORE_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
        <%-- Retry a failed instance/job --%>
        <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                          name="event"
                          valueBinding="PA_RETRY@paResourceBundle"
                          disabledBinding="retryBtnDisabled@servletRequest"
                          renderedBinding="retryBtnRendered@servletRequest"
                          shortDescBinding="PA_RETRY_BTN_TIP@paResourceBundle"
                          unvalidated="true"/>
      </uix:contents>
    </uix:multipleSelection>
  </uix:tableSelection>
  <uix:tableActions>
    <uix:flowLayout renderedBinding="tableActionRendered@servletRequest">
      <uix:contents>
        <uix:cellFormat>
          <%-- Edit a procedure --%>
          <uix:submitButton textBinding="PA_EDIT_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_EDIT_PROCEDURE@paResourceBundle"
                            renderedBinding="editBtnRendered@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <%-- Run a procedure --%>
          <uix:submitButton textBinding="PA_RUN_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RUN_PROCEDURE@paResourceBundle"
                            renderedBinding="runBtnRendered@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <%-- Cancel changes --%>
          <uix:submitButton textBinding="PA_CANCEL_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_CANCEL@paResourceBundle"
                            unvalidated="true"
                            renderedBinding="cancelBtnRendered@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <%-- Save a procedure --%>
          <uix:submitButton textBinding="PA_SAVE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_SAVE@paResourceBundle"
                            renderedBinding="saveBtnRendered@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <%-- Refresh the page --%>
          <uix:submitButton textBinding="PA_REFRESH_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_REFRESH@paResourceBundle"
                            renderedBinding="refreshBtnRendered@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <%-- Finish editing/viewing a procedure --%>
          <uix:submitButton textBinding="PA_DONE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_DONE@paResourceBundle"
                            renderedBinding="doneBtnRendered@servletRequest"/>
        </uix:cellFormat>
      </uix:contents>
    </uix:flowLayout>
  </uix:tableActions>
</uix:hGrid>
