<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 * Page to view a deployment procedure.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  07/03/07 - For adding note
 *  ktamtoro  04/10/07 - add shell type and shell command fields
 *  ktamtoro  10/05/06 - Backport ktamtoro_bug-5381533 from main
 *  rlemos    09/27/06 -
 *  ktamtoro  07/07/06 - Add textbox for environment variables
 *  ktamtoro  07/07/06 - Add textbox for environment variables
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main
 *  ktamtoro  12/12/05 -
 *  zsamar    11/11/05 - bugfix:4657396 - getProceduretype changed to getProcedureTypeDescription
 *  ktamtoro  08/10/05 - ktamtoro_paf_ui_revert
 *  ktamtoro  08/10/05 - created
 *
 * Inputs:
 *   [everything expected by pageButtons.jsp]
 *   ProcedureBean procedureBean@servletRequest
 *   [everything expected by procedureHGrid.jsp]
 *   [everything expected by templateBase.jspf]
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                 valueBinding="GUID@procedureBean@servletRequest"/>
  <uix:header textBinding="PA_REVERT_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat>
            <uix:styledText textBinding="PA_REVERT_PROCEDURE_MSG@paResourceBundle"
                            styleClass="OraInstructionText"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat>
            <uix:spacer width="10" height="10"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <%-- General Information --%>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat>
            <uix:messageComponentLayout fieldWidth="100%">
              <uix:contents>
                <uix:messageLayout promptBinding="PA_VERSION_CHOICE_PROMPT@paResourceBundle">
                  <%-- Version choice --%>
                   <uix:choice nameBinding="PA_VERSION_CHOICE@paResourceBundle"
                               selectedValueBinding="versionValue@servletRequest"
                               onChange="submitForm('pafForm', true, {'event':'versionChange'})">
                     <uix:contents childDataBinding="versions@servletRequest">
                       <uix:option textBinding="version"
                                   valueBinding="procGUID"/>
                     </uix:contents>
                   </uix:choice>
                </uix:messageLayout>
                <uix:messageLayout prompt="">
                  <uix:spacer width="12" height="12"/>
                </uix:messageLayout>
                <%-- Procedure name
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_NAME_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="translatedName@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                --%>
                <%-- Procedure name (editable) --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_NAME_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:textInput textBinding="translatedName@procedureBean@servletRequest"
                                       styleClass="OraDataText"
                                       nameBinding="PA_REVERT_NAME_INPUT@paResourceBundle"
                                       readOnlyBinding="procedureNameReadOnly@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Procedure description --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_DESCRIPTION_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="translatedDescription@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Procedure type --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_TYPE_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="procedureTypeDescription@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Created by --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_CREATED_BY_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="createdBy@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Version
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_VERSION_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="version@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                --%>
                <%-- Staging area path --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_STAGING_AREA_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="stagingArea@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Sudo Path/Command --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_SUDO_COMMAND_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="sudoCommand@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- PAM Path/Command --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_PAM_COMMAND_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="pamCommand@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Shell Command --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_SHELL_COMMAND_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="shellTypeAndCommand@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Environment Variables --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_ENV_VAR_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:textInput textBinding="setupEnvironmentVariables@procedureBean@servletRequest"
                                       rows="7"
                                       columns="42"
                                       wrap="off"
                                       readOnly="true"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Notification Flag --%>
                <uix:messageLayout promptBinding="PA_NOTIFICATION_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:checkBox nameBinding="PA_NOTIFICATION_CHECK@paResourceBundle"
                                      checkedBinding="isNotificationEnabled@procedureBean@servletRequest"
                                      readOnly="true"/>
                     </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Notification Prepend String --%>
                <uix:messageLayout promptBinding="PA_NOTIFICATION_PREPEND_INPUT_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="notificationPrependString@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Notification Status List --%>
                <uix:messageLayout promptBinding="PA_NOTIFICATION_STATUS_LIST_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:list nameBinding="PA_NOTIFICATION_STATUS_LIST@paResourceBundle"
                                  multiple="true"
                                  size="7"
                                  readOnly="true">
                          <uix:contents childDataBinding="statusList@servletRequest">
                            <uix:option textBinding="(statusStringID)@paResourceBundle"
                                        valueBinding="statusCode"
                                        selectedBinding="selected"/>
                          </uix:contents>
                        </uix:list>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:messageLayout>
                <%-- Last updated --%>
                <uix:messageLayout promptBinding="PA_VIEW_INFO_PROCEDURE_LAST_UPDATED_PROMPT@paResourceBundle">
                  <uix:contents>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat>
                        <uix:styledText textBinding="lastUpdated@procedureBean@servletRequest"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                  </uix:messageLayout>
                  <%-- Note Message --%>
                  <uix:messageLayout promptBinding="PA_TARGETS_NOTES_CH@paResourceBundle">
                    <uix:contents>
                      <uix:rowLayout width="100%">
                        <uix:cellFormat>
                          <uix:styledText textBinding="noteMessage@procedureBean@servletRequest"
                            styleClass="OraDataText"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:messageLayout>
              </uix:contents>
            </uix:messageComponentLayout>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:spacer height="10" width="10"/>
      <%-- Procedure Detail HGrid --%>
      <uix:include node="procedureHGrid.jsp"/>
      <uix:spacer width="10" height="10"/>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
