<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       procedureStatus.jsp
 *
 *      NOTES
 *       Page to check the status of a running instance of a deployment procedure.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  07/04/07 - For changing jobs tab name
 *  ptorreti  07/12/07 - Adding delete button
 *  ptorreti  10/06/06 - Backport ptorreti_bug5215217 from main
 *  ktamtoro  08/03/06 - Backport ktamtoro_bug-5412873 from main
 *  ptorreti  07/25/06 - addding elapsed time as table header 
 *  ktamtoro  01/23/06 - Add scheduled time
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  01/23/06 - Add scheduled time
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  01/24/06 - XbranchMerge ktamtoro_paf_bugfixes_3 from main
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main
 *  ktamtoro  09/19/05 - Move auto-refresh to base template
 *  ktamtoro  09/02/05 - Remove auto refresh
 *  ktamtoro  08/25/05 - Display error handling mode
 *  ktamtoro  08/23/05 - Update status string
 *  ktamtoro  08/19/05 - Add refresh timestamp and auto-refresh
 *  ktamtoro  08/18/05 - Add form value to hold instance guid
 *  ktamtoro  08/12/05 - Move status columns to left
 *  ktamtoro  08/08/05 -
 *  sonorato  08/04/05 -
 *  ktamtoro  08/03/05 -
 *  ktamtoro  07/30/05 -
 *  fantic    07/12/05 -
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/28/05 - created
 *
 * Inputs:
 *   [everything expected by pageButtons.jsp]
 *   DeploymentBean deploymentBean@servletRequest
 *   [everything expected by procedureHGrid.jsp]
 *   [everything expected by templateBase.jspf]
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_STATUS_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:spacer height="10" width="10"/>
      <%-- Instance General Status --%>
      <uix:header textBinding="PA_STATUS_GENERAL_INFO_HDR@paResourceBundle">
        <uix:contents>
          <uix:spacer height="10" width="10"/>
          <%-- Instance GUID --%>
          <uix:formValue nameBinding="PA_INSTANCE_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="instanceGUID@deploymentBean@servletRequest"/>
          <uix:messageComponentLayout rows="6"
                                      columns="2"
                                      fieldWidth="100%">
            <uix:contents>
               <%-- left column row 1 --%>
              <%-- Instance Name --%>
              <uix:messageLayout promptBinding="PA_INFO_INSTANCE_NAME_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="translatedInstanceName@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 2 --%>
              <%-- Procedure Name --%>
              <uix:messageLayout promptBinding="PA_INFO_PROCEDURE_NAME_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="procedureName@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 3 --%>
              <%-- Procedure Version --%>
              <uix:messageLayout promptBinding="PA_INFO_PROCEDURE_VERSION_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="procedureVersion@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 4 --%>
              <%-- Error Handling Mode --%>
              <uix:messageLayout promptBinding="PA_INFO_ERROR_HANDLING_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="errorHandlingModeString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 5 --%>
              <%-- Instance Status --%>
              <uix:messageLayout promptBinding="PA_INFO_STATUS_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="statusString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 6 --%>
              <%-- Owner of the instance --%>
              <uix:messageLayout promptBinding="PA_INFO_OWNER_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="owner@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 1 --%>
              <%-- Date and Time the instance is created --%>
              <uix:messageLayout promptBinding="PA_INFO_CREATED_ON_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="createdOnDateString@deploymentBean@servletRequest"
                  							  styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 2 --%>
              <%-- Date and Time the instance is scheduled to run --%>
              <uix:messageLayout promptBinding="SUMMARY_SCHEDULED@jobsResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="scheduledDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 3 --%>
              <%-- Date and time the instance starts executing --%>
              <uix:messageLayout promptBinding="PA_INFO_START_DATE_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="startDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 4 --%>
              <%-- Last Updated date --%>
              <uix:messageLayout promptBinding="PA_INFO_LAST_UPDATED_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="lastUpdatedString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 5 --%>
              <%-- Date and time the instance is completed --%>
              <uix:messageLayout promptBinding="PA_INFO_COMPLETED_DATE_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="completedDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:messageLayout promptBinding="PAF_ELAPSED_TIME_HEAD@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="procedureElapsedTime@deploymentBean@servletRequest"
                                                                                styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>

            </uix:contents>
          </uix:messageComponentLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>
      <%-- Procedure HGrid --%>
      <uix:header textBinding="PA_STATUS_DETAIL_INFO_HDR@paResourceBundle">
        <uix:contents>
          <%-- Subtab links --%>
          <uix:subTabLayout>
            <uix:subTabBar>
              <uix:contents>
                <%-- Selected link: steps --%>
                <uix:link textBinding="PA_STEPS_LINK@paResourceBundle"
                          destinationBinding="stepsLink@servletRequest"
                          selected="true"/>
                <%-- jobs link --%>
                <uix:link textBinding="PA_JOB_DETAILS@paResourceBundle"
                          destinationBinding="jobsLink@servletRequest"
                          selected="false"/>
		<%-- Results link --%>
                <uix:link textBinding="PA_RESULTS_LINK@paResourceBundle"
                          destinationBinding="resultsLink@servletRequest"
                          renderedBinding="showResultsLink@servletRequest"
                          disabledBinding="enableResultsLink@servletRequest"
                          selected="false"/>
                <%-- log file link --%>
                <uix:link textBinding="PA_OMS_LOG@paResourceBundle"
                          destinationBinding="logLink@servletRequest"
                          selected="false"/>
              </uix:contents>
            </uix:subTabBar>
            <uix:contents>
              <%-- Procedure Detail HGrid --%>
              <uix:include node="procedureHGrid.jsp"/>
            </uix:contents>
          </uix:subTabLayout>
        </uix:contents>
      </uix:header>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
