<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.
 *
 *      NAME
 *       procedureStatusDetail.jsp
 *
 *      NOTES
 *       Page to view detailed status of a step.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  10/06/06 - Backport ptorreti_bug5215217 from main
 *  rahgupta  08/09/06 - Backport rahgupta_bug-5247357 from main
 *  rahgupta  07/11/06 - Backport rahgupta_bug-4707884 from main
 *  ktamtoro  01/24/06 - XbranchMerge ktamtoro_paf_bugfixes_3 from main
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main
 *  zsamar    12/08/05 - XbranchMerge zsamar_bugfixes_4766942_4770543_4770566
 *                       from main
 *  ptorreti  07/27/06 - adding elapsed time
 *  rahgupta  07/31/06 - Add button to retry with different parameters
 *  rahgupta  06/22/06 - Add instruction column in targets table
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  12/12/05 -
 *  zsamar    11/29/05 - bug fix 4766942
 *  fantic    11/18/05 - adding maximum length limits for input text boxes
 *  fantic    11/14/05 - add link to custom status monitoring ui for each step
 *  rahgupta  11/18/05 - use translatedName and translatedDescription
 *  zsamar    10/28/05 - Add ignore and retry buttons for global job step
 *  ktamtoro  09/19/05 - Hide note tip when not needed
 *  ktamtoro  09/16/05 - Add column for notes
 *  ktamtoro  08/30/05 - disable buttons if paused or aborted or completed
 *  ktamtoro  08/25/05 - display error handling mode of the step
 *  ktamtoro  08/18/05 - add form value to hold instance guid and step guid
 *  ktamtoro  08/12/05 - Move status columns to left
 *  ktamtoro  08/08/05 -
 *  ktamtoro  08/05/05 -
 *  ktamtoro  08/04/05 - fix table data binding
 *  ktamtoro  08/03/05 -
 *  ktamtoro  08/01/05 - update source of target table
 *  ktamtoro  07/28/05 -
 *  sonorato  07/12/05 -
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/28/05 - created
 *
 * Inputs:
 *   [everything expected by pageButtons.jsp]
 *   DeploymentBean deploymentBean@servletRequest
 *   [everything expected by templateBase.jspf]
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_STATUS_STEP_DETAIL_HDR@paResourceBundle">
  	<uix:contents>
			<uix:rowLayout width="100%">
				<uix:contents>
					<uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
			</uix:rowLayout>
      <uix:spacer height="10" width="10"/>
			<%-- Step General Information --%>
			<uix:header textBinding="PA_STATUS_GENERAL_INFO_HDR@paResourceBundle">
				<uix:contents>
          <uix:spacer height="10" width="10"/>
          <%-- Instance GUID --%>
          <uix:formValue nameBinding="PA_INSTANCE_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="instanceGUID@deploymentBean@servletRequest"/>
          <%-- Step GUID --%>
          <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="stepGUID@selectedStep@deploymentBean@servletRequest"/>
          <uix:labeledFieldLayout width="450" columns="1">
            <uix:contents>
              <%-- Step Name --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedStepName@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Step Type --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_TYPE_PROMPT@paResourceBundle"
              											 textBinding="(stepTypeString@selectedStep@deploymentBean@servletRequest)@paResourceBundle"
              											 styleClass="OraDataText"/>
              <%-- Step Decription --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_DESCRIPTION_PROMPT@paResourceBundle"
              											 textBinding="translatedDescription@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Error Handling Mode --%>
              <uix:messageStyledText promptBinding="PA_INFO_ERROR_HANDLING_PROMPT@paResourceBundle"
              											 textBinding="errorHandlingModeString@selectedStep@deploymentBean@servletRequest"
              											 renderedBinding="errorHandlingModeRendered@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- The instance the step belongs to --%>
              <uix:messageStyledText promptBinding="PA_INFO_INSTANCE_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedInstanceName@deploymentBean@servletRequest"
              											 destinationBinding="instanceDestinationURL@deploymentBean@servletRequest"
              											 styleClass="OraLinkText"/>
              <%-- Step Status --%>
              <uix:messageStyledText promptBinding="PA_INFO_STATUS_PROMPT@paResourceBundle"
              											 textBinding="statusString@selectedStep@deploymentBean@servletRequest"
              											 destinationBinding="headerStatusDestinationURL@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the step is executed --%>
              <uix:messageStyledText promptBinding="PA_INFO_START_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateStartedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the step execution is completed --%>
              <uix:messageStyledText promptBinding="PA_INFO_COMPLETED_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateCompletedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
               <%-- FOR ET BEGIN --%>
               <uix:messageLayout promptBinding="PAF_ELAPSED_TIME_HEAD@paResourceBundle"
              											 renderedBinding="elapsedTimeGlobalRender@servletRequest">
                <uix:contents>
                  <uix:styledText textBinding="elapsedTime@selectedStep@deploymentBean@servletRequest"
              											 renderedBinding="elapsedTimeGlobalRender@servletRequest"
                                                                                styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
	      <%-- FOR ET END --%>

              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>


      <%-- This part is shown for global job step --%>
      <uix:header textBinding="PA_STATUS_JOB_HDR@paResourceBundle"
                  renderedBinding="isGlobalJobStep@selectedStep@deploymentBean@servletRequest">
        <uix:contents>
          <uix:labeledFieldLayout width="60%">
            <uix:contents childDataBinding="displayedTableData@targetsTable@servletRequest">
              <uix:messageStyledText promptBinding="PA_TARGETS_STATUS_CH@paResourceBundle"
                                     textBinding="stepStatus"
                                     destinationBinding="statusDestination"
                                     targetFrame="_blank"
                                     styleClass="OraDataText"/>
              <uix:spacer height="10" width="10"/>
              <uix:messageStyledText promptBinding="PA_TARGETS_JOB_STATUS_CH@paResourceBundle"
                                     styleClass="OraDataText">
                <uix:contents>
                  <uix:link textBinding="jobStatus"
                            destinationBinding="jobDestination"
                            targetFrame="_blank"/>
                </uix:contents>
              </uix:messageStyledText>
              <uix:spacer height="10" width="10"/>
              <uix:messageTextInput nameBinding="PA_TARGETS_NOTE_INPUT@paResourceBundle"
                                   promptBinding="PA_TARGETS_NOTES_CH@paResourceBundle"
                                   columns="50"
                                   maximumLength="150"
                                   textBinding="note"
                                   renderedBinding="noteInputRendered"
                                   readOnlyBinding="noteInputReadOnly"/>
              <uix:spacer height="10" width="10"/>
              <uix:flowLayout>
                <uix:contents>
                  <uix:submitButton textBinding="PA_IGNORE_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_IGNORE_GLOBAL_JOB@paResourceBundle"
                                    disabledBinding="ignoreDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="ignoreButtonRendered@selectedStep@deploymentBean@servletRequest"
                                    unvalidated="true"/>
                  <%-- Retry a failed job --%>
                  <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_RETRY_GLOBAL_JOB@paResourceBundle"
                                    disabledBinding="retryDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="retryButtonRendered@selectedStep@deploymentBean@servletRequest"/>
                  <%-- Retry a failed job with different parameters --%>
                  <uix:submitButton textBinding="PA_RETRY_DIFF_PARAM_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_UPDATE_AND_RETRY_GLOBAL_JOB@paResourceBundle"
                                    disabledBinding="retryDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="retryButtonRendered@selectedStep@deploymentBean@servletRequest"/>
                   <uix:formValue nameBinding="PA_STATE_GUID_FORM_VALUE@paResourceBundle"
                                  valueBinding="stateGUID"/>


                </uix:contents>
              </uix:flowLayout>


            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:tip>
				    <uix:contents>
				      <uix:formattedText textBinding="PA_GLOBAL_JOB_STEP_TIP@paResourceBundle"/>
				    </uix:contents>
				 </uix:tip>
        </uix:contents>
      </uix:header>


      <%-- This part is shown for manual step --%>
			<uix:header textBinding="PA_STATUS_MANUAL_HDR@paResouceBundle"
			            renderedBinding="isGlobalManualStep@selectedStep@deploymentBean@servletRequest">
				<uix:contents>
				  <uix:tip>
				    <uix:contents>
				      <uix:formattedText textBinding="PA_MANUAL_INSTRUCTION_TIP@paResourceBundle"/>
				    </uix:contents>
				  </uix:tip>
          <uix:spacer height="10" width="10"/>
          <uix:labeledFieldLayout width="60%">
            <uix:contents>
              <%-- Instruction for manual step --%>
              <uix:messageTextInput nameBinding="PA_STATUS_INSTRUCTION_INPUT@paResourceBundle"
                                    textBinding="value@translatedGlobalManualInstruction@selectedStep@deploymentBean@servletRequest"
                                    rows="10"
                                    columns="50"
                                    readOnly="true"/>
              <%-- Note by the user --%>
              <uix:messageTextInput nameBinding="PA_TARGETS_NOTE_INPUT@paResourceBundle"
                                    promptBinding="PA_TARGETS_NOTES_CH@paResourceBundle"
                                    columns="50"
                                    maximumLength="150"
                                    textBinding="manualStepNote@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="isGlobalManualStep@selectedStep@deploymentBean@servletRequest"
                                    readOnlyBinding="isGlobalManualStepConfirmed@selectedStep@deploymentBean@servletRequest"/>
              <uix:spacer height="10" width="10"/>
              <uix:submitButton textBinding="PA_GLOBAL_CONFIRM_BTN@paResourceBundle"
                                name="event"
                                valueBinding="PA_GLOBAL_CONFIRM@paResourceBundle"
                                disabledBinding="confirmDisabled@selectedStep@deploymentBean@servletRequest"
                                renderedBinding="isGlobalManualStep@selectedStep@deploymentBean@servletRequest"/>
             </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>
			<%-- Targets table --%>
			<uix:header textBinding="PA_STATUS_TARGETS_HDR@paResourceBundle"
			            renderedBinding="hasTargets@selectedStep@deploymentBean@servletRequest">
				<uix:contents>
          <uix:table id="targetsTable"
                     nameBinding="PA_STATUS_TARGETS_TABLE@paResourceBundle"
                     alternateTextBinding="PA_TARGETS_STATUS_ALTERNATE_TEXT@paResourceBundle"
                     tableDataBinding="displayedTableData@targetsTable@servletRequest"
                     blockSizeBinding="blockSize@targetsTable@servletRequest"
                     maxValueBinding="maxValue@targetsTable@servletRequest"
                     minValueBinding="minValue@targetsTable@servletRequest"
                     valueBinding="currentValue@targetsTable@servletRequest"
                     partialRenderMode="self"
                     showAll="yes"
                     formSubmitted="true"
                     width="100%">
            <uix:contents>
              <%-- Target --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortableBinding="PA_TARGETS_TARGET_CH_NAME@sortColumnHeader@targetsTable@servletRequest"
                                      valueBinding="PA_TARGETS_TARGET_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_TARGET_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="targetName"/>
                            <%--destinationBinding="targetDest"--%>
                </uix:contents>
              </uix:column>
              <%-- Breakpoint --%>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_BREAKPOINT_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat" />
                <uix:contents>
                  <uix:image sourceBinding="breakpoint_img"/>
                </uix:contents>
              </uix:column>
              <%-- Step Status --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortableBinding="PA_TARGETS_STATUS_CH_NAME@sortColumnHeader@targetsTable@servletRequest"
                                      valueBinding="PA_TARGETS_STATUS_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_STATUS_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                 <uix:link textBinding="stepStatus"
                           destinationBinding="statusDestination"
                           targetFrame="_blank"/>
                </uix:contents>
              </uix:column>
              <%-- Instruction --%>
              <uix:column renderedBinding="isManualStep@selectedStep@deploymentBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      valueBinding="PA_TARGETS_INSTRUCTION_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_INSTRUCTION_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageTextInput nameBinding="PA_STATUS_INSTRUCTION_INPUT@paResourceBundle"
                                        prompt=""
                                        rows="2"
                                        columns="50"
                                        textBinding="instruction"
                                        readOnly="true"/>
                </uix:contents>
                <uix:columnFormat cellNoWrapFormat="false"/>
              </uix:column>
              <%-- Note --%>
              <uix:column renderedBinding="isNotComputationalStep@selectedStep@deploymentBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      valueBinding="PA_TARGETS_NOTES_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_NOTES_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageTextInput nameBinding="PA_TARGETS_NOTE_INPUT@paResourceBundle"
                                        prompt=""
                                        rows="2"
                                        columns="50"
                                        maximumLength="150"
                                        wrap="off"
                                        textBinding="note"
                                        renderedBinding="noteInputRendered"
                                        readOnlyBinding="noteInputReadOnly"/>
                </uix:contents>
                <uix:columnFormat cellNoWrapFormat="false"/>
              </uix:column>
              <%-- Job Status (not shown for manual steps) --%>
              <uix:column renderedBinding="hasJobs@selectedStep@deploymentBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader sortableBinding="PA_TARGETS_JOB_STATUS_CH_NAME@sortColumnHeader@targetsTable@servletRequest"
                                      valueBinding="PA_TARGETS_JOB_STATUS_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_JOB_STATUS_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="jobStatus"
                            destinationBinding="jobDestination"/>
<%--
                            targetFrame="_blank"/>
--%>
                </uix:contents>
              </uix:column>
              <%-- Target Type --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortableBinding="PA_TARGETS_TARGET_TYPE_CH_NAME@sortColumnHeader@targetsTable@servletRequest"
                                      valueBinding="PA_TARGETS_TARGET_TYPE_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_TARGET_TYPE_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="targetType"/>
                </uix:contents>
              </uix:column>
              <%-- Job ID --%>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:sortableHeader sortableBinding="PA_TARGETS_JOB_GUID_CH_NAME@sortColumnHeader@targetsTable@servletRequest"
                                      valueBinding="PA_TARGETS_JOB_GUID_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_JOB_GUID_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="jobGUID"/>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortable="false"
                            valueBinding="elapsedTime@deploymentBean@servletRequest"
                                      textBinding="PAF_ELAPSED_TIME_HEAD@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:styledText textBinding="elapsedTime"/>
                </uix:contents>
              </uix:column>
              <%-- step guid --%>
              <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                             valueBinding="guid"/>
              <%-- state guid --%>
              <uix:formValue nameBinding="PA_STATE_GUID_FORM_VALUE@paResourceBundle"
                             valueBinding="stateGUID"/>
            </uix:contents>
            <uix:tableSelection>
              <uix:multipleSelection renderedBinding="isNotComputationalStep@selectedStep@deploymentBean@servletRequest"
                                     disabledBinding="disabled"
                                     selectionBinding="selected">
                <uix:contents>
                  <%-- Ignore a failed job --%>
                  <uix:submitButton textBinding="PA_IGNORE_BTN@paResourceBundle"
                                    shortDescBinding="PA_IGNORE_BTN_TIP@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_IGNORE@paResourceBundle"
                                    disabledBinding="ignoreDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="ignoreButtonRendered@selectedStep@deploymentBean@servletRequest"
                                    unvalidated="true"/>
                  <%-- Retry a failed job --%>
                  <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                                    shortDescBinding="PA_RETRY_BTN_TIP@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_RETRY@paResourceBundle"
                                    disabledBinding="retryDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="retryButtonRendered@selectedStep@deploymentBean@servletRequest"/>
                  <%-- Retry a failed job with different parameters --%>
                  <uix:submitButton textBinding="PA_RETRY_DIFF_PARAM_BTN@paResourceBundle"
                                    shortDescBinding="PA_RETRY_DIFF_PARAM_BTN_TIP@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_RETRY_DIFF_PARAM@paResourceBundle"
                                    disabledBinding="retryDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="retryButtonRendered@selectedStep@deploymentBean@servletRequest"/>
                  <%-- Confirm a manual step on a particular target --%>
                  <uix:submitButton textBinding="PA_CONFIRM_BTN@paResourceBundle"
                                    shortDescBinding="PA_CONFIRM_BTN_TIP@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_CONFIRM@paResourceBundle"
                                    disabledBinding="confirmDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="isManualStep@selectedStep@deploymentBean@servletRequest"/>
                </uix:contents>
              </uix:multipleSelection>
            </uix:tableSelection>
          </uix:table>
				  <uix:tip renderedBinding="isNotComputationalStep@selectedStep@deploymentBean@servletRequest">
				    <uix:contents>
				      <uix:formattedText textBinding="PA_NOTE_TIP@paResourceBundle"/>
				    </uix:contents>
				  </uix:tip>
        </uix:contents>
      </uix:header>
      <uix:rowLayout width="100%">
        <uix:spacer width="10" height="10"/>
      </uix:rowLayout>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
		</uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
